// Loading Display
function display_loading() {
  $('#loading-display').fadeIn(400)
  $('#loading-display-icon').fadeIn(1000).addClass("pulse");
}

function hide_loading() {
  $('#loading-display-icon').delay(750).fadeOut(1000).removeClass("pulse");
  $('#loading-display').delay(750).fadeOut(400)
}
// ---

// Form Handling
function disable_form() {
  $('#install-form-button').prop("disabled", true);
}

function enable_form() {
  $('#install-form-button').prop("disabled", false);
}
// ---

// Input Handling
function sanitise_username(e) { // prevent foreign characters
	var k = e.keyCode || e.which;
	var ok = k >= 65 && k <= 90 || // A-Z
		k >= 96 && k <= 105 || // a-z
		k >= 35 && k <= 40 || // arrows
		k == 9 || //tab
		k == 46 || //del
		k == 8 || // backspaces
		(!e.shiftKey && k >= 48 && k <= 57); // only 0-9 (ignore SHIFT options)

  console.log(ok);

	if(!ok || (e.ctrlKey && e.altKey)){
		e.preventDefault();
	}
}
// ---

// Error Handling
function flash_error(error_selector, delay = 750) {
  $(error_selector).show();

  setTimeout(function() { $(error_selector).fadeOut(); }, delay);
}
// ---
