// Option Related Functions
// Constructs the input request data when option is clicked
// Input request data is loaded as {"*input name*": "*input id*"}
// On click, the inputs id is replaced by its' value, and then request is executed
function prepare_and_execute_option_request(status, e) {
  var invalid = false;
  var load_input_request_data = $(e).parent().find(".option-request-data").val();
  var parse_input_request_data = JSON.parse(load_input_request_data);
  var filled_input_request_data = {};

  filled_input_request_data["new_data"] = 'false';
  filled_input_request_data["status"] = status; // adds the new status to the request data array
  filled_input_request_data["uniqueid"] = get_selected_visitor_uniqueid(); // adds the selected user uniqueid to the request data array

  // begin process of replacing input ids with input values, ready to be sent to controller
  for (var i = 0; i < parse_input_request_data.length; i++) {
    for (var [input_name, input_id] of Object.entries(parse_input_request_data[i])) {
      if (!validate_input(input_id)) { invalid = true; } // handles case where input is empty

      var content_of_id = $(input_id).val(); // loads the content of the input id
      filled_input_request_data[input_name] = content_of_id; // reconstructs request array with real value
    }
  }

  if (!invalid) {
    send_option_request(filled_input_request_data);
    reset_option_inputs();
  }
}

function send_option_request(option_data) {
  var request = {
    type: 'POST',
    url: urlroot + '/visitordatamanager/update_visitor_data',
    data: option_data,
    success: function(data) { handle_option_request_response(data); }
  }

  $.ajax(request);
}

function validate_input(id) {
  if ($(id).val().length == 0) {
    $(id).addClass("is-invalid");

    return false;
  }

  $(id).removeClass("is-invalid");
  return true;
}

function reset_option_inputs() {
  $('.entry-action-input').val("");
}

function handle_option_request_response(data) {
  var did_succeed = JSON.parse(data).status == 'true';

  if (did_succeed) { handle_option_success(); return }
  display_notification("error", "An error occured, please try again");
}

function handle_option_success() {
  display_notification("success", "The operation was completed successfully");
  view_visitor(get_selected_visitor_uniqueid());
}
// ---

// Selected Visitor Field Functions
function get_selected_visitor_uniqueid() {
  return $('input[name=selected_visitor_uniqueid]').val();
}

function clear_selected_visitor_uniqueid() {
  $('input[name=selected_visitor_uniqueid]').val("");
}

function set_selected_visitor_uniqueid(new_uniqueid) {
  $('input[name=selected_visitor_uniqueid]').val(new_uniqueid);
}
// ---

// Visitor Details Functions
function assign_visitor_click_count(count) {
  $('#visitor-click-count-text').text(count);
}

function assign_visitor_count(count) {
  $('#visitor-count-text').text(count);
}

function assign_elapsed_time(time) {
  $('#elapsed-time-text').text(time);
}

function assign_dashboard_details(parsed_data) {
  assign_visitor_click_count(parsed_data.visitor_click_count);
  assign_visitor_count(parsed_data.visitor_count);
  assign_elapsed_time(parsed_data.elapsed_time);
}

function fetch_dashboard_details() {
  var request = {
    type: 'GET',
    url: urlroot + '/dashboard/get_dashboard_details',
    success: function(data) { assign_dashboard_details(JSON.parse(data)); }
  };

  $.ajax(request);
}

function fetch_visitor_click_details() {
  var request = {
    type: 'GET',
    url: urlroot + '/dashboard/get_visitor_click_list',
    success: function(data) { assign_visitor_click_details(data) }
  }

  $.ajax(request);
}

function assign_visitor_click_details(data) {
  $('#visitor-click-list').html(data);
}

function display_visitor_click_details() {
  fetch_visitor_click_details();
  $('.visitor-click-details-modal').fadeIn();

}
// ---
