// Admin Setting Modal Functions
function hide_admin_setting_tabs() {
  $('.admin-modal-content-container').addClass("hidden");
}

function hide_add_user_response_messages() {
  $('.error-message').hide(); $('.success-message').hide();
}

function clear_add_user_input_fields() {
  $('#username').val("");
  $('#password').val("");
}

function show_admin_setting_tab(tab_id) {
  $(tab_id).removeClass("hidden");
}

function deactivate_admin_setting_nav_bar_links() {
  $('.modal-side-nav-bar-link').removeClass("active");
}

function hide_admin_setting_modal_if_visible(target) {
  if ($('.modal-overlay').is(":visible") && target.id == 'modal-overlay') {
    $('.modal-overlay').fadeOut();
  }
}

function show_admin_setting_modal() {
  $('.admin-settings-modal').fadeIn();
}

function toggle_selected_tab(selected_tab_link) {
  var linked_tab_id = selected_tab_link.attr("linked_to");

  if (linked_tab_id == 'manage_user_accounts') {
    load_admin_user_table_rows();
  } else {
    clear_admin_user_table_rows(); // clears admin user table when not viewed for performance enhancement
  }

  show_admin_setting_tab('#' + linked_tab_id);
  selected_tab_link.addClass("active");
}

function clear_admin_user_table_rows() {
  $("div[loaded_content=admin_user_table_rows]").html("");
}

function load_admin_user_table_rows() {
  var request = {
    type: 'GET',
    url: urlroot + '/user/display_users',
    success: function(data) { $("div[loaded_content=admin_user_table_rows]").html(data); }
  }

  $.ajax(request);
}

function delete_admin_user_row(username) {
  var request = {
    type: 'POST',
    url: urlroot + '/user/delete_user',
    data: {username: username},
    success: function(data) { handle_admin_user_row_deletion(data) }
  }

  $.ajax(request);
}

function handle_admin_user_row_deletion(data) {
  var feedback_msg_selector = "user-row-deletion";
  var msg_type = JSON.parse(data).status == 'true' ? '-success' : '-error';

  flash_error('.' + feedback_msg_selector + msg_type);
  load_admin_user_table_rows(); // reload to show instant changes
}

function handle_add_user_callback(data) {
  var feedback_msg_selector = "user-add";
  var msg_type = JSON.parse(data).status == 'true' ? '-success' : '-error';

  flash_error('.' + feedback_msg_selector + msg_type, 1000);
}
// ---
