DB['contact-forms'] = (function ($) {
    jQuery.fn.extend({
        slideRightShow: function () {
            return this.each(function () {

                $(this).show();
            });
        },
        slideLeftHide: function () {
            return this.each(function () {
                $(this).hide();

            });
        },
        slideRightHide: function () {
            return this.each(function () {
                $(this).hide('slide', {
                    direction: 'right'
                }, 1000);
            });
        },
        slideLeftShow: function () {
            return this.each(function () {
                $(this).show();

            });
        }

    });

    var globals = {
        asheSettings: {
            signatureID: "",
            signatureUrl: ""
        }
    };

    window['globals'] = globals;

    gem = {
        settings: {
            sendTo: "syst-mcp2@danskebank.dk",
            defaultFrom: "R3732WAS",
            defaultSubject: "Contact Form",
            geminiSubmitID: "sendbutton",
            customizedSubject: "",
            formContainerId: "contactFormGen",
            uploadContainerId: "generalUploadForm",
            receiptId: "contactFormGen-receipt",
            fieldsAllValid: false,
            formId: "",
            lanCode: "DK",
            minCount: 0,
            maxCount: 0,
            currentStep: 1,
            stepCount: 1,
            counterStart: 1000,
            numField: false,
            fields: [],
			bpmFields: [],
            fileCount: 0,
            fieldValPairDelim: ": ",
            multivalueDelim: "; ",
            tablevalueDelim: ", ",
            kvitURL: "",
            cprValidateMaxDate: "",
            cprValidMaxLimit: $("#__CPRValidMaxLimit").val(),
            resultTxt: "",
            finalResult: "",
            stepResults: [],
        },
        changeTriggers: ['number', 'alpha', 'alpha-number', 'email', 'dropdown', 'date-my', 'date', 'max-number', 'min-number', 'cpr-number', 'ssn-number', 'ssnFI-number', 'cvr-number', 'post-number', 'max-char', 'min-char', 'allow-symbols', 'upload-required', 'groupRadio', 'checkboxCollection', 'groupCheckbox', 'future-date', 'past-date', 'dob', 'cpr-range', 'futureDate-range', 'date-range', 'allowOnlyFutureDate', 'carRegNumber', 'aftaleNumber', 'price', 'ibanFI'],
        defaultClasses: ['default', 'required'],
        displayTriggers: ['showHideMeOnCheck'],
        errorObj: [],
        isBlurEvent: false,
        isPostValid: false,
        isDateValid: true,
        ismonthValid: true,
        splitClassStatus: false,
        eachStop: false,
        //countFld: $('textarea.textComment'),

        init: function () {

            var sessionStatus = false;
            var _listnercheck = function (e) {
                e.preventDefault();
                var sessionCheck = sessionStorage.getItem("sessionStatusSet");
                if (sessionCheck === 'active') {
                    gem.clearSession();
                }
            }

            window.addEventListener("unload", _listnercheck, false);

            window.onpageshow = function (event) {
                if (event.persisted) {
                    //if (sessionCheck === 'active') {
                        gem.clearSession('root');
                   // }
                }
            };

            var formId = $('#' + gem.settings.formContainerId).find('input#__formID').val();
            var stepCounts = $('#' + gem.settings.formContainerId).find('input#__stepCount').val();
            if (stepCounts == 'undefined' || stepCounts == '') {
                gem.settings.stepCount = 1;
            } else {
                gem.settings.stepCount = parseInt(stepCounts);
            }



            if (formId != '') {
                gem.settings.formContainerId = gem.settings.formContainerId + formId;
                $('.contactForm').attr('id', gem.settings.formContainerId);
            } else {
                gem.settings.formContainerId = gem.settings.formContainerId + '0';
                $('.contactForm').attr('id', gem.settings.formContainerId);
            }

            $("a.gonext").attr("href", "javascript:void(0)");
            $("a.goprev").attr("href", "javascript:void(0)");

            var paramSearch = DB.utils.getSearchParam();
            var isAsheValid = $("#__asheLogin").val();
            var asheItemID = $("#asheSettingsId").val();
            var hostNameSearch = document.location.hostname.indexOf("editor");
            if (isAsheValid === "yes" && !paramSearch.hasOwnProperty("code")) {
                if (hostNameSearch === -1) {
                    $(window).trigger("SHOW_SPINNER");
                    $("#body").css("display", "none");
                    gem.callingAsheSolution(asheItemID);
                }
            } else {
                if (isAsheValid === "yes") {
                    gem.asheSuccessFlow(asheItemID);
                }
            }

            $('.primary-nav .logo').on('click', function(e){
                e.preventDefault();
                if (isAsheValid === "yes" && asheItemID !== undefined) {
                    if (hostNameSearch === -1) {
                        gem.clearSession();
                    }
                }
            })

            $("#" + gem.settings.formContainerId).on("blur", "input", function (e) {
                e.preventDefault();
                if (isAsheValid === "yes" && asheItemID !== undefined) {
                    if (hostNameSearch === -1) {
                        if (gem.checkActiveSession(asheItemID)) {
                            gem.validate("blur", $(this));
                        } else {
                            document.location.reload();
                        }
                    } else {
                        gem.validate("blur", $(this));
                    }
                } else {
                    gem.validate("blur", $(this));
                }
            });
            $("#" + gem.settings.formContainerId).on("blur", "textarea", function (e) {
                e.preventDefault();
                if (isAsheValid === "yes" && asheItemID !== undefined) {
                    if (hostNameSearch === -1) {
                        if (gem.checkActiveSession(asheItemID)) {
                            gem.validate("blur", $(this));
                        } else {
                            document.location.reload();
                        }
                    } else {
                        gem.validate("blur", $(this));
                    }
                } else {
                    gem.validate("blur", $(this));
                }
            });

            $("#" + gem.settings.formContainerId).on("blur", ".responsive-dropdown", function (e) {
                e.preventDefault();
                if (isAsheValid === "yes" && asheItemID !== undefined) {
                    if (hostNameSearch === -1) {
                        if (gem.checkActiveSession(asheItemID)) {
                            gem.validate("blur", $(this));
                        } else {
                            document.location.reload();
                        }
                    } else {
                        gem.validate("blur", $(this));
                    }
                } else {
                    gem.validate("blur", $(this));
                }
            });

            $("a.step-indicator-link").unbind("click");

            $(".eSigning").on("click", function () {
                var isAsheValid = $("#__asheLogin").val();
                var asheItemID = $("#asheSettingsId").val();
                if (isAsheValid === "yes" && asheItemID !== undefined) {
                    var currID = $(".steps").find(".active").attr("id");
                    var currElement = $("#" + currID);
                    var validateSteps = false;
                    if (gem.uSubmitForm(currElement, validateSteps) === true) {
                        var txt = gem.settings.finalResult;
                        var signatureData = gem.formatBPMString(txt);
                        gem.createSignatureFlow(asheItemID, signatureData);
                    }
                }
            });

            $('#' + gem.settings.formContainerId).on('click', 'input[type="radio"]', function (e) {
                var self = $(this)
                var parentElement = self[0].parentNode.parentElement
                //self.removeClass('default')
                $(this).parent().find('.default').removeClass('default')
                if (self.prop('checked') === true) {
                    self.addClass('default')
                    gem.removeError('click', self, 'radio');
                }
                if ($(parentElement).hasClass('showHideMeOnCheck') === true) {
                    gem.changeEvent(self);
                }
            });

            $('#' + gem.settings.formContainerId).on('click', 'input[type="checkbox"]', function (e) {
                var self = $(this)
                var parentElement = self[0].parentNode.parentElement
                self.removeClass('default')
                if (self.prop('checked') === true) {
                    self.addClass('default')
                    gem.removeError('click', self, 'checkbox');
                }
                if ($(parentElement).hasClass('showHideMeOnCheck') === true) {
                    gem.changeEvent(self);
                }
            });

            $('#' + gem.settings.formContainerId).on('change', '.responsive-dropdown[data-selected-value]', function (e) {
                var self = $(this)
                var parentElement = self[0].parentNode.parentElement
                if ($(parentElement).hasClass('showHideMeOnSelect') === true) {
                    gem.changeEvent(self);
                }
            });

            $('#' + gem.settings.formContainerId).on('blur', '.verifyEmail', function (e) {
                gem.verifyEmail('blur', $(this));
            });

            $('a.gonext').on('click', function (e) {
                var currID = $('.steps').find('.active').attr('id')
                var currElement = $('#' + currID)
                var nextElement = currElement[0].nextElementSibling;
                var currStep = gem.currentStep(currID);
                if (gem.validate('click', currElement) === false) {
                    DB.trackFormStep('step' + (parseInt(currStep) + 1));
                    var validateSteps = true;
                    if ($(nextElement).hasClass('summary') === true) {
                        gem.uSubmitForm(currElement, validateSteps);
                        gem.summaryPage();
                    } else {
                        gem.uSubmitForm(currElement, validateSteps)
                    }
                }

            });

            $('a.goprev').on('click', function (e) {
                var currID = $('.steps').find('.active').attr('id');
                var currStepNum = gem.currentStep(currID);
                gem.navigateFrom(gem.settings.currentStep, gem.settings.currentStep - 1)
                gem.settings.currentStep = gem.settings.currentStep - 1;
            });


            $("#" + gem.settings.uploadContainerId).on('change', 'input[type=file]', function () {
                $('.filename').removeClass('input-error');
                $('#general-upload-files').find('.error_msg').remove();
            });

            $('.upload-sendform').on('click', function (e) {
                var formcontainer = document.getElementById(gem.settings.formContainerId);
                var currID = $('.steps').find('.active').attr('id')
                var currStep = gem.currentStep(currID);
                var currElement = $('#' + currID)
                if (gem.validate('click', currElement) === true) {
                    var validateSteps = false
                    if (gem.uSubmitForm(currElement, validateSteps) === true) {
                        gem.checkSubmit()
                    }
                } else {
                    DB.trackFormSubmit("Error in fields " + (gem.errorObj != null ? gem.errorObj.toString() : ""));
                }
            });

            $('.editSummary').on('click', function (e) {
                var currID = $('.steps').find('.active').attr('id');
                var currStepNum = gem.currentStep(currID);
                gem.navigateFrom(gem.settings.currentStep, 1)
            });

            $('.sendform').on('click', function (e) {
                if (gem.validate() === true) {
                    if (gem.nSubmitForm() === true) {

                    }
                }
            });

            $('.counter').on('focus keydown mousedown', function (e) {
                gem.counter(gem.settings.counterStart, $(this))
            });

            gem.uploadGeneral();
            gem.setTo(gem.settings.sendTo);
            gem.setFrom(gem.settings.defaultFrom);
            gem.setSubject(gem.settings.defaultSubject);
            gem.timestampFields();

            var lanCodeVal = $('#' + gem.settings.formContainerId).find('input#__lanCode').val()
            gem.settings.lanCode = lanCodeVal;
            gem.getLanguageCode(gem.settings.lanCode)
        },

        openSessionScreen: function () {
            $(".sessionModal").click();
        },

        checkActiveSession: function (id) {
            var origin = location.origin;
            var checkSessionURL =
                origin + "/api/Ashe/CheckActiveSession" + "?asheSettingsId=" + id;

            $.ajax({
                url: checkSessionURL,
                type: "GET",
                success: function (response) {
                    sessionStatus = response;
                },
                error: function (error) {
                    DB.track('Active session status failed ' + error);
                },
                async: false,
            });

            return sessionStatus;
        },
        resetTimer: function(){
            var time;
            var expireTime = 1000*60*30; // 30mins Idle time
            clearTimeout(time);
            time = setTimeout(gem.logout, expireTime)
        },
        logout: function(){
            gem.clearSession('root');
        },
        inactivityTime: function(){
            window.onload = gem.resetTimer;
            document.onmousemove = gem.resetTimer;
            document.onmousedown = gem.resetTimer; // touchscreen presses
            document.ontouchstart = gem.resetTimer;
            document.onclick = gem.resetTimer;     // touchpad clicks
            document.onkeydown = gem.resetTimer;   // onkeypress is deprectaed
            document.addEventListener('scroll', gem.resetTimer, true);
        },
        clearSession: function (path) {
            var origin = location.origin;
            var clearSessionURL = origin + "/api/Ashe/ClearSession";
            $.get(clearSessionURL, function (response) {
                if (response) {
                    if (path !== "root") {
                        window.location.reload();
                    } else {
                        window.location.assign("/");
                    }
                } else {
                    DB.track("ASHE session clear getting failed " + response);
                }
            }).fail(function () {
                DB.track('ASHE session clear getting failed');
            });
        },

        callingAsheSolution: function (id) {
            var origin = location.origin;
            var verifyRedirectURL =
                origin + "/api/Ashe/CallAsheWithParameters" + "?asheSettingsId=" + id;
            $.get(verifyRedirectURL, function (response) {
                if (response) {
                    var redirectURL = decodeURIComponent(response);
                    document.location.href = redirectURL;
                } else {
                    DB.track('Error in generating URL');
                }
            }).fail(function () {
                DB.track('ASHE logon redirection failed');
            });
        },
        formatBPMString: function (params) {
            params = params.replace(/!#/g, ";");
            var jsonString = "{";
            var items = params.split(";");
            for (var i = 0; i < items.length - 1; i++) {
                var current = items[i].split(": ");
                jsonString +=
                    '"' + current[0].trim() + '":"' + current[1].trim() + '",';
            }
            jsonString = jsonString.substr(0, jsonString.length - 1);
            jsonString += "}";
            //var convertString = JSON.stringify(jsonString);
            return jsonString;
        },
        asheSuccessFlow: function (id) {
            $(window).trigger("SHOW_SPINNER");
            var urlParams = DB.utils.getSearchParam();
            var authCode = DB.utils.getQueryParam("code");
            if (urlParams.hasOwnProperty("code")) {
                var authCode = DB.utils.getQueryStringValue("code");
                var authCodeLen = authCode.length;
                if (authCodeLen > 0) {
                    var origin = location.origin;
                    var verifyURL =
                        origin +
                        "/api/Ashe/VerifyCode?AuthorizationCode=" +
                        authCode +
                        "&asheSettingsId=" +
                        id;
                    $.get(verifyURL, function (status) {
                        if (status) {
                            gem.inactivityTime();
                            var newurl =
                                window.location.protocol +
                                "//" +
                                window.location.host +
                                window.location.pathname;
                            window.history.replaceState({
                                    path: newurl,
                                },
                                "",
                                newurl
                            );
                            sessionStorage.setItem("sessionStatusSet", "active");
                            var customerData = JSON.parse(status);
                            if (customerData.hasOwnProperty("CustomerNumber")) {
                                // Existing Customer
                                var customerNumber =
                                    customerData.CustomerNumber !== undefined ?
                                    customerData.CustomerNumber :
                                    " ";
                                if (customerData.identity !== null) {
                                    var firstName =
                                        customerData.identity.names.personNames[0].firstName;
                                    firstName = firstName !== undefined ? firstName : "";
                                    var lastName =
                                        customerData.identity.names.personNames[0].lastName;
                                    lastName = lastName !== undefined ? lastName : "";
                                    var fullName = firstName + " " + lastName;
                                    var email =
                                        customerData.contactInformation.emails[0].emailAddress;
                                    email = email !== undefined ? email : "";
                                    $(".prefillFirstName").val(firstName);
                                    $(".prefillLastName").val(lastName);
                                    $(".prefillName").val(fullName);
                                    $(".prefillEmail").val(email);
                                    if (firstName !== "undefined") {
                                        $(".prefillFirstName").attr("disabled", true);
                                    } else {
                                        $(".prefillFirstName").attr("disabled", false);
                                    }
                                    if (lastName !== "undefined") {
                                        $(".prefillLastName").attr("disabled", true);
                                    } else {
                                        $(".prefillLastName").attr("disabled", false);
                                    }
                                    if (fullName !== "undefined") {
                                        $(".prefillName").attr("disabled", true);
                                    } else {
                                        $(".prefillName").attr("disabled", false);
                                    }
                                    if (email !== "undefined") {
                                        $(".prefillEmail").attr("disabled", true);
                                    } else {
                                        $(".prefillEmail").attr("disabled", false);
                                    }
                                } else {
                                    $(".prefillName").val("");
                                    $(".prefillFirstName").val("");
                                    $(".prefillLastName").val("");
                                    $(".prefillEmail").val("");
                                }
                                $(".prefillCustomerNumber").val(customerNumber);
                                if (customerNumber !== "undefined") {
                                    $(".prefillCustomerNumber").attr("disabled", true);
                                } else {
                                    $(".prefillCustomerNumber").attr("disabled", false);
                                }
                            } else {
                                // Non Customer
                                var findCustomerID = JSON.parse(customerData.principal);
                                var filterCustomerId =
                                    findCustomerID.id !== undefined ? findCustomerID.id : " ";
                                $(".prefillCustomerNumber").val(filterCustomerId);
                                if (filterCustomerId !== "undefined") {
                                    $(".prefillCustomerNumber").attr("disabled", true);
                                } else {
                                    $(".prefillCustomerNumber").attr("disabled", false);
                                }
                            }
                            gem.showForm(true);
                        } else {
                            DB.track('not authorised user');
                        }
                    }).fail(function () {
                        DB.track('ASHE logon authorisation getting failed');
                    });
                }
            }
        },

        createSignatureFlow: function (asheItemID, data) {
            var origin = location.origin;
            var signatureFlowURL = origin + "/api/Ashe/CreateSignature";
            var signatureData = data;
            $.post(
                signatureFlowURL, {
                    asheSettingsId: asheItemID,
                    formData: data,
                },
                function (response) {
                    var signatureResponse = JSON.parse(response);
                    var signatureID = signatureResponse["signatureId"];
                    var signatureURL = signatureResponse["signatureURL"];
                    var signatureStatus = signatureResponse["success"];
                    if (signatureStatus) {
                        var frameHtml = gem.buildIframe(signatureURL);
                        if (frameHtml != "") {
                            $("meta[name=viewport]").remove();
                            $("head").append(
                                '<meta name="viewport" content="width=device-width,initial-scale=1.0" >'
                            );
                            $("#popLogin").html(frameHtml);
                            $("#login-modal").foundation("open").blur();
                        }
                        var origin = document.location.origin;
                        globals.asheSettings.signatureID = signatureID;
                        globals.asheSettings.signatureUrl = signatureURL;
                        var targetWindow = document.getElementById("myPopElement")
                            .contentWindow.parent; //added this
                        targetWindow.postMessage("ready", origin);
                        if (targetWindow.addEventListener) {
                            window.addEventListener("message", gem.handleIframe);
                        } else if (window.attachEvent) {
                            // ie8
                            window.attachEvent("onmessage", gem.handleIframe);
                        }
                    }
                }
            ).fail(function () {
                DB.track('ASHE esignature creation failed');
            });
        },
        handleIframe: function (event) {
            var signatureID = globals.asheSettings.signatureID;
            var signatureURL = globals.asheSettings.signatureUrl;
            switch (event.data) {
                case "ready":
                    var iframe = document.getElementById("myPopElement").contentWindow;
                    iframe.postMessage({
                            signatureId: signatureID,
                        },
                        signatureURL);
                    break;
                case "cancel":
                    gem.eSignCancel(event);
                    break;
                case "ok":
                    gem.signatureIsDone(signatureID);
                    break;
            }
        },
        buildIframe: function (url) {
            var iframeURL = url;
            var html = "";
            if (iframeURL !== undefined) {
                html += '<iframe id="myPopElement" src="' + iframeURL + "";
                html +=
                    '" frameborder="0" marginwidth="0" width="800" height="600" scrolling="auto"></iframe>';
            }
            return html;
        },

        signatureIsDone: function (id, data) {
            var signatureId = id;
            var asheItemID = $("#asheSettingsId").val();
            var signOffURL =
                origin +
                "/api/Ashe/EndSignature?signatureId=" +
                signatureId +
                "&asheSettingsId=" +
                asheItemID;
            $.get(signOffURL, function (response) {
                var signOffResponse = JSON.parse(response);
                var signOffStatus = signOffResponse["success"];
                var auditId = signOffResponse["auditId"];
                if (signOffStatus) {
                    $("#login-modal").trigger("close.zf.trigger");
                    $(".eSigning").addClass("hide");
                    var fetchAuditData = "Audit ID : " + auditId + "!#";
                    gem.settings.finalResult += fetchAuditData;
                    gem.settings.finalResult += gem.postText();
                    $(".upload-sendform").click();
                }
            }).fail(function () {
                DB.track('End of digital signature failed');
            });
        },

        eSignCancel: function () {
            window.removeEventListener("message", gem.handleIframe);
            $("#login-modal").trigger("close.zf.trigger");
        },

        showForm: function (validUser) {
            if (validUser) {
                $("#body").css("display", "block");
            } else {
                $("#body").css("display", "none");
            }
            setTimeout(function () {
                $(window).trigger("HIDE_SPINNER");
            }, 2000);
        },

        handleShowMeonChecked: function (target, classParams, mode) {
            var checkbox; // or radio.
            var cmd = 'hide';
            var orFlag = false;
            for (var i = 0; i < classParams.length; i++) {
                checkbox = document.getElementById(classParams[i]);
                if (checkbox && !orFlag) {
                    switch (mode) {
                        case 'hide':
                            if (checkbox.checked) {
                                cmd = 'hide';
                            } else {
                                cmd = 'show';
                            }
                            break;
                        case 'show':
                            if (checkbox.checked) {
                                cmd = 'show';
                            } else {
                                cmd = 'hide';
                            }
                            break;

                    }
                    if (cmd == 'hide') {
                        gem.hideElement(target);
                    } else {
                        gem.showElement(target);
                        window.setTimeout(function () {
                            target.style.display = "block";
                        }, 150);
                    }
                }
            }

        },
        handleShowMeonSelected: function (target, classParams, mode) {
            var selectbox = document.getElementById(classParams[1]);
            var cmd;
            if (selectbox) {
                var selectedvalue = gem.selectedValueOf(selectbox);
                selectedvalue = selectedvalue.replace(/\s+/g, '')
                switch (mode) {
                    case 'hide':
                        if (selectedvalue == classParams[2]) {
                            cmd = 'hide';
                        }
                        break;
                    case 'show':
                        if (selectedvalue == classParams[2]) {
                            cmd = 'show';
                        }
                        case 'follow':
                            cmd = 'hide';
                            for (var i = 1; i < classParams.length; i++) {
                                if (selectedvalue == classParams[i]) {
                                    cmd = 'show';
                                    break;
                                }
                            }
                            break;
                }
                if (cmd == 'hide') {
                    gem.hideElement(target);
                } else {
                    gem.showElement(target);
                    window.setTimeout(function () {
                        target.style.display = "block";
                    }, 150); // IE/CMS hack
                }
            }

        },
        selectedValueOf: function (field) {
            if ($(field).attr('data-module') == 'responsive-dropdown') {
                if ($(field).attr('data-selected-value') != "" || $(field).attr('data-selected-value') == undefined) {
                    return $(field).attr('data-selected-value');
                } else {
                    return $(field).attr('data-selected-value');
                }
            }
        },
        showElement: function (element) {
            gem.removeClass(element, 'hide');
            gem.addClass(element, 'show');
            if (element.style.display != '') element.style.display = 'block';
        },
        hideElement: function (element) {
            gem.removeClass(element, 'show');
            gem.addClass(element, 'hide');
            if (element.style.display != '') element.style.display = 'none';
        },
        addClass: function (target, theClass) {
            if (target) {
                if (!gem.hasClass(target, theClass)) {
                    if (target.className == "") {
                        target.className = theClass;
                    } else {
                        target.className += " " + theClass;
                    }
                }
            }
        },
        removeClass: function (target, theClass) {
            if (target) {
                var pattern = new RegExp("(^| )" + theClass + "( |$)");
                target.className = target.className.replace(pattern, "$1");
                target.className = target.className.replace(/ $/, "");
            }
        },
        hasClass: function (target, theClass) {
            var pattern = new RegExp("(^| )" + theClass + "( |$)");
            if (pattern.test(target.className)) {
                return true;
            }
            return false;
        },

        changeEvent: function (source) {
            var fld = $('#' + gem.settings.formContainerId).find('.fieldgroup');
            var rqdFldLen = fld.length
            var fldlist = [];
            for (j = 0; j < rqdFldLen; j++) {
                fldlist.push(fld[j])
                var fldClass = fldlist[j].className;
                gem.findDisplayClass(fld[j], fldClass)
            }

        },

        currentStep: function (currstep) {
            var currstep = currstep
            var classes = currstep.split('step');
            gem.settings.currentStep = parseInt(classes[1]);
            return classes[1];
        },

        navigateTo: function (from, to) {
            if (to != gem.settings.stepCount + 1) {
                $("div#step" + to).removeClass('init_hidden');
                $("div#step" + from).addClass('init_hidden');
                $("div#step" + from).removeClass('active');
                $("div#step" + to).addClass('active');

                //Accessibility
                $(".s" + from).removeAttr('aria-current');
                $(".s" + to).attr('aria-current', 'step');

                $('.s' + from + ' .step-indicator-link,' + '.s' + from + ' .step-state,' + '.s' + from).removeClass('active');
                $('.s' + to + ' .step-indicator-link,' + '.s' + to + ' .step-state,' + '.s' + to).addClass('active');
                $('html,body').animate({
                    scrollTop: $('.contactForm').offset().top
                }, 'slow');
            }
        },

        navigateFrom: function (to, from) {
            if (to != 1) {
                $("div#step" + from).addClass('active');
                $("div#step" + from).removeClass('init_hidden');
                $("div#step" + to).removeClass('active');
                $("div#step" + to).addClass('init_hidden');

                //Accessibility
                $(".s" + to).removeAttr('aria-current');
                $(".s" + from).attr('aria-current', 'step');
                
                $('.s' + to + ' .step-indicator-link,' + '.s' + to + ' .step-state,' + '.s' + to).removeClass('active');
                $('.s' + from + ' .step-indicator-link,' + '.s' + from + ' .step-state,' + '.s' + from).addClass('active');
                $('html,body').animate({
                    scrollTop: $('.contactForm').offset().top
                }, 'slow');
            }
        },

        uploadGeneral: function () {
            $("#generalUploadForm").on('change', 'input[type=file]', function () {
                $("#gu-alert-wrapper").hide();
                $("#general-upload-files .input-set .form-error").hide();
                var ext = this.value.substr(this.value.lastIndexOf('.') + 1);
                switch (ext.toLowerCase()) {
                    case "pdf":
                    case "doc":
                    case "docx":
                    case "txt":
                    case "xls":
                    case "xlsx":
                    case "jpg":
                    case "jpeg":
                    case "png":
                    case "gif":
                        break;
                    case '':
                        return false;
                    default:
                        gem.showErrorReceipt('attachFileType', $(this));
                        this.value = "";
                        return false;
                }
                gem.generalUploadAttach($(this));
                return false;
            });


            $("#gu-sendbutton").on('click', function () {
                gem.generalUploadSend();
                return false;
            });
        },

        counter: function (countVal, fld) {
            actualvalue = fld.val();
            actual = countVal - actualvalue.length;
            actdisplay = "( " + actual + " )";
            if (actual < 0 || actual > countVal) {
                actdisplay = "" + actual + ""
            }
            $("#count").html(actdisplay);
        },

        sortDataFields: function (formcontainer) {
            var count = gem.settings.fields.length + 1;
            var order;
            var fld;
            gem.settings.fields = []
            if (gem.settings.stepCount > 1) {
                var dataFlds = $('input.default,input.radioCollection:checked,input.checkboxCollection:checked,.responsive-dropdown,.groupCheckbox,textarea', formcontainer);
            } else {
                var dataFlds = $('input.default,input.radioCollection:checked,input.checkboxCollection:checked,.responsive-dropdown,.groupCheckbox,textarea', formcontainer);
            }
            for (var i = 0; i < dataFlds.length; i++) {
                fld = dataFlds[i];
                for (j = count; j < 1000; j++) {
                    if (gem.settings.fields[j] == undefined) {
                        gem.settings.fields[j] = fld;
                        break;
                    }
                }
                count = count++;
            }
        },

        getLanguageCode: function (lan) {
            if (lan == 'SE')
                return 'SE';
            else if (lan == 'DK')
                return 'DK';
            else if (lan == 'NO')
                return 'NO';
            else if (lan == 'FI')
                return 'FI';
            else if (lan == 'UK')
                return 'UK';

            else if (lan == 'EN')
                return 'UK';
            else
                return 'DK';
        },

        getErrorMessage: function (fieldName) {
            switch (gem.getLanguageCode(gem.settings.lanCode)) {
                case 'SE':
                    return error[fieldName].se.replace('***', gem.settings.minCount).replace('^^^', gem.settings.maxCount);
                case 'DK':
                    return error[fieldName].dk.replace('***', gem.settings.minCount).replace('^^^', gem.settings.maxCount);
                case 'FI':
                    return error[fieldName].fi.replace('***', gem.settings.minCount).replace('^^^', gem.settings.maxCount);
                case 'NO':
                    return error[fieldName].no.replace('***', gem.settings.minCount).replace('^^^', gem.settings.maxCount);
                case 'UK':
                    return error[fieldName].uk.replace('***', gem.settings.minCount).replace('^^^', gem.settings.maxCount);
                default:
                    return error[fieldName].dk.replace('***', gem.settings.minCount).replace('^^^', gem.settings.maxCount);
            }
        },

        findClass: function (target) {
            var relevant = false;
            var classes = target.split(' ');
            for (var i = 0; i < classes.length; i++) {
                var classFunction = classes[i];
                var count = (classFunction.match(/--/g) || []).length;
                if (count > 0) {
                    var firstSplit = classFunction.split('--');
                    var mainClass = firstSplit[0]
                    var secondSplit = firstSplit[1].split('-')
                    var minimum = secondSplit[0];
                    var maximum = secondSplit[1];
                    classFunction = mainClass
                    gem.settings.minCount = minimum;
                    gem.settings.maxCount = maximum;

                }
                if (classFunction != '' && gem.changeTriggers.indexOf(classFunction) > -1) {
                    relevant = true;
                    break;
                }
                if (classFunction != '' && gem.displayTriggers.indexOf(classFunction) > -1) {
                    relevant = true;
                    break;
                }
            }
            if (relevant === true) {
                return classFunction;
            }
        },
        getClassParts: function (theClass) {
            var Res = {
                classFunction: '',
                classParams: []
            };
            var classParts = theClass.split('~');
            Res.classFunction = classParts[0];
            classParts.shift();
            Res.classParams = classParts;
            return Res;
        },
        findDisplayClass: function (field, target) {
            var relevant = false;
            var pcElement = field;
            var classes = target.split(' ');
            for (var i = 0; i < classes.length; i++) {
                var classParts = gem.getClassParts(classes[i]);
                var classFunction = classParts.classFunction;
                var classParams = classParts.classParams;
                switch (classFunction) {
                    case 'showMeOnChecked':
                        gem.handleShowMeonChecked(pcElement, classParams, 'show');
                        break;
                    case 'hideMeOnChecked':
                        gem.handleShowMeonChecked(pcElement, classParams, 'hide');
                        break;
                    case 'showMeOnSelected':
                        gem.handleShowMeonSelected(pcElement, classParams, 'show');
                        break;
                    case 'hideMeOnSelected':
                        gem.handleShowMeonSelected(pcElement, classParams, 'hide');
                        break;

                }
            }

        },
        validateRequired: function (myEvent, fields) {
            if (myEvent == 'click') {
                var fld = $(fields).find('.default,.responsive-dropdown,.general-upload-files,.groupCheckbox,.groupRadio,.radioCollection,.checkboxCollection');
            } else {
                var fld = $(fields).parent().find('.default,.responsive-dropdown,.general-upload-files,.groupCheckbox,.groupRadio,.radioCollection,.checkboxCollection');
            }
            var rqdFldLen = fld.length
            var fldlist = [];
            for (j = 0; j < rqdFldLen; j++) {
                fldlist.push(fld[j])
                var fldClass = fldlist[j].className;
                switch (gem.findClass(fldClass)) {
                    case 'number':
                        var fldtype = "number";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case "price":
                        var fldtype = "price";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'email':
                        var fldtype = "email";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'alpha':
                        var fldtype = "alpha";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'alpha-number':
                        var fldtype = "alphanumber";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'dropdown':
                        var fldtype = "dropdown";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'date-my':
                        var fldtype = "datemy";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'date':
                        var fldtype = "date";
                        gem.validateFields(myEvent, fld, fldtype);
                        break;
                    case 'max-number':
                        var fldtype = "maxnumber";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'min-number':
                        var fldtype = "minnumber";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'max-char':
                        var fldtype = "maxchar";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'min-char':
                        var fldtype = "minchar";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'cpr-number':
                        var fldtype = "cpr";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'ssn-number':
                        var fldtype = "ssn";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'ssnFI-number':
                        var fldtype = "ssnFI";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'carRegNumber':
                        var fldtype = "carregnumber";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'aftaleNumber':
                        var fldtype = "aftalenumber";
                        gem.validateFields(myEvent, fields, fldtype);
                    case 'cvr-number':
                        var fldtype = "cvr";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'allow-symbols':
                        var fldtype = "symbols";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'post-number':
                        var fldtype = "postnumber";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'upload-required':
                        var fldtype = "upload";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'groupRadio':
                        var fldtype = "radio";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'checkboxCollection':
                        var fldtype = "checkbox";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'groupCheckbox':
                        var fldtype = "groupcheckbox";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'verifyEmail':
                        var fldtype = "repeatemail";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'future-date':
                        var fldtype = "futuredate";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'past-date':
                        var fldtype = "pastdate";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'dob':
                        var fldtype = "DOB";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'cpr-range':
                        var fldtype = "cprrange";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'futureDate-range':
                        var fldtype = "futdaterange";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'date-range':
                        var fldtype = "daterange";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case 'allowOnlyFutureDate':
                        var fldtype = "AllowOnlyFutureDate";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                    case "ibanFI":
                        var fldtype = "ibanfi";
                        gem.validateFields(myEvent, fields, fldtype);
                        break;
                }
            }
        },


        validateFields: function (myEvent, fields, fldtype) {
            if (fldtype != '' || fldtype != 'undefined') {
                switch (fldtype) {
                    case 'number':
                        var fields = $(fields).parent().find('.number:visible');
                        gem.validateNumber(myEvent, fields, fldtype);
                        break;
                    case "price":
                        var fields = $(fields).parent().find(".price:visible");
                        gem.validatePrice(myEvent, fields, fldtype);
                        break;
                    case 'email':
                        var fields = $(fields).parent().find('.email:visible');
                        gem.validateEmail(myEvent, fields, fldtype);
                        break;
                    case 'alpha':
                        var fields = $(fields).parent().find('.alpha:visible');
                        gem.validateAlpha(myEvent, fields, fldtype);
                        break;
                    case 'alphanumber':
                        var fields = $(fields).parent().find('.alpha-number:visible');
                        gem.validateAlphaNum(myEvent, fields, fldtype);
                        break;
                    case 'dropdown':
                        var fields = $(fields).parent().find('.dropdown:visible');
                        gem.validateDropdown(myEvent, fields, fldtype);
                        break;
                    case 'datemy':
                        var fields = $(fields).parent().find('.date-my:visible');
                        gem.validateMonth(myEvent, fields, fldtype);
                        break;
                    case 'date':
                        var fields = $(fields).parent().find('.date:visible');
                        gem.validateDate(myEvent, fields, fldtype);
                        break;
                    case 'maxnumber':
                        var fields = $(fields).parent().find('.max-number' + '--' + gem.settings.minCount + ':visible');
                        gem.validateMaxNumber(myEvent, fields, fldtype);
                        break;
                    case 'minnumber':
                        var fields = $(fields).parent().find('.min-number' + '--' + gem.settings.minCount + ':visible');
                        gem.validateMinNumber(myEvent, fields, fldtype);
                        break;
                    case 'maxchar':
                        var fields = $(fields).parent().find('.max-char' + '--' + gem.settings.minCount + ':visible');
                        gem.validateMaxChar(myEvent, fields, fldtype);
                        break;
                    case 'minchar':
                        var fields = $(fields).parent().find('.min-char' + '--' + gem.settings.minCount + ':visible');
                        gem.validateMinChar(myEvent, fields, fldtype);
                        break;
                    case 'cpr':
                        var fields = $(fields).parent().find('.cpr-number:visible');
                        gem.validateCprNumber(myEvent, fields, fldtype);
                        break;
                    case 'carregnumber':
                        var fields = $(fields).parent().find('.carRegNumber:visible');
                        gem.validateCarRegNumber(myEvent, fields, fldtype);
                        break;
                    case 'aftalenumber':
                        var fields = $(fields).parent().find('.aftaleNumber:visible');
                        gem.validateAftaleNumber(myEvent, fields, fldtype);
                        break;
                    case 'ssn':
                        var fields = $(fields).parent().find('.ssn-number:visible');
                        gem.validateSsnNumber(myEvent, fields, fldtype);
                        break;
                    case 'ssnFI':
                        var fields = $(fields).parent().find('.ssnFI-number:visible');
                        gem.validateSsnFINumber(myEvent, fields, fldtype);
                        break;
                    case "ibanfi":
                        var fields = $(fields).parent().find(".ibanFI:visible");
                        gem.validateIbanFINumber(myEvent, fields, fldtype);
                        break;
                    case 'cvr':
                        var fields = $(fields).parent().find('.cvr-number:visible');
                        gem.validateCvrNumber(myEvent, fields, fldtype);
                        break;
                    case 'symbols':
                        var fields = $(fields).parent().find('.allow-symbols:visible');
                        gem.validateSymbols(myEvent, fields, fldtype);
                        break;
                    case 'postnumber':
                        var fields = $(fields).parent().find('.post-number:visible');
                        var lCode = gem.getLanguageCode(gem.settings.lanCode)
                        gem.validatePostNumber(myEvent, fields, fldtype, lCode);
                        break;
                    case 'upload':
                        var fields = $(fields).parent().find('.upload-required:visible');
                        var lCode = gem.getLanguageCode(gem.settings.lanCode)
                        gem.validateUpload(myEvent, fields, fldtype, lCode);
                        break;
                    case 'radio':
                        var fields = $(fields).parent().find('.groupRadio:visible');
                        gem.validateRadio(myEvent, fields, fldtype);
                        break;
                    case 'checkbox':
                        var fields = $(fields).parent().find('.checkboxCollection.required:visible');
                        gem.validateCheckbox(myEvent, fields, fldtype);
                        break;
                    case 'groupcheckbox':
                        var fields = $(fields).parent().find('.groupCheckbox:visible');
                        gem.validateGroupCheckbox(myEvent, fields, fldtype);
                        break;
                    case 'repeatemail':
                        var fields = $(fields).parent().find('.verifyEmail:visible');
                        gem.validateRepeatEmail(myEvent, fields, fldtype);
                        break;
                    case 'futuredate':
                        var fields = $(fields).parent().find('.future-date' + '--' + gem.settings.minCount + ':visible');
                        gem.validateFutureDate(myEvent, fields, fldtype);
                        break;
                    case 'AllowOnlyFutureDate':
                        var fields = $(fields).parent().find('.allowOnlyFutureDate:visible');
                        gem.validateAllowOnlyFutureDate(myEvent, fields, fldtype);
                        break;
                    case 'pastdate':
                        var fields = $(fields).parent().find('.past-date' + '--' + gem.settings.minCount + ':visible');
                        gem.validatePastDate(myEvent, fields, fldtype);
                        break;
                    case 'DOB':
                        var fields = $(fields).parent().find('.dob:visible');
                        gem.validateDOB(myEvent, fields, fldtype);
                        break;
                    case 'cprrange':
                        var fields = $(fields).parent().find('.cpr-range' + '--' + gem.settings.minCount + '-' + gem.settings.maxCount + ':visible');
                        gem.validateCprRange(myEvent, fields, fldtype);
                        break;
                    case 'futdaterange':
                        var fields = $(fields).parent().find('.futureDate-range' + '--' + gem.settings.minCount + ':visible');
                        gem.validateFutDateRange(myEvent, fields, fldtype);
                        break;
                    case 'daterange':
                        var fields = $(fields).parent().find('.date-range' + '--' + gem.settings.minCount + '-' + gem.settings.maxCount + ':visible');
                        gem.validateDateRange(myEvent, fields, fldtype);
                        break;
                }
            }
        },

        validateIbanFINumber: function (myEvent, fields, fldtype) {
            if (myEvent === "blur") {
                if (fields != "" && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (
                            !/^(FI)[0-9A-Z]{2}[ ][0-9A-Z]{4}[ ][0-9A-Z]{4}[ ][0-9A-Z]{4}[ ][0-9A-Z]{1,2}|[0-9A-Z]{18}$/.test(
                                fields.val()
                            )
                        ) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != "" && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this);
                        if (fields.val().length > 0) {
                            if (
                                !/^(FI)[0-9A-Z]{2}[ ][0-9A-Z]{4}[ ][0-9A-Z]{4}[ ][0-9A-Z]{4}[ ][0-9A-Z]{1,2}|[0-9A-Z]{18}$/.test(
                                    fields.val()
                                )
                            ) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass("required") === true) {
                                gem.addError(myEvent, fields, fldtype);
                            }
                            if ($(fields).hasClass("notReq") === true) {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }
                    });
                }
            }
        },

        validateRadio: function (myEvent, fields, fldtype) {
            if (myEvent === 'click') {
                if (fields != '' && fields.length > 0 && fields.is(":visible") === true) {
                    $(fields).each(function (i) {
                        var fields = $(this).find('input');
                        var fldCheckedLen = $(this).find("input.radioCollection:checked").length
                        $(this).find('input').removeClass('input-error');
                        if (fldCheckedLen < 1) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            if ($(fields).hasClass('mustClick') === true) {
                                var fldInput = $(fields).parent().find('input.mustClick')
                                if (fldInput.is(':checked')) {
                                    gem.removeError(myEvent, fields, fldtype);
                                } else {
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }
                    });
                }
            }
        },
        validateCheckbox: function (myEvent, fields, fldtype) {
            if (myEvent === 'click') {
                if (fields != '' && fields.length > 0 && fields.is(":visible") === true) {
                    $(fields).each(function () {
                        var fields = $(this);
                        if (fields[0].checked === false) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    });
                }
            }
        },
        validateGroupCheckbox: function (myEvent, fields, fldtype) {
            if (myEvent === 'click') {
                if (fields != '' && fields.length > 0 && fields.is(":visible") === true) {
                    $(fields).each(function () {
                        var fields = $(this);
                        var fldCheckedLen = $(this).find("input.checkboxCollection:checked").length
                        $(this).find('input').removeClass('input-error');
                        if (fldCheckedLen < 1) {
                            gem.errorGroupShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }




                    });
                }
            }
        },
        validateRepeatEmail: function (myEvent, fields, fldtype) {
            if (myEvent === 'click') {
                if (fields != '' && fields.length > 0 && fields.is(":visible") === true) {
                    $(fields).each(function () {
                        var fields = $(this);
                        gem.verifyEmail(myEvent, fields);
                    });
                }
            }
        },
        validatePrice: function (myEvent, fields, fldtype) {
            if (myEvent === "blur") {
                if (fields != "" && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[0-9,\.]+$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        fields.parent().find(".error_msg").remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != "" && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this);
                        if (fields.val().length > 0) {
                            if (!/^[0-9,\.]+$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass("required") === true) {
                                gem.addError(myEvent, fields, fldtype);
                            }
                            if ($(fields).hasClass("notReq") === true) {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }
                    });
                }
            }
        },
        validateUpload: function (myEvent, fields, fldtype, lCode) {

            if (fields != '' && fields.length > 0 && fields.is(":visible") === true) {
                $(fields).each(function () {
                    var fields = $(this).find('tbody.filename');
                    if (fields[0].children.length < 1) {
                        gem.errorShow(myEvent, fields, fldtype);
                        $(fields).removeClass('input-error')
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                });
            }

        },

        validatePostNumber: function (myEvent, fields, fldtype, lCode) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0) {
                    if (fields.val().length > 0) {
                        var postVal = 'Nr' + fields.val();
                        gem.isPostValid = false;
                        $.each(PostNumre[lCode], function (key, value) {
                            if (key != postVal) {
                                $('#' + fields.attr('id') + '-value').val('');
                                $('#' + fields.attr('id') + '-hdn').val('');
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                                $('#' + fields.attr('id') + '-value').val(value);
                                $('#' + fields.attr('id') + '-hdn').val(value);
                                gem.isPostValid = true;
                                return false;
                            }



                        });

                        if (gem.isPostValid === false) {
                            gem.errorShow(myEvent, fields, fldtype);
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        $('#' + fields.attr('id') + '-value').val('');
                        $('#' + fields.attr('id') + '-hdn').val('');
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible") === true) {
                    if (fields.length > 1) {
                        $(fields).each(function () {
                            var fields = $(this)
                            if (fields.val().length > 0) {
                                //var self = fields
                                var postVal = 'Nr' + fields.val();
                                gem.isPostValid = false;
                                $.each(PostNumre[lCode], function (key, value) {
                                    if (key != postVal) {
                                        //gem.removeError(myEvent,fields,fldtype);
                                        $('#' + fields.attr('id') + '-value').val('');
                                        $('#' + fields.attr('id') + '-hdn').val('');
                                        //gem.errorShow(myEvent,fields,fldtype);
                                    } else {
                                        gem.removeError(myEvent, fields, fldtype);
                                        $('#' + fields.attr('id') + '-value').val(value);
                                        $('#' + fields.attr('id') + '-hdn').val(value);
                                        gem.isPostValid = true;
                                        return false;

                                    }
                                });
                                if (gem.isPostValid === false) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                if ($(fields).hasClass('required') === true) {
                                    $('#' + fields.attr('id') + '-value').val('');
                                    $('#' + fields.attr('id') + '-hdn').val('');
                                    gem.addError(myEvent, fields, fldtype)
                                }
                                if ($(fields).hasClass('notReq') === true) {
                                    $('#' + fields.attr('id') + '-value').val('');
                                    $('#' + fields.attr('id') + '-hdn').val('');
                                    gem.removeError(myEvent, fields, fldtype)
                                }

                            }

                        });

                    } else {
                        if (fields.val().length > 0) {
                            //var self = fields
                            var postVal = 'Nr' + fields.val();
                            gem.isPostValid = false;
                            $.each(PostNumre[lCode], function (key, value) {
                                if (key != postVal) {
                                    $('#' + fields.attr('id') + '-value').val('');
                                    $('#' + fields.attr('id') + '-hdn').val('');
                                } else {
                                    gem.removeError(myEvent, fields, fldtype);
                                    $('#' + fields.attr('id') + '-value').val(value);
                                    $('#' + fields.attr('id') + '-hdn').val(value);
                                    gem.isPostValid = true;
                                    return false;
                                }

                            });
                            if (gem.isPostValid === false) {
                                gem.errorShow(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                $('#' + fields.attr('id') + '-value').val('');
                                $('#' + fields.attr('id') + '-hdn').val('');
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                $('#' + fields.attr('id') + '-value').val('');
                                $('#' + fields.attr('id') + '-hdn').val('');
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }
                    }
                }
            }

        },

        validateMaxNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[0-9]+$/.test(fields.val())) {
                            fldtype = 'number';
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            if (fields.val().length > parseInt(gem.settings.minCount)) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[0-9]+$/.test(fields.val())) {
                                fldtype = 'number';
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                if (fields.val().length > parseInt(gem.settings.minCount)) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    gem.removeError(myEvent, fields, fldtype);
                                }
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[0-9]+$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[0-9]+$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateCprRange: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^\d{6}-{0,1}\d{3,5}[A-Za-z]{0,1}$/.test(fields.val())) {
                            var fldtype = 'cprformat';
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                            var validCPRDate = gem.cprDateCheck(fields);

                            if (fields.is(":visible") && fields.val().length > 0) {
                                if (!validCPRDate) {
                                    if (gem.isDateValid) {
                                        var fldtype = 'cprrange';
                                        gem.errorShow(myEvent, fields, fldtype);
                                    } else {
                                        fldtype = 'cpr'
                                        gem.errorShow(myEvent, fields, fldtype);
                                    }
                                } else {
                                    gem.removeError(myEvent, fields, fldtype);
                                }

                            } else {
                                fields.parent().find('.error_msg').remove();
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }

            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^\d{6}-{0,1}\d{3,5}[A-Za-z]{0,1}$/.test(fields.val())) {
                                fldtype = 'cprformat';
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                                var validCPRDate = gem.cprDateCheck(fields);

                                if (fields.is(":visible") && fields.val().length > 0) {
                                    if (!validCPRDate) {
                                        if (gem.isDateValid) {
                                            var fldtype = 'cprrange';
                                            gem.errorShow(myEvent, fields, fldtype);
                                        } else {
                                            fldtype = 'cpr'
                                            gem.errorShow(myEvent, fields, fldtype);
                                        }
                                    } else {
                                        gem.removeError(myEvent, fields, fldtype);
                                    }

                                } else {
                                    fields.parent().find('.error_msg').remove();
                                    gem.removeError(myEvent, fields, fldtype);
                                }

                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }

            }
        },

        validateDateRange: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validBirthDateRange = gem.birthDateMinMaxCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validBirthDateRange) {
                        if (gem.isDateValid) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            fldtype = 'date'
                            gem.errorShow(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!validBirthDateRange) {
                                if (gem.isDateValid) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    fldtype = 'date'
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }
                    });
                }
            }
        },

        validateMinNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[0-9]+$/.test(fields.val())) {
                            fldtype = 'number';
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            if (fields.val().length < parseInt(gem.settings.minCount)) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }
                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[0-9]+$/.test(fields.val())) {
                                fldtype = 'number';
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                if (fields.val().length < parseInt(gem.settings.minCount)) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    gem.removeError(myEvent, fields, fldtype);
                                }
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateMaxChar: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())) {
                            fldtype = 'alpha';
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            if (fields.val().length > parseInt(gem.settings.minCount)) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())) {
                                fldtype = 'alpha';
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                if (fields.val().length > parseInt(gem.settings.minCount)) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    gem.removeError(myEvent, fields, fldtype);
                                }
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateSymbols: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^(?:[a-zA-Z0-9£€ÀÈÌÒÙàèìòùÁÉÍÓÚÝáéíóúýÂÊÎÔÛâêîôûÃÑÕãñõÄËÏÖÜäëïöüÿ¡¿çÇßØøÅåÆæÞþÐðĄĆĘŁŃÓŚŹŻąćęłńóśźż@!#_\$\^%&*()+= \-\[\]\\\';,.\/\{\}\|\":\?\n]*)?$/g.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^(?:[a-zA-Z0-9£€ÀÈÌÒÙàèìòùÁÉÍÓÚÝáéíóúýÂÊÎÔÛâêîôûÃÑÕãñõÄËÏÖÜäëïöüÿ¡¿çÇßØøÅåÆæÞþÐðĄĆĘŁŃÓŚŹŻąćęłńóśźż@!#_\$\^%&*()+= \-\[\]\\\';,.\/\{\}\|\":\?\n]*)?$/g.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },

        validateCprNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^\d{6}-{0,1}\d{3,5}[A-Za-z]{0,1}$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^\d{6}-{0,1}\d{3,5}[A-Za-z]{0,1}$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateCarRegNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[a-zA-Z0-9 ]{1,7}$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[a-zA-Z0-9 ]{1,7}$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateAftaleNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[7-8]{1}[0-9]{7}$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[7-8]{1}[0-9]{7}$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateSsnNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^\d{6,8}[-|(\s)]{0,1}\d{4}$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);

                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^\d{6,8}[-|(\s)]{0,1}\d{4}$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateSsnFINumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^(0[1-9]|[1-2]\d|3[0-1])(0[1-9]|1[0-2])(\d{2})[\-aA]\d{3}[0-9a-zA-Z]$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);

                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^(0[1-9]|[1-2]\d|3[0-1])(0[1-9]|1[0-2])(\d{2})[\-aA]\d{3}[0-9a-zA-Z]$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateCvrNumber: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^(\d{6,8})[-]{0,1}\d{0,1}$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^(\d{6,8})[-]{0,1}\d{0,1}$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateMinChar: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    if (fields.val().length > 0) {
                        if (!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())) {
                            fldtype = 'alpha';
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            if (fields.val().length < parseInt(gem.settings.minCount)) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0 && fields.is(":visible")) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.val().length > 0) {
                            if (!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())) {
                                fldtype = 'alpha';
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                if (fields.val().length < parseInt(gem.settings.minCount)) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    gem.removeError(myEvent, fields, fldtype);
                                }
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },

        validateEmail: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0) {
                    if (fields.is(":visible") && fields.val().length > 0) {
                        if (!/^\w+([\u0080-\u00FF\u0100-\u017F\u0180-\u024F\.-]?\w+)*@\w+([\u0080-\u00FF\u0100-\u017F\u0180-\u024F\.-]?\w+)*(\.\w{2,10})+$/.test(fields.val())) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            if (!/^\w+([\u0080-\u00FF\u0100-\u017F\u0180-\u024F\.-]?\w+)*@\w+([\u0080-\u00FF\u0100-\u017F\u0180-\u024F\.-]?\w+)*(\.\w{2,10})+$/.test(fields.val())) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },

        validateAlpha: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0) {
                    if (fields.is(":visible") && $.trim(fields.val()).length > 0) {
                        if (!/^[a-zA-Z'.£€ÀÈÌÒÙàèìòùÁÉÍÓÚÝáéíóúýÂÊÎÔÛâêîôûÃÑÕãñõÄËÏÖÜäëïöüÿ¡¿çÇßØøÅåÆæÞþÐðĄĆĘŁŃÓŚŹŻąćęłńóśźż -]+$/.test($.trim(fields.val()))) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && $.trim(fields.val()).length > 0) {
                            if (!/^[a-zA-Z'.£€ÀÈÌÒÙàèìòùÁÉÍÓÚÝáéíóúýÂÊÎÔÛâêîôûÃÑÕãñõÄËÏÖÜäëïöüÿ¡¿çÇßØøÅåÆæÞþÐðĄĆĘŁŃÓŚŹŻąćęłńóśźż -]+$/.test($.trim(fields.val()))) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },

        validateAlphaNum: function (myEvent, fields, fldtype) {
            var specialChar = "()-_+={}[]:;,.?' ".replace(/([.*+?^=\-!:${}()|\[\]\/\\])/g, "\\$1");
            var digits = new RegExp('^[a-zA-Z0-9£€ÀÈÌÒÙàèìòùÁÉÍÓÚÝáéíóúýÂÊÎÔÛâêîôûÃÑÕãñõÄËÏÖÜäëïöüÿ¡¿çÇßØøÅåÆæÞþÐðĄĆĘŁŃÓŚŹŻąćęłńóśźż' + specialChar + ']+$');
            if (myEvent === 'blur') {
                if (fields != '' && fields.length > 0) {
                    if (fields.is(":visible") && $.trim(fields.val()).length > 0) {
                        if (!digits.test($.trim(fields.val()))) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }

                    } else {
                        fields.parent().find('.error_msg').remove();
                        gem.removeError(myEvent, fields, fldtype);
                    }
                }
            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && $.trim(fields.val()).length > 0) {
                            if (!digits.test($.trim(fields.val()))) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },

        validateDropdown: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields.is(":visible") === true) {
                    var selFld = fields['0'].attributes['data-selected-value'].value
                    if (selFld == '' && selFld.length > 0) {
                        gem.removeError(myEvent, fields, fldtype);
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                }
            } else {
                if (fields.is(":visible") === true) {
                    $(fields).each(function () {
                        var fields = $(this)
                        var selFld = fields['0'].attributes['data-selected-value'].value;
                        if (selFld == '') {
                            if ($(fields).hasClass('required') === true) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }
                        } else {
                            gem.removeError(myEvent, fields, fldtype);
                        }
                    });

                }
            }
        },

        validateMonth: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validDate = gem.monthValidCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validDate) {
                        gem.errorShow(myEvent, fields, fldtype);
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {

                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            var validDate = gem.monthValidCheck(fields);
                            if (!validDate) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }
        },
        validateDate: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validDate = gem.dateValidCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validDate) {
                        gem.errorShow(myEvent, fields, fldtype);
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {

                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            var validDate = gem.dateValidCheck(fields);
                            if (!validDate) {
                                gem.errorShow(myEvent, fields, fldtype);
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },
        validateFutureDate: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validFutureDate = gem.futureDateCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validFutureDate) {
                        if (gem.isDateValid) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            fldtype = 'date'
                            gem.errorShow(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            var validFutureDate = gem.futureDateCheck(fields);
                            if (!validFutureDate) {
                                if (gem.isDateValid) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    fldtype = 'date'
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },
        validateFutDateRange: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                if (fields.hasClass('customCPRValid')) {
                    fldtype = 'futdaterange1'
                    var validFutureDate = gem.futureDateRangeCPRCheck(fields);
                } else {
                    var validFutureDate = gem.futureDateRangeCheck(fields);
                }
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validFutureDate) {
                        if (gem.isDateValid) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            fldtype = 'date'
                            gem.errorShow(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {

                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            if (fields.hasClass('customCPRValid')) {
                                fldtype = 'futdaterange1'
                                var validFutureDate = gem.futureDateRangeCPRCheck(fields);
                            } else {
                                var validFutureDate = gem.futureDateRangeCheck(fields);
                            }
                            if (!validFutureDate) {
                                if (gem.isDateValid) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    fldtype = 'date'
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }

            }

        },
        validateAllowOnlyFutureDate: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validFutureDate = gem.onlyFutureDateCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validFutureDate) {
                        if (gem.isDateValid) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            fldtype = 'date'
                            gem.errorShow(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            var validFutureDate = gem.onlyFutureDateCheck(fields);
                            if (!validFutureDate) {
                                if (gem.isDateValid) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    fldtype = 'date'
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {

                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },

        validatePastDate: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validPastDate = gem.pastDateCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validPastDate) {
                        if (gem.isDateValid) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            fldtype = 'date'
                            gem.errorShow(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }


                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            var validPastDate = gem.pastDateCheck(fields);
                            if (!validPastDate) {
                                if (gem.isDateValid) {
                                    gem.errorShow(myEvent, fields, fldtype);

                                } else {
                                    fldtype = 'date'
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },
        validateDOB: function (myEvent, fields, fldtype) {
            if (myEvent === 'blur') {
                var validDOB = gem.dobDateCheck(fields);
                if (fields.is(":visible") && fields.val().length > 0) {
                    if (!validDOB) {
                        if (gem.isDateValid) {
                            gem.errorShow(myEvent, fields, fldtype);
                        } else {
                            fldtype = 'date'
                            gem.errorShow(myEvent, fields, fldtype);
                        }
                    } else {
                        gem.removeError(myEvent, fields, fldtype);
                    }

                } else {
                    fields.parent().find('.error_msg').remove();
                    gem.removeError(myEvent, fields, fldtype);
                }

            } else {
                if (fields != '' && fields.length > 0) {
                    $(fields).each(function () {
                        var fields = $(this)
                        if (fields.is(":visible") && fields.val().length > 0) {
                            var validDOB = gem.dobDateCheck(fields);
                            if (!validDOB) {
                                if (gem.isDateValid) {
                                    gem.errorShow(myEvent, fields, fldtype);
                                } else {
                                    fldtype = 'date'
                                    gem.errorShow(myEvent, fields, fldtype);
                                }
                            } else {
                                gem.removeError(myEvent, fields, fldtype);
                            }

                        } else {
                            if ($(fields).hasClass('required') === true) {
                                gem.addError(myEvent, fields, fldtype)
                            }
                            if ($(fields).hasClass('notReq') === true) {
                                gem.removeError(myEvent, fields, fldtype)
                            }
                        }

                    });
                }
            }

        },
        monthValidCheck: function (fields) {
            var dateString = fields.val();
            gem.isMonthValid = true;
            isMonthValid = /^\d{1,2}\/\d{4}$/.test(dateString);
            if (isMonthValid) {
                var parts = dateString.split("/");
                var day = 15;
                var month = parseInt(parts[0], 10);
                var year = parseInt(parts[1], 10);
                if (year < 1000 || year > 3000 || month == 0 || month > 12)
                    gem.isMonthValid = false;
                var monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

                // Adjust for leap years
                if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0))
                    monthLength[1] = 29;
                isMonthValid = isMonthValid && (day > 0 && day <= monthLength[month - 1]);
            }
            return isMonthValid;
        },

        dateValidCheck: function (fields) {
            var dateString = fields.val();
            isDateValid = true;
            isDateValid = /^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateString);
            if (isDateValid) {
                var parts = dateString.split("/");

                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);
                if (year < 1000 || year > 3000 || month == 0 || month > 12)
                    isDateValid = false;

                var monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

                // Adjust for leap years
                if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0))
                    monthLength[1] = 29;
                isDateValid = isDateValid && (day > 0 && day <= monthLength[month - 1]);
            }
            return isDateValid;
        },

        futureDateCheck: function (fields) {
            gem.isDateValid = gem.dateValidCheck(fields)
            var isFutDateValid = false;
            if (gem.isDateValid) {
                var dateString = fields.val();
                var parts = dateString.split("/");
                var date = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);

                var dateFldVal = month + '/' + date + '/' + year;

                var myDate = new Date(dateFldVal);
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var dateCeil = new Date();
                dateCeil.setFullYear(today.getFullYear() + parseInt(gem.settings.minCount));
                if (myDate >= dateCeil && myDate >= today) {
                    isFutDateValid = true;
                }
            }

            return isFutDateValid;
        },
        birthDateMinMaxCheck: function (fields) {
            gem.isDateValid = gem.dateValidCheck(fields)
            var isFutDateRangeValid = false;
            if (gem.isDateValid) {
                var dateString = fields.val();
                var parts = dateString.split("/");
                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);

                day = day + 1;

                var dateFldVal = month + '/' + day + '/' + year;

                var myDate = new Date(dateFldVal);
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var minDate = new Date();
                minDate.setFullYear(today.getFullYear() - parseInt(gem.settings.minCount));
                var maxDate = new Date();
                maxDate.setFullYear(today.getFullYear() - parseInt(gem.settings.maxCount));

                if (myDate <= minDate && myDate > maxDate) {
                    isFutDateRangeValid = true;
                }

            }

            return isFutDateRangeValid;
        },
        cprDateCheck: function (fields) {
            var iscprDateValid = false;
            gem.isDateValid = true;
            var dateString = fields.val();
            dateString = dateString.replace('-', '');
            var parts = dateString.substring(0, 6);
            var day = parseInt(parts.substring(0, 2));
            var month = parseInt(parts.substring(2, 4));
            var yy = parseInt(parts.substring(4, 6));
            var unique = parseInt(dateString.substring(6, dateString.length))

            var century = 18;

            if ((yy >= 58 && yy <= 99) && (unique >= 5000 && unique <= 8999)) {
                century = 18;
            } else if (((yy >= 00 && yy <= 99) && (unique >= 0001 && unique <= 3999)) ||
                ((yy >= 37 && yy <= 99) && ((unique >= 4000 && unique <= 4999) ||
                    (unique >= 9000 && yy <= 9999)))) {
                century = 19;
            } else if (((yy >= 00 && yy <= 57) && (unique >= 5000 && unique <= 8999)) ||
                ((yy >= 00 && yy <= 36) && ((unique >= 4000 && unique <= 4999) ||
                    (unique >= 9000 && yy <= 9999)))) {
                century = 20;
            }

            century = century * 100;
            year = century + yy;

            if (year < 1000 || year > 3000 || month == 0 || month > 12)
                gem.isDateValid = false;

            var monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

            // Adjust for leap years
            if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0))
                monthLength[1] = 29;
            gem.isDateValid = gem.isDateValid && (day > 0 && day <= monthLength[month - 1]);


            if (gem.isDateValid) {



                var dateFldVal1 = month + '/' + day + '/' + year;
                var myDate1 = new Date(dateFldVal1);
                gem.settings.cprValidateMaxDate = myDate1;
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var minDate = new Date();
                minDate.setFullYear(today.getFullYear() - parseInt(gem.settings.minCount));
                var maxDate = new Date();
                maxDate.setFullYear(today.getFullYear() - parseInt(gem.settings.maxCount));

                if (myDate1 <= minDate && myDate1 >= maxDate) {
                    iscprDateValid = true;
                }
            }

            return iscprDateValid;
        },

        futureDateRangeCheck: function (fields) {
            gem.isDateValid = gem.dateValidCheck(fields)
            var isFutDateRangeValid = false;
            if (gem.isDateValid) {
                var dateString = fields.val();
                var parts = dateString.split("/");
                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);

                day = day + 1;

                var dateFldVal = month + '/' + day + '/' + year;

                var myDate = new Date(dateFldVal);
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var dateCeil = new Date();
                dateCeil.setFullYear(today.getFullYear() + parseInt(gem.settings.minCount));
                if (myDate <= dateCeil && myDate >= today) {
                    isFutDateRangeValid = true;
                }
            }

            return isFutDateRangeValid;
        },

        futureDateRangeCPRCheck: function (fields) {
            gem.isDateValid = gem.dateValidCheck(fields)
            gem.cprDateCheck($('input#andelsbolig-cprnum'))
            var cprDateVar = gem.settings.cprValidateMaxDate;
            var isFutDateRangeValid = false;
            if (gem.isDateValid) {
                var dateString = fields.val();
                var parts = dateString.split("/");
                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);

                day = day;

                var dateFldVal2 = month + '/' + day + '/' + year;

                var myDate2 = new Date(dateFldVal2);
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var dateCeil = new Date();
                dateCeil.setFullYear(today.getFullYear() + parseInt(gem.settings.minCount));

                var yearDiff = gem.calcYear(myDate2, cprDateVar)

                if (yearDiff >= parseInt(gem.settings.cprValidMaxLimit)) {
                    isFutDateRangeValid = false;

                } else {
                    if (myDate2 <= dateCeil && myDate2 >= today) {
                        isFutDateRangeValid = true;
                    }
                }


            }

            return isFutDateRangeValid;
        },

        calcYear: function (date1, date2) {

            var years = date1.getFullYear() - date2.getFullYear();
            date2.setFullYear(date2.getFullYear() + years);
            if (date2 > date1) {
                years--;
                date2.setFullYear(date2.getFullYear());
            }
            var days = ((date1.getTime() - date2.getTime()) / (3600 * 24 * 1000));
            years = (days > 0) ? years + 1 : years;
            return years
        },

        isLeapYear: function (year) {
            var d = new Date(year, 1, 28);
            d.setDate(d.getDate() + 1);
            return d.getMonth() == 1;
        },

        pastDateCheck: function (fields) {
            gem.isDateValid = gem.dateValidCheck(fields)
            var isPastDateValid = false;
            if (gem.isDateValid) {
                var dateString = fields.val();
                var parts = dateString.split("/");
                var date = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);

                var dateFldVal = month + '/' + date + '/' + year;

                var myDate = new Date(dateFldVal);
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var dateCeil = new Date();
                dateCeil.setFullYear(today.getFullYear() - parseInt(gem.settings.minCount));
                if (myDate <= dateCeil && myDate <= today) {
                    isPastDateValid = true;
                }
            }

            return isPastDateValid;
        },
        dobDateCheck: function (fields) {
            gem.isDateValid = gem.dateValidCheck(fields)
            var isDOBValid = false;
            if (gem.isDateValid) {
                var dateString = fields.val();
                var parts = dateString.split("/");
                var date = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var year = parseInt(parts[2], 10);

                var dateFldVal = month + '/' + date + '/' + year;

                var myDate = new Date(dateFldVal);
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var dateCeil = new Date();
                dateCeil.setFullYear(today.getFullYear() - 1);
                if (myDate < dateCeil) {
                    isDOBValid = true;
                }
            }

            return isDOBValid;
        },

        validate: function (eventParam, objfld) {

            gem.settings.fieldsAllValid = false;

            // Validation All on submit ***************************************************************************************************
            gem.errorObj = [];
            var classList = $(objfld).find('.default,.responsive-dropdown,.groupCheckbox, .radioCollection,.checkboxCollection');
            $.each(classList, function (index, item) {
                if (!$(item).hasClass('required')) {
                    $(item).addClass('notReq');
                }
            });
            gem.validateRequired(eventParam, objfld);

            if (gem.errorObj.length > 0 || $('#' + gem.settings.formContainerId).find('.input-error:visible').length > 0) {
                gem.settings.fieldsAllValid = true;
                var offSetDiv = $(".input-error").eq(0).closest("div");
                var topPosition = offSetDiv.offset().top;
                $("html, body").animate({
                    scrollTop: topPosition,
                }, 1000);
            }


            // All validation end here******************************************************************************************************

            if (!gem.settings.fieldsAllValid) {
                if (eventParam == 'click') {
                    if (gem.settings.currentStep < gem.settings.stepCount) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    return true
                }
            } else {
                return true;
            }
        },


        errorShow: function (myEvent, fields, fldtype) {
            fields.parent().find('.error_msg').remove();
            fields.addClass('input-error');
            gem.errorObj.push(fields.attr('id'));
            var formErrorLen = fields.parent().find('.form-error').length
            if (formErrorLen < 1) {
                fields.parent().append('<div class="error_msg"><span>&nbsp;</span>' + gem.getErrorMessage(fldtype) + '</div>');
            } else {
                fields.parent().find('.form-error').show();
                fields.addClass('input-error');
            }
        },
        errorGroupShow: function (myEvent, fields, fldtype) {
            fields.find('.error_msg').remove();
            gem.errorObj.push(fields.attr('id'));
            fields.parent().find('input.checkboxCollection ').removeClass('input-error');
            var formErrorLen = fields.parent().find('.form-error').length
            if (formErrorLen < 1) {
                fields.append('<div class="error_msg"><span>&nbsp;</span>' + gem.getErrorMessage(fldtype) + '</div>');
            } else {
                fields.parent().find('.form-error').show();
                fields.addClass('input-error');
            }
        },
        addError: function (myEvent, fields, fldtype) {

            fields.addClass('input-error');
            fields.attr('placeholder', gem.getErrorMessage('placeholderTxt'));
            gem.errorObj.push(fields.attr('id'));
        },
        removeError: function (myEvent, fields, fldtype) {
            fields.parent().find('.form-error').hide()
            fields.parent().find('.error_msg').remove();
            fields.removeAttr('placeholder');
            fields.removeClass('input-error');
        },

        setTo: function (to) {
            $("[id$='fldSendTo']").val(to);
        },

        setFrom: function (from) {
            $("[id$='fldNavnH']").val(from);
        },

        verifyEmail: function (myEvent, fields) {
            var destVal = fields.val();
            var srcEmail = $('.sourceEmail:visible').val();
            var fldtype = 'repeatemail'
            if (destVal != srcEmail) {
                gem.errorShow(myEvent, fields, fldtype);
            } else {
                gem.removeError(myEvent, fields, fldtype);
            }
        },

        setSubject: function (subj) {
            var oldSubj = subj;
            var newSubj = '';
            if (oldSubj != '' || oldSubj != 'undefined') {
                var lanCode = gem.getLanguageCode(gem.settings.lanCode);
                switch (lanCode) {
                    case 'SE':
                        newSubj = gem.getCustomSubject(lanCode);
                        break;
                    case 'DK':
                        newSubj = gem.getCustomSubject(lanCode);
                        break;
                    case 'NO':
                        newSubj = gem.getCustomSubject(lanCode);
                        break;
                    case 'FI':
                        newSubj = gem.getCustomSubject(lanCode);
                        break;
                    case 'UK':
                        newSubj = gem.getCustomSubject(lanCode);
                        break;
                    default:
                        newSubj = gem.getCustomSubject(lanCode);
                        break;

                }
                $("[id$='fldSubjH']").val(newSubj);
            } else {
                $("[id$='fldSubjH']").val(oldSubj);

            }
        },
        getCustomSubject: function (lanCode) {
            var subjStr = $('#__formSubj').val()
            var subjTitle = $('#__title').val()
            var postfixVal = $('#__postFixSubj').val()
            if (subjTitle == 'Yes') {
                pageTitle = document.title + ', ';
            } else {
                pageTitle = '';
            }

            if (postfixVal == '' || postfixVal == undefined) {
                postfixStr = '';
            } else {
                postfixStr = $('#__postFixSubj').val();
            }

            newSubj = subjStr + pageTitle

            var subj1Val = $('#' + gem.settings.formContainerId).find('.subj1').val()
            var subj2Val = $('#' + gem.settings.formContainerId).find('.subj2').val();
            var subj3Val = $('#' + gem.settings.formContainerId).find('.subj3').val();
            var dropSubjVal = $('#' + gem.settings.formContainerId).find('.dropSubj:visible').attr('data-selected-value');
            var radioSubjVal = $('#' + gem.settings.formContainerId + ' .radioSubj').find('input[type="radio"]:checked').val();

            subj1Val = (subj1Val == undefined || subj1Val == '') ? '' : (subj1Val != '') ? subj1Val + gem.settings.tablevalueDelim : subj1Val;
            subj2Val = (subj2Val == undefined || subj2Val == '') ? '' : (subj2Val != '') ? subj2Val + gem.settings.tablevalueDelim : subj2Val;
            subj3Val = (subj3Val == undefined || subj3Val == '') ? '' : (subj3Val != '') ? subj3Val + gem.settings.tablevalueDelim : subj3Val;
            dropSubjVal = (dropSubjVal == undefined || dropSubjVal == '') ? '' : (dropSubjVal != '') ? dropSubjVal + gem.settings.tablevalueDelim : dropSubjVal;
            radioSubjVal = (radioSubjVal == undefined || radioSubjVal == '') ? '' : (radioSubjVal != '') ? radioSubjVal + gem.settings.tablevalueDelim : radioSubjVal;

            if ($('#__formSubj').hasClass('__custSubj')) {
                newSubj = window.customSubj();
                return newSubj;
            } else {
                newSubj += subj1Val + subj2Val + subj3Val + dropSubjVal + radioSubjVal + '###';
                newSubj = (newSubj.indexOf(', ###')) != -1 ? newSubj.replace(', ###', '') : newSubj.replace('###', '');
                return newSubj + postfixStr;
            }
        },
        timestampFields: function () {
            var tidChars = "bcdfghjkmnpqrstvxz";
            var tidStringLength = 3;
            var transID1 = '';
            var transID2, tidTransID;
            var tidNum = 0;
            var i = 0;
            if ($("[id$='fldTimestampH']").val() === '') {
                for (i = 0; i < tidStringLength; i++) {
                    tidNum = Math.floor(Math.random() * tidChars.length);
                    transID1 += tidChars.substring(tidNum, tidNum + 1);
                }
                transID2 = new Date().getTime();
                tidTransID = transID1 + transID2;
                $("[id$='fldTimestampH']").val(tidTransID);
            }
        },

        escapeHTML: function (string) {
            var entityMap = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': '&quot;',
                "'": '&#39;',
                "/": '&#x2F;'
            };
            return String(string).replace(/[&<>"'\/]/g, function (s) {
                return entityMap[s];
            });
        },

        getFieldIdList: function (fldListObj) {
            var fldIdList = [];
            var fld;
            for (var i = 1; i < fldListObj.length; i++) {
                if (fldListObj[i] != undefined && $(fldListObj[i]).parent().parent().is(':visible') === true) {
                    fld = fldListObj[i];
                    var fldId = (fld.id == '' || fld.id == undefined) ? fld.name : fld.id;
                    fldIdList.push(fldId);
                }
            }

            return fldIdList;

        },
		
		getFieldIdListForBPM: function (fldListObj) {
		  var fldIdList = [];
		  var fld;
		  for (var i = 0; i < fldListObj.length; i++) {
			if (
			  fldListObj[i] != undefined 
			) {
			  fld = fldListObj[i];
			  var fldId = fld.id == "" || fld.id == undefined ? fld.name : fld.id;
			  fldIdList.push(fldId);
			}
		  }

		  return fldIdList;
		},

        getFieldLabel: function (fldListObj) {
            var fldLabelList = [];
            var fldLabel;
            for (var i = 1; i < fldListObj.length; i++) {
                if (fldListObj[i] != undefined && $(fldListObj[i]).parent().parent().is(':visible') === true) {
                    fld = fldListObj[i];
                    if ($(fld).attr('data-cblabel') != undefined) {
                        fldLabel = $(fld).attr('data-cblabel');
                    } else {
                        fldLabel = gem.findLabel(fld);
                    }
                    fldLabelList.push(fldLabel);
                }
            }
            return fldLabelList;
        },

        findLabel: function (fld) {
            var labelTxt = '';
            var sibling;
            var siblings = fld.parentNode.childNodes;
            for (var i = 0; i < siblings.length; i++) {
                sibling = siblings[i];
                if (sibling.nodeType == 1) {
                    tagname = sibling.tagName.toUpperCase();
                    if (tagname == 'LABEL' || tagname == 'LEGEND') {
                        labelTxt = $(sibling).text();
                        labelTxt = labelTxt.replace(/\*/gm, "");
                        break;
                    }
                }
            }
            return labelTxt;
        },

        getFieldValue: function (id) {

            var fldObj = $('#' + id);
            var val = '';
            if (fldObj.hasClass('radioCollection')) {
                var selected = fldObj;
                //if (selected.length > 0) {
                val = $.trim(selected.val());
                //}
            } else if (fldObj.hasClass('checkboxCollection')) {
                var selected = fldObj;
                var valList = [];
                $.each(selected, function () {
                    valList.push($.trim($(this).val()));
                });
                val = valList.join(gem.settings.multivalueDelim);
            } else if (fldObj.hasClass('responsive-dropdown')) {
                var selectedVal = fldObj.attr('data-selected-value');
                val = $.trim(selectedVal);
            } else {
                val = $.trim(fldObj.val());

            }
            return val;
        },

        preText: function () {
            return '';
        },
        postDate: function () {
            var today = new Date();

            function z(t) {
                var p = t < 10 ? '0' : '';
                return p + t;
            }
            var postDate = z(today.getDate()) + '-' + z(today.getMonth() + 1) + '-' + z(today.getFullYear());
            return postDate;
        },
        postText: function () {
            var postTxt = "Timestamp (Danish Time): ";
            var now = new Date().toLocaleString("da-DK", {
                timeZone: "Europe/Copenhagen",
            });
            postTxt += now;
            return postTxt;
        },

        fetchFields: function (element) {
            //var formcontainer = document.getElementById(gem.settings.formContainerId);
            gem.sortDataFields(element);
            var curFields = gem.getFieldIdList(gem.settings.fields);
            var txt = '';
            var i = 0;
            var fldLabel = '';
            //txt += gem.preText();
            var j = gem.settings.currentStep;
            gem.settings.stepResults[j - 1] = '';
            for (i = 0; i < curFields.length; i++) {
                fldLabel = gem.getFieldLabel(gem.settings.fields);
                //gem.settings.resultTxt += fldLabel[i] + gem.settings.fieldValPairDelim + gem.getFieldValue(curFields[i]) + '!#';
                gem.settings.stepResults[j - 1] += fldLabel[i] + gem.settings.fieldValPairDelim + gem.getFieldValue(curFields[i]) + '!#';

            }

        },
        dotNumberFormat: function (num) {
            var num = num.toString().replace('.', ',');
            return num.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1.") + ' kr'
        },
        getFieldValueFromFldText: function (id) {
            //used if you need to get some values for showing the receipt.
            var txt = $("[id$='fldText']").val();
            if (txt == '') { //if there is no text, no need to continue
                return;
            }
            var fldLabel = gem.getFieldLabel(id);
            var list = txt.split('!#'); //put all lines of the _fldText field into an array
            var fldDelim = gem.settings.fieldValPairDelim;
            var fldLine;
            var i = 0;
            for (i = 0; i < list.length; i++) { //run through every line
                if (list[i].indexOf(fldDelim) > -1) { //this is a line with a field
                    fldLine = list[i].split(fldDelim); //split that linie into label and value
                    if (fldLine[0] == fldLabel) {
                        return fldLine[1];
                    }
                }
            }
        },

        textareaValuePass: function () {
            var txtArea = $('#' + gem.settings.formContainerId + ' .textComment').attr('id');
            var txtAreaVal = $('#' + txtArea).val();
            $('#' + txtArea + '-hidden').val(txtAreaVal);
        },

        uSubmitForm: function (currElement, status) {
            gem.fetchFields(currElement);
            gem.textareaValuePass();
            var topic = gem.settings.defaultSubject;
            if (topic != '') {
                gem.setSubject(topic);
            }
            var fromTxt = 'R3732WAS';
            var from = encodeURI(fromTxt);
            gem.setFrom(from);
            if (status == true) {
                gem.navigateTo(gem.settings.currentStep, gem.settings.currentStep + 1)
            }
            return true;
        },

        nSubmitForm: function () {
            var formcontainer = document.getElementById(gem.settings.formContainerId);
            gem.sortDataFields(formcontainer);
            var curFields = gem.getFieldIdList(gem.settings.fields);
            initFrm();
            $.DBGsendFormCBfr({
                formContainerId: formcontainer,
                setFormCharset: 'iso-8859-1',
                setMail: 'MANJM',
                setDestDB: 'Contacts\\DBContacts.nsf',
                setMsgTxtBefLink: 'Click the below button to see the data:',
                setMsgTxtAfterLink: '',
                setCategory: 'Danske Bank\\Address\\Test\\Egain',
                setSubject: 'Contact Us',
                generateCBfields: true,
                fieldIdList: curFields,
                testmode: false
            });
            return true;
        },

        summaryPage: function () {
            var tbody = '';
            gem.settings.resultTxt = '';
            gem.settings.finalResult = '';
            for (var k = 0; k < gem.settings.stepResults.length; k++) {
                gem.settings.resultTxt += gem.settings.stepResults[k]
            }
            gem.settings.finalResult = gem.settings.resultTxt;
            var mainStr = gem.settings.finalResult;
            var splitStr = mainStr.split('!#');
            var splitStrLen = splitStr.length;
            for (var i = 0; i < splitStrLen - 1; i++) {
                var finalSplit = splitStr[i].split(':')
                var summLabel = finalSplit[0].trim();
                var summVal = (finalSplit[1] != 'undefined' || finalSplit[1] != '') ? finalSplit[1].trim() : finalSplit[1]
                tbody += "<tr> <td class='sLabel  text-left'>" + summLabel + " </td> \
							<td class='sValue text-right'>" + summVal + "</td> \</tr>";

            }
            $('#tableBody').html(tbody);
        },

        allReplace: function (txt, obj) {
            var retStr = txt;
            for (var x in obj) {
                retStr = retStr.replace(new RegExp(x, 'g'), obj[x]);
            }
            return retStr;
        },

        checkSubmit: function () {
			if ($("[id$='fldSendBPM']").val() === "Y") {
                gem.fetchBPMFields();
			} 
            $("[id$='fldText']").val(gem.settings.finalResult);
            var topic = $("[id$='fldSubjH']").val();
            var from = $("[id$='fldNavnH']").val();
            from = (from.length > 30) ? from.substring(0, 30) : from;
            var txt = $("[id$='fldText']").val();
            txt = gem.allReplace(txt, {
                '…': '',
                'Select': '',
                'Delete': '',
                'truncate': ''
            });
			var bpmText =
                $("[id$='fldBPMString']").val() === undefined ?
                "" :
                $("[id$='fldBPMString']").val();
            $("[id$='fldLang']").val('da');
			var bpmText = bpmText.replace("#salAmount: !", "");//Remove SalAmount if its empty
            gem.generalUploadSendParam(from, topic, txt, bpmText);
            if (typeof DB.track === 'function') {
                DB.track(' - kvittering');
            }
            //gem.showReceipt();
            return true;

        },

        showAddressError: function () {
            alert('Error: Form recipient not valid.');
        },


        showSuccessReceipt: function () {
            if ($('#techError').is(":visible")) {
                $('#techError').remove();
            }
            if (typeof DB.track === 'function') {
                DB.track(' - kvittering');
            }
            $("#" + gem.settings.formContainerId + "-receipt").foundation("open");
            $("#" + gem.settings.formContainerId + "-receipt").on("click", function () {
                var isAsheValid = $("#__asheLogin").val();
                if (isAsheValid !== undefined) {
                    gem.clearSession();
                } else {
                    if ($(this).attr('data-redirect') === undefined) {
                        document.location.reload();
                    } else {
                        var redirectTo = $(this).attr('data-redirect');
                        document.location.href = redirectTo;
                    }
                }
            });

            if (navigator.userAgent.indexOf('Firefox') == -1) {
                $("#" + gem.settings.formContainerId + "-receipt a[target='_blank']").on('click', function (e) {
                    var redirectURL = $(this).attr('href');
                    e.preventDefault();
                    if (redirectURL != '#' && redirectURL != "") {
                        window.open(redirectURL, '_blank');
                    }
                });
            }

        },

        showErrorReceipt: function (fldtype, fields) {
            if ($('#techError').is(":visible")) {
                $('#techError').remove();
            }
            var techErrorItem = document.createElement("DIV");
            techErrorItem.setAttribute("id", "techError");
            techErrorItem.setAttribute("class", "error_msg");
            if (fldtype === 'attachFileType') {
                var errorMessages = gem.getErrorMessage('notSupportFileType');
                var textnode = document.createTextNode(errorMessages);
                techErrorItem.appendChild(textnode);
                var label = $("label[for='" + fields.attr('id') + "']");
                $(techErrorItem).insertAfter(label);
            } else {
                var fields = 'sendbutton';
                var errorMessages = gem.getErrorMessage('technicalError');
                var textnode = document.createTextNode(errorMessages);
                techErrorItem.appendChild(textnode);
                var list = document.getElementById(fields);
                list.parentNode.insertBefore(techErrorItem, list);
            }

            $('html,body').animate({
                scrollTop: $('#techError').offset().top
            }, 'slow');
        },
        fileSizeNotOk: function (file) {
            if (file.length < 1 || file.length > 0 && file[0].files[0].size > 5242880) {
                var fileResult = file.get(0).files;
                for (var x = 0; x < fileResult.length; x++) {
                    var fle = fileResult[x];
                    var errorText = $("#fileSizeErrorMessage").html();
                    $(".filename")
                        .append("<tr class='file-up error'><td><div class='input-setm error'><label>" +
                            fle.name +
                            "</label><span class='form-error is-visible'>" +
                            errorText +
                            "</span></td><td><a class='slet' data-file='-1'></a></td></tr>");
                }


                return true;
            }
            return false;
        },
        disableOrEnableFileInput: function () {
            if ($("#general-upload-files tr.file-up").length >= 10) {
                $('#document-file-label').hide();
                $('#document-file-label-disabled').show();
            } else {
                $('#document-file-label').show();
                $('#document-file-label-disabled').hide();
            }
        },
        setTimestampField: function () {
            var tidChars = "bcdfghjkmnpqrstvxz";
            var tidStringLength = 4;
            var transId1 = '';
            var transId2, tidTransId;
            var tidNum = 0;
            var i = 0;
            if ($("[id$='fldTimestampH']").val() === '') {
                for (i = 0; i < tidStringLength; i++) {
                    tidNum = Math.floor(Math.random() * tidChars.length);
                    transId1 += tidChars.substring(tidNum, tidNum + 1);
                }
                transId2 = new Date().getTime();
                tidTransId = transId1 + transId2;
                $("input[id$='fldTimestampH']").val(tidTransId);
            }
        },
        generalUploadSendSuccess: function () {
            $("#gu-input").fadeOut(700, function () {
                $(this).hide();
            });
            $("#gu-receipt").show();
        },
        checkFileInputWithInsert: function () {
            if ($("#question-container-4 input[type=file]").length >= 10) {
                $('#document-file-label')
                    .prop("disabled", "disabled")
                    .addClass("disabled")
                    .on('click',
                        function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        });
            } else {
                if ($("#question-container-4 input[type=file]:last").get(0).files.length > 0) {
                    var rand = new Date().getTime();
                    $('<input />')
                        .prop("type", "file")
                        .prop("id", "DocumentFile" + rand)
                        .insertBefore($("#question-container-4 input[type=file]:first"));

                    $('#document-file-label')
                        .prop("for", "DocumentFile" + rand)
                        .removeAttr("disabled")
                        .removeClass("disabled")
                        .off("click");
                }
            }
        },

        generalUploadAttach: function (file) {
            if (gem.fileSizeNotOk(file)) {
                DB.trackFormSubmit("File Size Exceeds the Limit");
                return false;
            }

            $("tr.error").remove();
            $("#gu-alert-wrapper").hide();
            $("#general-upload-files").trigger('SHOW_SPINNER');
            var topic = gem.settings.defaultSubject;
            if (topic != '') {
                gem.setSubject(topic);
            }
            var formData = new FormData($("#generalUploadForm")[0]);
            $.ajax({
                type: "POST",
                url: "/web/generalupload/attach/",
                data: formData,
                dataType: "json",
                cache: false,
                async: true,
                contentType: false,
                processData: false,
                success: function (result) {
                    if (result.ErrorId === "0" || result.ErrorId === "4") {
                        $("#general-upload-files").trigger('HIDE_SPINNER');
                        var fileIdFromUpload = result.FileId;
                        var attachId = result.AttachId;
                        var uploadClass = " good";
                        var deleteLabel = $("#deleteFileLinkText").text();
                        var errorSpan = "";
                        if (result.ErrorId === "4") {
                            uploadClass = " error";
                            deleteLabel = "";
                            errorSpan = "<span class='form-error is-visible'>" + $("#fileSizeErrorMessage").text() + "</span>";
                        }
                        var fileResult = file.get(0).files;
                        for (var x = 0; x < fileResult.length; x++) {
                            var fle = fileResult[x];
                            $(".filename")
                                .append("<tr class='file-up" +
                                    uploadClass +
                                    "'><td><div class='input-setm" +
                                    uploadClass +
                                    "'><label>" +
                                    fle.name +
                                    "</label>" +
                                    errorSpan +
                                    "</td><td><a class='slet' data-file='" +
                                    fileIdFromUpload +
                                    "'>" +
                                    deleteLabel +
                                    "</a></td></tr>");
                        }

                        gem.disableOrEnableFileInput();

                        $(".filename .slet")
                            .off('click')
                            .on('click',
                                function (e) {
                                    e.preventDefault();
                                    e.stopPropagation();
                                    gem.generalUploadRemove($(this));
                                });
                        file.val("");
                        if (attachId !== "" && attachId != null) {
                            $("#AttachId").val(attachId);
                        }
                    } else {
                        $("#general-upload-files").trigger('HIDE_SPINNER');
                        DB.trackFormSubmit(result);
                        gem.showErrorReceipt();
                    }
                },
                error: function (response) {
                    $("#general-upload-files").trigger('HIDE_SPINNER');
                    DB.trackFormSubmit(response);
                    gem.showErrorReceipt();
                }
            });
            return false;
        },
        generalUploadRemove: function (link) {
            $("gu-alert-wrapper").hide();
            $("#general-upload-files").trigger('HIDE_SPINNER');
            $("input[id$='fldFileId']").val(link.data("file"));
            var formData = new Object();
            formData.FldNavnH = $("#fldNavnH").val();
            formData.FldSubjH = $("#fldSubjH").val();
            formData.FldTimestampH = $("#fldTimestampH").val();
            formData.FldText = $("#fldText").val();
            formData.FileId = $("#fldFileId").val();
            formData.FldSendTo = $("#FldSendTo").val();
            formData.DSId = $("#fldDSId").val();
            formData.DocumentFile0 = $("#gu-document-file").get(0).files;
            formData.Language = $("#fldLang").val();
            formData.AttachId = $("#AttachId").val();
            $.ajax({
                type: "POST",
                url: "/web/generalupload/remove/",
                data: JSON.stringify(formData),
                dataType: "json",
                cache: false,
                async: true,
                contentType: "application/json; charset=utf-8",
                processData: false,
                success: function (result) {
                    $("#gu-alert-wrapper").hide();
                    $("#general-upload-files").trigger('HIDE_SPINNER');
                    if (result.ErrorId === "0") {
                        link.closest('.file-up').remove();
                        var uploadFileId = link.data('file');
                        $('#' + uploadFileId).remove();
                        gem.disableOrEnableFileInput();
                    } else {
                        $("#general-upload-files").trigger("HIDE_SPINNER");
                        DB.trackFormSubmit(result);
                        gem.showErrorReceipt();
                    }
                },
                error: function (response) {
                    $("#general-upload-files").trigger("HIDE_SPINNER");
                    DB.trackFormSubmit(response);
                    gem.showErrorReceipt();
                }
            });
        },
        generatePreText: function (preText) {
            return preText + "!#!#";
        },
        getlineforEmailString: function (label, value) {
            return label + ": " + value + "!#";
        },
        generalUploadSendParam: function (from, subject, text, bpmText) {
            $("input[id$='fldNavnH']").val(from);
            $("input[id$='fldSubjH']").val(subject);
            $("input[id$='fldText']").val(text);
			var formattedBPMText = gem.formatBPMString(bpmText);
			$("input[id$='fldBPMString']").val(formattedBPMText);
            gem.generalUploadSend();
        },
        //override this and get your magic done, if you need an action before send call.
        beforeGeneralUploadSend: function () {},
        generalUploadSend: function () {
            $("gu-alert-wrapper").hide();
            $("#general-upload-files").trigger('SHOW_SPINNER');
            gem.beforeGeneralUploadSend();
            gem.setTimestampField();
            var formData = new Object();
            formData.FldNavnH = $("#fldNavnH").val();
            formData.FldSubjH = $("#fldSubjH").val();
            formData.FldTimestampH = $("#fldTimestampH").val();
            formData.FldText = $("#fldText").val();
            formData.FileId = $("#fldFileId").val();
            formData.FldSendTo = $("#FldSendTo").val();
            formData.DSId = $("#fldDSId").val();
            formData.DocumentFile0 = $("#gu-document-file").get(0).files;
            formData.Language = $("#fldLang").val();
            formData.AttachId = $("#AttachId").val();
			formData.FldSendBpm = $("#fldSendBPM").val();
			formData.FldBpmString = $("#fldBPMString").val();
            $.ajax({
                type: "POST",
                url: "/web/generalupload/send/", //window.location.pathname,
                data: JSON.stringify(formData),
                dataType: "json",
                cache: false,
                async: true,
                contentType: "application/json; charset=utf-8",
                processData: false,
                success: function (result) {
                    $("#general-upload-files").trigger('HIDE_SPINNER');
                    if (result.ErrorId === "0") {
                        gem.showSuccessReceipt();
                        DB.trackFormSubmit();
                    } else {
                        gem.showErrorReceipt();
                        DB.trackFormSubmit(result.ErrorId);
                    }
                },
                error: function (response) {
                    $("#general-upload-files").trigger('HIDE_SPINNER');
                    DB.trackFormSubmit(response);
                    gem.showErrorReceipt();

                }
            })
        },
		
		//Sorting BPM Fields starts
		sortBPMDataFields: function (formcontainer) {
            var fld;
            var count = 0;
            var radioName = []
            gem.settings.bpmFields = [];
            var dataFlds = $(
                "input.additionalFields, input.default,input.checkboxCollection,input.radioCollection,.responsive-dropdown,textarea,input.drpdwn-hidden",
                formcontainer
            );

            for (var i = 0; i < dataFlds.length; i++) {
                fld = dataFlds[i];
                if ($(fld).attr("data-bpm-label") != undefined) {
                    for (var j = count; j < dataFlds.length; j++) {
                        if (gem.settings.bpmFields[j] == undefined) {
                            if (fld.type === "radio") {
                                if ($(fld).is(':checked')) {
                                    gem.settings.bpmFields[j] = fld;
                                    break;
                                } else {
                                    nameTest = fld.name;
                                    radioName.push(nameTest);
                                    if (!$("input[name = " + nameTest + "]").is(':checked')) {
                                        var counts = {};
                                        radioName.forEach(function (x) {
                                            counts[x] = (counts[x] || 0) + 1;
                                        });
                                        if (counts[nameTest] < 2) {
                                            gem.settings.bpmFields[j] = fld;
                                        }
                                    }
                                    break;
                                }
                            } else {
                                gem.settings.bpmFields[j] = fld;
                                break;
                            }
                        }
                    }
                    count = j;
                }
            }
        },
		
		//Sorting BPM Fields ends
		
		getBPMFieldLabel: function (fldListObj, labelAttr) {
            var fldLabelList = [];
            var fldLabel;
            for (var i = 0; i < fldListObj.length; i++) {
                if (
                    fldListObj[i] != undefined) {
                    fld = fldListObj[i];
                    if ($(fld).attr(labelAttr) != undefined) {
                        fldLabel = $(fld).attr(labelAttr);
                    } else {
                        fldLabel = gem.findLabel(fld);
                    }
                    fldLabelList[i] = fldLabel;
                }
            }
            return fldLabelList;
        },
		
		getBPMFieldValue: function (id) {
            var fldObj = $("#" + id);
            var val = "";
            if (fldObj.hasClass("radioCollection")) {
                var selected = fldObj;
                if (fldObj.is(":checked")) {
                    if (fldObj.attr("data-radio-val") === "Y") {
                        val = "Yes";
                    } else if (fldObj.attr("data-radio-val") === "N"){
                        val = "No";
                    }
					else{
						val = fldObj.attr("value");
					}
                } else {
                    val = "";
                }
            } else if (fldObj.hasClass("checkboxCollection")) {
                var selected = fldObj;
                var valList = [];
                $.each(selected, function () {
                    if (fldObj.is(":checked")) {
                        valList.push(true);
                    } else {
                        valList.push(false);
                    }
                });
                val = valList.join(gem.settings.multivalueDelim);
            } else if (fldObj.hasClass("responsive-dropdown")) {
                var selectedVal = fldObj.attr("data-selected-value");
                val = $.trim(selectedVal);
            } else {
                val = $.trim(fldObj.val());
            }
            return val;
        },
		fetchBPMFields: function () {
            var formcontainer = document.getElementById(gem.settings.formContainerId);
            gem.sortBPMDataFields(formcontainer);
            var curBPMFields = gem.getFieldIdListForBPM(gem.settings.bpmFields);
            var labelAttr = "data-bpm-label";
            
            var i = 0;
            var fldLabel = "";
			var bpmText = "";
			var fldVal = "";
            //bpmText += gem.preText();
			//Load Application value as First Param
			
            for (i = 0; i < curBPMFields.length; i++) {
                fldLabel = gem.getBPMFieldLabel(gem.settings.bpmFields, labelAttr);
				fldVal = gem.getBPMFieldValue(curBPMFields[i]); 
				fldVal = fldVal.replace(/["']/g, "'"); 
                bpmText +=
                    fldLabel[i] +
                    gem.settings.fieldValPairDelim +
                    fldVal +
                    "!#";
            }
            $("[id$='fldBPMString']").val(bpmText);
        },
		
		getBPMID: function () {
            // Will be added to subject, see setSubject function. Modify to suit specs.
            var cvr = $("#advisor-pantnr").val();
            var stamp = $("[id$='fldTimestampH']").val();
            var bpmid = "CVR:(" + cvr + ") ID:(" + stamp + ")";
            return bpmid;
        },
    }

    $(document).ready(function () {
        gem.init();

    });


})(jQuery);