//Next Gen Forms Validations - Egain API || Developed by Manjukumar.K 

var NG = {};
'use strict';

NG.start = function (form) {
    NG.forms.addEventListener(window, "load", form.init);
};

NG["forms"] = {
    // main form container 
    formContainerId: document.getElementsByClassName('ngcontactform')[0],
    formStep: document.getElementById('__formType'),
    formSendType: document.getElementById('__submitAPI'),
    formName: document.getElementsByName('__webFormName')[0].value,
    //global settings can be added here
    global: {
        pageTitle: document.title,
        pageUrl: document.location.origin + document.location.pathname,
        lanCode: document.getElementsByName('__lanCode')[0].value,
        dsid: document.getElementsByName('__dsID')[0].value,
        redirectURL: document.getElementsByName('__redirectUrl')[0].value,
        language: 'da',
        market: 'DK',
        version: '1.0',
        serverStatus: false,
        domain: window.location.origin,
        getSupportFiles: [{
            type: 'postalcode',
            path: '/-/media/files/forms/commonjs/ngforms/post_number.json'
        },
        {
            type: 'errormessage',
            path: '/-/media/files/forms/commonjs/ngforms/error_message.json'
        },
        {
            type: 'countries',
            path: '/-/media/files/forms/commonjs/ngforms/countries.json'
        },
        {
            type: 'classes',
            path: '/-/media/files/forms/commonjs/ngforms/classes.json'
        },
        {
            type: 'maxlength',
            path: '/-/media/files/forms/commonjs/ngforms/egain-fields.json'
        }
        ]
    },
    //default settings can be added here
    default: {
        settings: {
            sendTo: "MANJM",
            autoReply: false,
            defaultFrom: "R3732WAS",
            defaultSubject: "NextGen Forms",
            submitButton: 'test',
            customSubject: "NextGen Custom Subject",
            fieldValPairDelim: ":#!",
            semiDelim: "; ",
            commaDelim: ", ",
            trackInit: false
        },
        asheSettings: {
            signatureID: "",
            signatureUrl: ""
        },
        params: [],
        patterns: {
            alpha: /^[a-zA-Z'\u0080-\u00FF\u0100-\u017F\u0180-\u024F -.]+$/,
            alpha_numeric: /^[a-zA-Z0-9'\u0080-\u00FF\u0100-\u017F\u0180-\u024F -.]+$/,
            allow_symbols: /^(?:[a-zA-Z0-9£€ÀÈÌÒÙàèìòùÁÉÍÓÚÝáéíóúýÂÊÎÔÛâêîôûÃÑÕãñõÄËÏÖÜäëïöüÿ¡¿çÇßØøÅåÆæÞþÐð@!#_\$\^%&*()+= \-\[\]\\\';,.\/\{\}\|\":\?\n]*)?$/,
            number: /^[-+]?[0-9]\d*$/,
            // amex, visa, diners
            card: /^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\d{3})\d{11})$/,
            cvv: /^([0-9]){3,4}$/,
            email: /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
            url: /(https?|ftp|file|ssh):\/\/(((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-zA-Z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-zA-Z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-zA-Z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-zA-Z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-zA-Z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-zA-Z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?/,
            domain: /^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}$/,
            datetime: /([0-2][0-9]{3})\-([0-1][0-9])\-([0-3][0-9])T([0-5][0-9])\:([0-5][0-9])\:([0-5][0-9])(Z|([\-\+]([0-1][0-9])\:00))/,
            // YYYY-MM-DD
            date: /(?:19|20)[0-9]{2}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-9])|(?:(?!02)(?:0[1-9]|1[0-2])-(?:30))|(?:(?:0[13578]|1[02])-31))/,
            // HH:MM:SS
            time: /(0[0-9]|1[0-9]|2[0-3])(:[0-5][0-9]){2}/,
            dateISO: /\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}/,
            // MM/DD/YYYY
            month_day_year: /(0[1-9]|1[012])[- \/.](0[1-9]|[12][0-9]|3[01])[- \/.](19|20)\d\d/,
            carRegNumber: /^[a-zA-Z0-9 ]{1,7}$/,
            aftaleNumber: /^[7-8]{1}[0-9]{7}$/,
            //Amount 1000.25 or 10,000.25
            price: /^[0-9,\.]+$/,
            countryPhoneNum: /^[+]?[0-9]{0,5}[ ]?[0-9]{8,10}$/,
            cpr: /^[0-9]{9,11}$/,
            ssn: /^(\d{10}|\d{12})$/,
            ssnFI: /^([0-9]{2})([0-9]{2})([0-9]{2})([-+A])([0-9]{3})([0-9A-Y])$/,
            personNumber: /^([0-9]{11})$/,
            cvr: /^\d{8,9}$/
        },
        validClass: "valid",
        inValidClass: "invalid",
        errorText: '',
        getLanguagecode: function () {
            var self = NG.forms;
            var lanCode = self.global.lanCode;
            var langMarket = lanCode.split('-');
            self.global.language = langMarket[0];
            self.global.market = langMarket[1];
            return langMarket;
        }
    },
    outputText: '',
    fields: [],
    finalFieldSet: [],
    hiddenFields: [],
    isValid: true,
    errors: [],
    JSONCount: 0,
    formElements: [],
    elementsArePrepared: false,
    validateHandler: {
        validStatus: function (fields, evtType) {
            var self = NG.forms;
            for (var i = 0; i < fields.length; i++) {
                self.validateHandler.validates(fields[i], evtType);
            }

            var errorLen = self.errors.length;
            if (errorLen === 0) {
                self.isValid = true;
            } else {
                self.isValid = false;
            }
        },
        validates: function (field, event) {
            var self = NG.forms;
            var required = field.getAttribute('required');
            if (required !== null && field.value === "") {
                var hidden = self.isHidden(field);
                if (!hidden) {
                    arr = self.errors.filter(item => item !== field.id)
                    self.errors = arr;
                    if (event !== 'blur') {
                        self.errorHandler.showError(field);
                    } else {
                        self.errorHandler.hideError(field);
                    }
                    return false;
                }
            }
            else {
                if (field.value === "") {
                    self.errorHandler.hideError(field);
                    return false;
                }else{
                    if (event !== 'blur' && event !== 'change' && self.hasClass(field, 'input-error')) {
                        self.errorHandler.showError(field);
                        return false;
                    }
                }
            }

            var classAttr = field.className;
            var theClasses = self.findClass(classAttr, 'verifyList');
            theClasses = theClasses ? theClasses : field.type;
            switch (theClasses) {
                case 'email':
                    var regEx = self.default.patterns.email;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'number':
                    var regEx = self.default.patterns.number;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'alpha':
                    var regEx = self.default.patterns.alpha;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'alpha-numeric':
                    var regEx = self.default.patterns.alpha_numeric;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'radio':
                    self.validateHandler.radioValidation(field);
                    break;
                case 'checkbox':
                    self.validateHandler.checkboxValidation(field);
                    break;
                case 'select':
                    self.validateHandler.dropdownValidation(field);
                    break;
                case 'allow-symbols':
                    var regEx = self.default.patterns.allow_symbols;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'cpr':
                    self.validateHandler.cprValidation(field);
                    break;
                case 'ssn':
                    self.validateHandler.ssnValidation(field);
                    break;
                case 'ssnFI':
                    self.validateHandler.ssnFIValidation(field);
                    break;
                case 'personno':
                    self.validateHandler.personNumberValidation(field);
                    break;
                case 'cvr':
                    var regEx = self.default.patterns.cvr;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'aftaleNumber':
                    var regEx = self.default.patterns.aftaleNumber;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
                case 'carRegNumber':
                    var regEx = self.default.patterns.carRegNumber;
                    self.validateHandler.commonValidation(field, regEx);
                    break;
            }
        },
        commonValidation: function (field, pattern) {
            var self = NG.forms;
            var fldVal = field.value;
            var hidden = self.isHidden(field);
            if (!hidden) {
                if (!pattern.test(fldVal)) {
                    //todo max length attribute level & egain level
                    self.errorHandler.showError(field);
                } else {
                    self.errorHandler.hideError(field);
                }
            }
        },

        radioValidation: function (field) {
            var self = NG.forms;
            var hidden = self.isHidden(field);
            var required = field.getAttribute('required');
            var count = 0;
            if (!hidden) {
                if (required !== null) {
                    var rates = document.getElementsByName(field.name);
                    for (var i = 0; i < rates.length; i++) {
                        for (var j = i; j < rates.length; j++) {
                           rates[j].classList.remove('input-error');
                        }
                        if (rates[i].checked) {
                            count = count + 1;
                        } else {
                            count = count;
                        }
                    }
                    if (count) {
                        self.errorHandler.hideError(field);
                    } else {
                        self.errorHandler.showError(field);
                    }
                } else {
                    self.errorHandler.hideError(field);
                }
            }
        },

        checkboxValidation: function (field) {
            var self = NG.forms;
            var groupType = self.checkboxType(field);
            var hidden = self.isHidden(field);
            var required = field.getAttribute('required');
            if (!hidden) {
                if (required !== null) {
                    if (groupType) {
                        var className = 'groupCheckbox';
                        var status = self.validateHandler.groupCheckboxStatus(className);
                        if (status) {
                            self.errorHandler.hideError(field);
                        } else {
                            self.errorHandler.showError(field);
                        }
                    } else {
                        if (field.checked) {
                            self.errorHandler.hideError(field);
                        } else {
                            self.errorHandler.showError(field);
                        }

                    }
                } else {
                    self.errorHandler.hideError(field);
                }
            }
        },

        groupCheckboxStatus: function (cName) {
            var c = document.getElementsByClassName(cName);
            var elements = c[0].getElementsByTagName('input');
            for (var i = 0; i < elements.length; i++) {
                for(var j = i; j < elements.length; j++){
                    elements[j].classList.remove("input-error");
                }
                if (elements[i].type == 'checkbox') {
                    if (elements[i].checked) {
                        return true
                    }
                }
            }
            return false;
        },

        dropdownValidation: function (field) {
            var self = NG.forms;
            if (field.value) {
                self.errorHandler.hideError(field);
            }
        },

        checkAttributes: function (field) {
            var self = NG.forms;
            if (field.hasAttribute('minlength')) {
                if (field.value.length < parseInt(field.getAttribute('minlength'))) {
                    self.errorHandler.showError(field, 'minlength');
                }
            }

            if (field.hasAttribute('min')) {
                if (parseInt(field.value) < parseInt(field.getAttribute('min'))) {
                    self.errorHandler.showError(field, 'min');
                }
            }
            if (field.hasAttribute('max')) {
                if (parseInt(field.value) > parseInt(field.getAttribute('max'))) {
                    self.errorHandler.showError(field, 'max');
                }
            }
        },
        cprValidation: function (field) {
            var self = NG.forms;
            var modifiedCPR = self.validateHandler.getModifiedCPR(field);
            var dobDetails = modifiedCPR.substring(0, 6).match(/.{1,2}/g); //Format DDMMYY
            var day = dobDetails[0];
            var month = dobDetails[1];
            var year = self.validateHandler.getCPRYear(modifiedCPR, dobDetails[2]);
            var validateCPR = self.validateHandler.validateCPRNumber(field, year, month, day);
            var checkKindiNumber = self.validateHandler.kindiNumber(modifiedCPR);
            var age = '';
            var dob = '';
            var gender = '';
            if (!checkKindiNumber && validateCPR) {
                age = self.validateHandler.getAge(year, month, day);
                dob = self.validateHandler.getDOB(year, month, day);
                gender = self.validateHandler.getGender(modifiedCPR);
            }
            return {
                getAge: age,
                getDOB: dob,
                getGender: gender,
                validateCPR: validateCPR
            }
        },
        validateCPRNumber: function (field, year, month, day) {
            var self = NG.forms;
            var modifiedCPR = self.validateHandler.getModifiedCPR(field);
            var cprRegExp = self.default.patterns.cpr;
            var modifiedCPRLength = modifiedCPR.length;
            if (modifiedCPRLength == 9) {
                modifiedCPR = '0' + modifiedCPR;
                modifiedCPRLength = modifiedCPR.length;
            }
            if (!cprRegExp.test(modifiedCPR)) {
                self.errorHandler.showError(field);
                return false;
            }

            if (modifiedCPRLength == 10) {
                //if cprvalue is a kindi number then following condition will return true
                if (modifiedCPR[0] == 8 && modifiedCPRLength == 10) {
                    self.errorHandler.hideError(field);
                    return true;
                }
                var checkPattern = self.validateHandler.modulo10(modifiedCPR);
                if (checkPattern) {
                    var checkValid = self.validateHandler.validateDate(year, month, day);
                    if (checkValid) {
                        self.errorHandler.hideError(field);
                        return true;
                    } else {
                        self.errorHandler.showError(field);
                        return false;
                    }
                } else {
                    if (self.validateHandler.ignoreDatesForCPR(year, month, day)) {
                        self.errorHandler.hideError(field);
                        return true;
                    } else {
                        self.errorHandler.showError(field);
                        return false;
                    }
                }
            } else {
                self.errorHandler.showError(field);
                return false;
            }
        },
        ignoreDatesForCPR: function (year, month, day) {
            var ignoreYearsWithMonths = ['01/01/1960', '01/01/1964', '01/01/1965', '01/01/1966', '01/01/1969', '01/01/1970',
                '01/01/1974', '01/01/1980', '01,01/1982', '01/01/1984', '01/01/1985', '01/01/1986',
                '01/01/1987', '01/01/1988', '01/01/1989', '01/01/1990', '01/01/1991', '01/01/1992']
            var selectedDate = day + '/' + month + '/' + year;
            if (ignoreYearsWithMonths.indexOf(selectedDate) != -1) {
                return true;
            }
            return false;
        },
        kindiNumber: function (cprNumber) {
            if (cprNumber[0] == 8 && cprNumber.length == 10) {
                return true;
            }
            return false;
        },
        getCPRYear: function (cprNumber, year) {
            var centuryChar = parseInt(cprNumber[6]);
            var fullYear = '19' + year;
            if (centuryChar == 4 || centuryChar == 9) {
                if (year <= 36) {
                    fullYear = '20' + year;
                }
            } else if (centuryChar > 4) {
                if (year > 57) {
                    fullYear = '19' + year;
                } else {
                    fullYear = '20' + year;
                }
            }

            return parseInt(fullYear);
        },
        getModifiedCPR: function (field) {
            var fieldValue = field.value.trim();
            var modifiedCPR = fieldValue.replace('-', '').replace(/ /g, ''); // will replace '-' with ''.
            var modifiedCPRLength = modifiedCPR.length;
            if (modifiedCPRLength == 9) {
                modifiedCPR = '0' + modifiedCPR;
                modifiedCPRLength = modifiedCPR.length;
            }
            return modifiedCPR;
        },

        modulo10: function (modifiedCPRValue) {
            var sum = 0;
            var modifiedCPRLength = modifiedCPRValue.length;
            var modulo10pattern = [4, 3, 2, 7, 6, 5, 4, 3, 2, 1];
            for (var i = 0; i <= modifiedCPRLength - 1; i++) {
                sum += modifiedCPRValue[i] * modulo10pattern[i]
            }

            if (sum % 11 == 0) {
                return true;
            }
            return false;
        },
        ssnValidation: function (field) {
            var self = NG.forms;
            var age = '';
            var dob = '';
            var gender = '';
            var separator = self.validateHandler.checkSeparator(field.value.trim());
            var modifiedSSN = self.validateHandler.getModifiedSSN(field);
            var dobDetails = modifiedSSN.substring(0, 6).match(/.{1,2}/g); //Format YYDDMM
            var modifiedSSNFormat = self.validateHandler.changeDateFormat(modifiedSSN);
            var day = dobDetails[2];
            var month = dobDetails[1];
            var year = self.validateHandler.getSSNYear(modifiedSSNFormat, separator);
            var validateSSN = self.validateHandler.validateSSNNumber(field, year, month, day);
            if (validateSSN) {
                var birthNumber = modifiedSSN.substring(7, 9);
                gender = self.validateHandler.getGender(birthNumber);
                dob = self.validateHandler.getDOB(year, month, day);
                age = self.validateHandler.getAge(year, month, day);
            }

            return {
                getAge: age,
                getDOB: dob,
                getGender: gender,
                validateSSN: validateSSN
            }
        },
        checkSeparator: function (fieldValue) {
            if (fieldValue.indexOf('+') != -1) {
                return '+';
            } else if (fieldValue.indexOf('-') != -1) {
                return '-';
            } else {
                return '';
            }
        },
        getModifiedSSN: function (field) {
            var fieldValue = field.value.trim();
            var modifiedSSN = fieldValue.replace('-', '').replace(/ /g, '').replace('+', ''); // will replace '-' with ''.
            var modifiedSSNLength = modifiedSSN.length;

            if (modifiedSSNLength == 12) {
                modifiedSSN = modifiedSSN.substring(2, 12);
            }

            return modifiedSSN;
        },
        changeDateFormat: function (modifiedSSN) {
            var ssnValue = modifiedSSN.substring(0, 10).match(/.{1,2}/g);
            var modifiedDOB = ssnValue[2] + ssnValue[1] + ssnValue[0] + ssnValue[3] + ssnValue[4];

            return modifiedDOB;
        },
        getSSNYear: function (value, separator) {
            var self = NG.forms;
            var date = self.validateHandler.checkDate(value);
            var year = date.getFullYear();
            if (separator == '+') {
                year = date.getFullYear() - 100;
            } else {
                year = date.getFullYear();
            }

            return parseInt(year);
        },
        checkDate: function (cprNumber) {
            var dobDetails = cprNumber.substring(0, 6).match(/.{1,2}/g); // split dob to an array as 'dd,mm,yy'.
            var date = new Date(Date.UTC(dobDetails[2], dobDetails[1] - 1, dobDetails[0], 0, 0, 0, 0));
            return date;
        },
        validateSSNNumber: function (field, year, month, day) {
            var self = NG.forms;
            var ssnRegExp = self.default.patterns.ssn;
            var modifiedSSN = self.validateHandler.getModifiedSSN(field);
            var modifiedSSNFormat = self.validateHandler.changeDateFormat(modifiedSSN);
            var modifiedSSNLength = modifiedSSN.length;
            if (!ssnRegExp.test(modifiedSSN)) {
                //display error here
                self.errorHandler.showError(field);
                return false;
            }
            if (modifiedSSNLength == 10) {
                var checkPattern = self.validateHandler.luhnAlgorithm(modifiedSSN);
                if (checkPattern) {
                    var checkValid = self.validateHandler.validateDate(year, month, day);
                    if (checkValid) {
                        self.errorHandler.hideError(field)
                        return true;
                    } else {
                        self.errorHandler.showError(field);
                        return false;
                    }
                } else {
                    self.errorHandler.showError(field);
                    return false;
                }
            } else {
                self.errorHandler.showError(field);
                return false;
            }
        },
        luhnAlgorithm: function (ssnNumber) {
            var self = NG.forms;
            var reverseNum = self.validateHandler.reverseString(ssnNumber);
            var sum = 0;
            for (var i = 0; i <= (reverseNum.length - 1); i++) {
                var value = parseInt(reverseNum[i], 10);
                value = (i % 2 == 1) ? value * 2 : value;
                if (value > 9) {
                    value -= 9;
                }
                sum += value;
            }

            return sum % 10 === 0;
        },
        reverseString: function (ssnNumber) {
            return ssnNumber.split('').reverse().join('');
        },
        ssnFIValidation: function (field) {
            var self = NG.forms;
            var fieldValue = field.value.trim();
            var age = '';
            var dob = '';
            var gender = '';
            //var modifiedSSN = this.getModifiedSSN(fieldId);
            var dobDetails = fieldValue.substring(0, 6).match(/.{1,2}/g); //Format DDMMYY
            var separator = fieldValue[6];
            var day = dobDetails[0];
            var month = dobDetails[1];
            var year = self.validateHandler.getFinSSNYear(dobDetails[2], separator);
            var validateSSN = self.validateHandler.validateFINSSNNumber(field, year, month, day);
            if (validateSSN) {
                var birthNumber = fieldValue.substring(8, 10);
                gender = self.validateHandler.getGender(birthNumber);
                dob = self.validateHandler.getDOB(year, month, day);
                age = self.validateHandler.getAge(year, month, day);
            }

            return {
                getAge: age,
                getDOB: dob,
                getGender: gender,
                validateSSN: validateSSN
            }
        },
        getFinSSNYear: function (year, separator) {
            var fullYear = '19' + year;
            if (separator == '-') {
                fullYear = '19' + year;
            } else if (separator == '+') {
                fullYear = '18' + year;
            } else if (separator == 'A') {
                fullYear = '20' + year;
            }

            return parseInt(fullYear);
        },
        validateFINSSNNumber: function (field, year, month, day) {
            var self = NG.forms;
            var ssnRegExp = self.default.patterns.ssnFI;
            var fieldValue = field.value.trim();
            var modifiedSSN = '';
            if (fieldValue[6] == 'A') {
                modifiedSSN = fieldValue.replace('A', '');
            } else if (fieldValue[6] == '+') {
                modifiedSSN = fieldValue.replace('+', '');
            } else {
                modifiedSSN = fieldValue.replace('-', '');
            }
            var modifiedSSNLength = modifiedSSN.length;

            if (!ssnRegExp.test(fieldValue)) {
                //display error here
                self.errorHandler.showError(field);
                return false;
            }
            if (modifiedSSNLength == 10) {
                var checkPattern = self.validateHandler.checkControlCharacter(modifiedSSN);
                if (checkPattern) {
                    var checkValid = self.validateHandler.validateDate(year, month, day);
                    if (checkValid) {
                        self.errorHandler.hideError(field)
                        return true;
                    } else {
                        self.errorHandler.showError(field);
                        return false;
                    }
                } else {
                    self.errorHandler.showError(field);
                    return false;
                }
            } else {
                self.errorHandler.showError(field);
                return false;
            }
        },
        checkControlCharacter: function (ssnNumber) {
            var checkSumString = '0123456789ABCDEFHJKLMNPRSTUVWXY';
            var ssnValue = parseInt(ssnNumber.substring(0, 9));
            var remainder = ssnValue % 31;
            var lastIndexValue = ssnNumber.substr(-1);
            return checkSumString[remainder] == lastIndexValue;
        },
        personNumberValidation: function (field) {
            var self = NG.forms;
            var fieldValue = field.value.trim();
            var age = '';
            var dob = '';
            var gender = '';
            var dobDetails = fieldValue.substring(0, 6).match(/.{1,2}/g); //Format DDMMYY
            var checkNum = fieldValue.substring(8, 10);
            var day = self.validateHandler.getDay(fieldValue, dobDetails[0]);
            var month = dobDetails[1];
            var year = self.validateHandler.getPersonNumberYear(dobDetails[2], checkNum);
            var validateSSN = self.validateHandler.validatePersonNumber(field, year, month, day);
            var isDNumber = false;
            if (validateSSN) {
                var birthNumber = fieldValue.substring(8, 10);
                gender = self.validateHandler.getGender(birthNumber);
                dob = self.validateHandler.getDOB(year, month, day);
                age = self.validateHandler.getAge(year, month, day);
                isDNumber = self.validateHandler.checkDNumber(fieldValue);
            }

            return {
                getAge: age,
                getDOB: dob,
                getGender: gender,
                validateSSN: validateSSN,
                isDNumber: isDNumber
            }

        },
        getDay: function (fieldValue, day) {
            var self = NG.forms;
            if (self.validateHandler.checkDNumber(fieldValue)) {
                return (day[0] - 4) + day[1];
            } else {
                return day;
            }
        },
        checkDNumber: function (fieldValue) {
            if (fieldValue[0] > 3 && fieldValue[0] < 8 && fieldValue.length == 11) {
                return true;
            } else {
                return false;
            }
        },
        getPersonNumberYear: function (year, checkNum) {
            var fullYear = '19' + year;
            var modifiedCheckNum = parseInt(checkNum);
            if (modifiedCheckNum > 499) {
                if (modifiedCheckNum < 750 && year >= 54) {
                    fullYear = '18' + year;
                } else if (year < 40) {
                    fullYear = '20' + year;
                } else if (modifiedCheckNum >= 900 && year >= 40) {
                    fullYear = '19' + year;
                }
            }
            return parseInt(fullYear);
        },
        validatePersonNumber: function (field, year, month, day) {
            var self = NG.forms;
            var ssnRegExp = self.default.patterns.personNumber;
            var fieldValue = field.value.trim();
            var ssnLength = fieldValue.length;

            if (!ssnRegExp.test(fieldValue)) {
                //display error here
                self.errorHandler.showError(field);
                return false;
            }
            if (ssnLength == 11) {
                var checkPattern = self.validateHandler.validateCheckSum(fieldValue);
                if (checkPattern) {
                    var checkValid = self.validateHandler.validateDate(year, month, day);
                    if (checkValid) {
                        self.errorHandler.hideError(field)
                        return true;
                    } else {
                        self.errorHandler.showError(field);
                        return false;
                    }
                } else {
                    self.errorHandler.showError(field);
                    return false;
                }
            } else {
                self.errorHandler.showError(field);
                return false;
            }
        },
        checkSum: function (checkSumArray, value) {
            var sum = 0;
            var modifiedSSNLength = checkSumArray.length;
            for (var i = 0; i <= modifiedSSNLength - 1; i++) {
                sum += parseInt(value[i]) * checkSumArray[i];
            }

            if (sum % 11 == 0) {
                return true;
            }

            return false;
        },
        validateCheckSum: function (ssnNumber) {
            var self = NG.forms;
            var primaryCheckSum = [3, 7, 6, 1, 8, 9, 4, 5, 2, 1];
            var secondaryCheckSum = [5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 1];
            if (self.validateHandler.checkSum(primaryCheckSum, ssnNumber) && self.validateHandler.checkSum(secondaryCheckSum, ssnNumber)) {
                return true;
            } else {
                return false;
            }
        },
        validateDate: function (year, month, day) {
            var self = NG.forms;
            var isValid = true;
            var isValidDate = self.validateHandler.checkValidDate(year, month, day);
            if (isValidDate) {
                isValid = true;
            } else {
                isValid = false;
            }
            return isValid;
        },
        checkValidDate: function (year, month, day) {
            var givenDate = year + month + day;
            var cprDate = new Date(year, month - 1, day);
            var modifiedMonth = (cprDate.getMonth() + 1) < 10 ? '0' + (cprDate.getMonth() + 1).toString() : (cprDate.getMonth() + 1).toString();
            var modifiedDay = cprDate.getDate() < 10 ? '0' + (cprDate.getDate()).toString() : (cprDate.getDate()).toString();
            var modifiedDate = cprDate.getFullYear().toString() + modifiedMonth + modifiedDay;
            return (givenDate == parseInt(modifiedDate));
        },

        getDOB: function (year, month, day) {
            var self = NG.forms;
            var dob = month + '/' + day + '/' + year;
            var checkDate = self.validateHandler.validateDate(year, month, day);
            if (checkDate) {
                return dob;
            } else {
                return "Invalid Date";
            }
        },
        getAge: function (year, month, day) {
            var self = NG.forms;
            var dob = self.validateHandler.getDOB(year, month, day);
            if (dob == "Invalid Date") {
                return dob;
            }
            return self.validateHandler.calculateAge(dob);
        },

        calculateAge: function (birthday) {
            var today = new Date();
            var checkLeapYear = function (year) {
                var date = new Date(year, 1, 28);
                date.setDate(date.getDate() + 1);
                return date.getMonth() === 1;
            }
            var dob = new Date(birthday);
            if (dob) {
                var diffyrs = today.getFullYear() - dob.getFullYear();
                dob.setFullYear(dob.getFullYear() + diffyrs);
                if (dob > today) {
                    diffyrs -= 1;
                    dob.setFullYear(dob.getFullYear() - 1)
                }
                var diffdays = (today.getTime() - dob.getTime()) / (3600 * 24 * 1000);
                var age = diffyrs + diffdays / (checkLeapYear(today.getFullYear()) ? 366 : 365);
                if (age < 0) {
                    age = 0;
                }
                return age.toFixed(2);
            } else {
                return 'Invalid Date';
            }
        },
        getGender: function (cprNumber) {
            if (isNaN(cprNumber % 2)) {
                return "Invalid Text";
            }
            return cprNumber % 2 == 0 ? 'Female' : 'Male';
        }

    },

    splitClass: function (target) {
        var self = NG.forms
        if (target !== '') {
            var classes = target.split(" ");
            classes = classes.filter(Boolean);
            for (var i = 0; i < classes.length; i++) {
                var name = classes[i];
            }
            return name;
        }
    },

    submitHandler: {
        buildFormDatas: function () {
            var self = NG.forms
            var apiParams = self.fetchFields();
            self.submitHandler.submit(apiParams);
        },
        submit: async function (params) {
            var self = NG.forms
            var sendToAPI = self.default.settings.formSendType;
            switch (sendToAPI) {
                default:
                    if (await NG.egainAPI.invokeAPI(params)) {
                        var form = self.formContainerId;
                        var feedbackBtn = form.getElementsByClassName('feedback');
                        if (feedbackBtn.length) {
                            DB.trackFeedback(self.default.params.labelParams.feedback.value, self.default.params.labelParams.comments.value);
                        }
                        self.submitHandler.showSuccessReceipt();
                    }
                    else {
                        self.submitHandler.showErrorReceipt();
                    }
                    break;
            }

        },

        buildAutoReply: function () {

        },

        showSuccessReceipt: function () {
            var self = NG.forms;
            var id = self.formContainerId.id;
            var splitId = id.split('-');
            var asideElement = document.getElementById(splitId[1] + '-receipt');
            $(asideElement).foundation('open');
            self.formContainerId.reset();
            if (typeof DB.trackFormSubmit === 'function') {
                DB.trackFormSubmit();
            } else {
                DB.trackFormSubmit('Track Form submission is missing in main JS');
            }
            sessionStorage.removeItem("sessionStatusSet");
            localStorage.removeItem("sessionStatusSet");
            self.addEventListener(asideElement, 'click', self.asideHandler);
            $(window).trigger('HIDE_SPINNER');
        },

        showErrorReceipt: function () {
            var self = NG.forms;
            if (typeof DB.trackFormSubmit === 'function') {
                DB.trackFormSubmit('Error during eGain Submission');
            }
            var heading = self.errorHandler.getErrorMessage('errHeading');
            var displayName = self.errorHandler.setErrorHeading(self.formElements);
            heading = self.errorHandler.buildNameError(heading, 'name', displayName);
            var technicalError = self.errorHandler.getErrorMessage('technicalError');
            var el = document.createElement('div');
            el.className = 'callout alert-box radius warning';
            var attrs = {
                "tabindex": "0",
                "aria-live": "assertive",
                "role": "alertdialog",
                "data-closable": "slide-out-up"
            }
            self.setAttributes(el, attrs);
            el.innerHTML = `<svg class="icon alert xlarge "><use xlink:href="#svg-alert"></use></svg><h3 class="font-human">${heading}</h3><p>${technicalError}</p><button tabindex="0" aria-label="Close Alert" data-close="" class="close"><svg class="icon close"><use xlink:href="#svg-close"></use></svg></button>`;
            var form = self.formContainerId;
            var parent = form.parentNode;
            var errElement = parent.getElementsByClassName("warning");
            if (errElement.length < 1) {
                self.insertAfter(form, el);
            } else {
                var node = parent.getElementsByClassName('warning')[0];
                parent.removeChild(node);
                self.insertAfter(form, el);
            }
            el.focus();
            $(window).trigger('HIDE_SPINNER');
        }

    },
    errorHandler: {
        errorFocus: function () {
            document.querySelector('.input-error').focus();
        },
        showError: function (field, errType) {
            var self = NG.forms;
            self.errorHandler.addError(field);
            var parentNode = field.parentNode;
            var classAttr = field.className;
            var theClasses = self.findClass(classAttr, 'verifyList');
            theClasses = theClasses ? theClasses : field.type;
            var type = (errType === undefined) ? theClasses : errType;
            var errElement = parentNode.getElementsByClassName("error_msg");
            if (errElement.length > 0) {
                parentNode.removeChild(parentNode.lastElementChild);
            }
            self.errorHandler.buildError(field, parentNode, type);
        },
        setErrorHeading: function (elements) {
            var self = NG.forms;
            for (var i = 0; i < elements.length; i++) {
                var field = elements[i]
                var className = self.hasClass(field, 'name');
                if (className) {
                    return field.value;
                }
            }
            return self.errorHandler.getErrorMessage('user');
        },
        buildError: function (field, parent, type) {
            var self = NG.forms;
            if (!field.dataset.errormessage) {
                var messageText = self.errorHandler.buildMessageText(field, type);
            } else {
                var messageText = field.dataset.errormessage;
            }
            var div = document.createElement('div');
            div.className = 'error_msg';
            div.innerHTML = `<span>&nbsp;</span>` + messageText;
            switch (type) {
                case 'checkbox':
                    var groupType = self.checkboxType(field);
                    if (groupType) {
                        var parent = self.errorHandler.buildGroupError(field);
                    }
                    parent.appendChild(div);
                    break;
                default:
                    parent.appendChild(div);
                    break;
            }
        },
        buildMessageText: function (field, type) {
            var self = NG.forms;
            switch (type) {
                case 'minlength':
                    var messageText = self.errorHandler.getErrorMessage(type);
                    var lenKey = 'length'
                    messageText = self.errorHandler.buildLengthError(field, messageText, type, lenKey);
                    break;
                case 'min':
                    var messageText = self.errorHandler.getErrorMessage(type);
                    messageText = self.errorHandler.buildValueError(field, messageText, type);
                    break;
                case 'max':
                    var messageText = self.errorHandler.getErrorMessage(type);
                    messageText = self.errorHandler.buildValueError(field, messageText, type);
                    break;
                default:
                    var messageText = self.errorHandler.getErrorMessage(type);
                    break;
            }

            return messageText;
        },
        buildLengthError: function (field, message, key, lenkey) {
            var text = message.replace('{' + key + '}', field.getAttribute(key)).replace('{' + lenkey + '}', field.value.length);
            return text;
        },
        buildValueError: function (field, message, key) {
            var text = message.replace('{' + key + '}', field.getAttribute(key));
            return text;
        },
        buildNameError: function (message, type, key) {
            var text = message.replace('{' + type + '}', key);
            return text;
        },
        buildGroupError: function (field) {
            var parentElement = field.closest('.groupCheckbox');
            var errElement = parentElement.getElementsByClassName("error_msg");
            if (errElement.length > 0) {
                parentElement.removeChild(parentElement.lastElementChild);
            }
            return parentElement;
        },
        hideError: function (field) {
            var self = NG.forms
            switch (field.type) {
                case 'checkbox':
                    var groupType = self.checkboxType(field);
                    if (groupType) {
                        var parentNode = field.closest('.groupCheckbox');
                    } else {
                        var parentNode = field.parentNode;
                    }
                    break;
                default:
                    var parentNode = field.parentNode;
                    break;
            }
            if (parentNode.getElementsByClassName('error_msg').length > 0) {
                parentNode.removeChild(parentNode.lastElementChild);
            }
            self.errorHandler.removeError(field);

            // Min & Max length validation 
            // Min & Max value validation
            self.validateHandler.checkAttributes(field);
        },
        addError: function (field) {
            var self = NG.forms;
            field.classList.add("input-error");
            var item = field.id;
            if (self.errors.indexOf(item) === -1) {
                self.errors.push(item);
            }
        },
        removeError: function (field) {
            var self = NG.forms;
            field.classList.remove("input-error");
            var array = self.errors;
            array = array.filter(v => v !== field.id);
            self.errors = array
        },
        getErrorMessage: function (type) {
            var self = NG.forms;
            var language = self.global.language.toLowerCase()
            switch (language) {
                case 'da':
                    return self.errormessage[type].dk;
                case 'se':
                    return self.errormessage[type].se;
                case 'no':
                    return self.errormessage[type].no;
                case 'fi':
                    return self.errormessage[type].fi;
                case 'en':
                    return self.errormessage[type].en;
            }

        }
    },

    setAttributes: function (el, attrs) {
        for (var key in attrs) {
            el.setAttribute(key, attrs[key]);
        }
    },

    getUserName: function (lan, type) {
        switch (lan) {
            case 'da':
                return self.errormessage[type].dk;
            case 'se':
                return self.errormessage[type].se;
            case 'no':
                return self.errormessage[type].no;
            case 'fi':
                return self.errormessage[type].fi;
            case 'en':
                return self.errormessage[type].en;
        }
    },

    hasClass: function (target, theClass) {
        var pattern = new RegExp("(^| )" + theClass + "( |$)");
        if (pattern.test(target.className)) {
            return true;
        }
        return false;
    },

    fetchFields: function () {
        var self = NG.forms;
        var curFields = self.finalFieldsSet(self.fields);
        self.finalFieldSet = curFields;
        self.elementsArePrepared = false;
        var txt = ''
        txt += self.preText();
        var outputText = self.buildStructure(curFields, txt);
        //outputText += self.postURL();
        self.outputText = outputText;
        return self;
    },
    finalFieldsSet: function (fields) {
        var field = [];
        for (var i = 0; i < fields.length; i++) {
            var inputElement = fields[i];
            switch (inputElement.type) {
                case 'radio':
                    if (inputElement.checked) {
                        field.push(inputElement);
                    }
                    break;
                case 'checkbox':
                    if (inputElement.checked) {
                        field.push(inputElement);
                    }
                    break;
                default:
                    field.push(inputElement);
                    break;
            }
        }
        return field;
    },
    postURL: function () {
        var self = NG.forms;
        var customURL = document.getElementById('__URL');
        customURL = (typeof customURL !== 'object') ? customURL.value : customURL;
        var pageUrl = (typeof customURL !== 'object') ? customURL.value : self.global.pageUrl;
        self.buildCustomURL(customURL, pageUrl);
    },

    buildCustomURL: function (url) {
        var urlText = "URL: ";
        var postUrl = urlText + url;
        return postUrl;
    },

    buildStructure: function (fields, txt) {
        var self = NG.forms;
        var outputText = txt;
        for (i = 0; i < fields.length; i++) {
            var element = fields[i]
            outputText += self.getFieldLabel(element) + self.default.settings.fieldValPairDelim + self.getFieldValues(element) + self.default.settings.commaDelim;
        }
        return outputText;
    },

    getFieldLabel: function (input) {
        var self = NG.forms;
        var label = input.getAttribute('data-cblabel');
        if (label === undefined || label === "" || label === null) {
            label = self.findLabel(input);
        }
        return label;
    },
    getFieldValues: function (input) {
        return input.value;
    },

    preText: function (heading) {
        return heading === undefined || null ? "" : heading;
    },
    prepareElementLists: function () {
        var self = NG.forms
        var container = self.formContainerId;
        var allElements = container.elements;
        var filteredElements = self.inputFilters(allElements);
        self.formElements = filteredElements;
        return filteredElements;
    },
    elementStatus: function (field) {
        var self = NG.forms;
        if (self.isHidden(field) && !self.hasClass(field, 'default')) {
            return { type: false }
        }
        else {
            return { type: true };
        }
    },

    defaultParams: function (field, defaults) {
        var self = NG.forms;
        var name = field.name;
        var value = field.value;
        defaults[name] = value;
        self.default.params.hiddenParams = defaults;
    },

    getLabelParams: function (field, labelList) {
        var self = NG.forms;
        var label = field.getAttribute('data-cblabel');
        var mapNameAttr = field.getAttribute('data-mappingfieldname');
        var mapeGainAttr = field.getAttribute('data-maptoegain');
        var includeInMailAttr = field.getAttribute('data-includeinmail');
        var isHeadingAttr = false;
        if (field.getAttribute('data-heading')) {
            isHeadingAttr = field.getAttribute('data-heading');
        }
        var value = field.value;
        var labels = {};
        labels["labelMap"] = label;
        labels["NameMap"] = mapNameAttr;
        labels["eGainMap"] = mapeGainAttr;
        labels["includeInMail"] = includeInMailAttr;
        labels["isHeading"] = isHeadingAttr;
        labels["value"] = value;
        labelList[field.name] = labels;
        self.default.params.labelParams = labelList;
    },
    findLabel: function (fld) {
        var labelTxt = "";
        var sibling;
        var siblings = fld.parentNode.childNodes;
        for (var i = 0; i < siblings.length; i++) {
            sibling = siblings[i];
            if (sibling.nodeType == 1) {
                tagname = sibling.tagName.toUpperCase();
                if (tagname == "LABEL" || tagname == "LEGEND") {
                    labelTxt = $(sibling).text();
                    labelTxt = labelTxt.replace(/\*/gm, "");
                    break;
                }
            }
        }
        return labelTxt;
    },
    isHidden: function (el) {
            return (el.offsetParent === null); 
    },
    sortFields: function () {
        var self = NG.forms;
        var fld = [];
        var allfieldsIdList = [];
        self.fields = [];
        self.hiddenFields = [];
        var defaultObj = {};
        var customObj = {};
        self.prepareElementLists();
        self.elementsArePrepared = true;
        if (self.elementsArePrepared) {
            fld = self.formElements
            for (var i = 0; i < fld.length; i++) {
                var inputelement = fld[i];
                var inputelementId = (inputelement.id !== undefined) ? inputelement.id : inputelement.name;
                var status = self.elementStatus(inputelement)
                if (status.type === true) {
                    if (inputelement.type !== 'radio' && inputelement.type !== 'checkbox') {
                        self.getLabelParams(inputelement, customObj);
                    }
                    else {
                        if (inputelement.checked) {
                            self.getLabelParams(inputelement, customObj);
                        }
                    }
                    self.fields.push(inputelement);
                } else {
                    self.defaultParams(inputelement, defaultObj);
                    self.hiddenFields.push(inputelement);
                }
                allfieldsIdList.push(inputelementId);
            }
            return {
                fldIdList: allfieldsIdList
            }
        }
    },
    inputFilters: function (inputs) {
        var self = NG.forms;
        var field = [];
        for (var i = 0; i < inputs.length; i++) {
            var inputElement = inputs[i];
            if (inputElement.type !== 'button' && inputElement.type !== 'submit') {
                switch (inputElement.type) {
                    default:
                        field.push(inputElement);
                        break;
                }
            }
        }
        return field;
    },
    loadJSON: function (file, callback) {
        var rawFile = new XMLHttpRequest();
        rawFile.open("GET", file, false);
        rawFile.onload  = function () {
            if (rawFile.readyState === 4 && rawFile.status == "200") {
                callback(rawFile.responseText);
            }
        } 
        rawFile.send();
    },
    loadDataListItems: function () {
        //Load Data List
        var self = NG.forms;
        //Load Country List
        var className = 'countryList';
        var dataType = 'countries';
        var dataListElements = document.getElementsByClassName(className);


        if (dataListElements.length > 0) {
            let countrylistItems = self[dataType][self.global.market];
            for (var i = 0; i < dataListElements.length; i++) {
                let dataListElement = dataListElements[i];
                let listId = dataListElement.list.id;
                var parent = document.getElementById(listId);

                for (var j = 0; j < countrylistItems.length; j++) {
                    var node = document.createTextNode(countrylistItems[j]['name']);
                    var ele = document.createElement("option");
                    ele.append(node);
                    parent.appendChild(ele);
                }

            }
        }
        className = 'phoneCodeList';
        dataType = 'countries';
        dataListElements = document.getElementsByClassName(className);
        if (dataListElements.length > 0) {
            let countrylistItems = self[dataType][self.global.market];
            for (var i = 0; i < dataListElements.length; i++) {
                let dataListElement = dataListElements[i];
                let listId = dataListElement.list.id;
                var parent = document.getElementById(listId);

                for (var j = 0; j < countrylistItems.length; j++) {
                    var node = document.createTextNode(countrylistItems[j]['name']);
                    var ele = document.createElement("option");
                    ele.value = countrylistItems[j]['dial_code'];
                    ele.append(node);
                    parent.appendChild(ele);
                }
            }
        }
        className = 'post-number';
        dataType = 'postalcode';
        dataListElements = document.getElementsByClassName(className);
        if (dataListElements.length > 0) {
            let postlistItems = self[dataType][self.global.market];
            for (var i = 0; i < dataListElements.length; i++) {
                let dataListElement = dataListElements[i];
                let listId = dataListElement.list.id;
                var parent = document.getElementById(listId);

                for (key in postlistItems) {
                    let postNumber = key.replace("Nr", "");
                    var node = document.createTextNode(postlistItems[key]);
                    var ele = document.createElement("option");
                    ele.value = postNumber;
                    ele.append(node);
                    parent.appendChild(ele);
                }
            }
        }
    },
    loadPostName: function (field) {
        var self = NG.forms;
        dataType = 'postalcode';
        let listItems = self[dataType][self.global.market];
        let selectedValue = "Nr" + field.value;
        let id = field.id + "-value";

        let postalName = listItems[selectedValue];
        if (typeof postalName !== 'undefined') {
            let postalCodeName = document.getElementById(id);
            postalCodeName.value = postalName;
        }




    },
    checkboxType: function (field) {
        var nearRow = field.closest('.row');
        var className = 'groupCheckbox';
        var groupType = nearRow.classList.contains(className);
        return groupType;
    },
    findClass: function (target, className) {
        var self = NG.forms
        if (target !== '') {
            var classes = target.split(" ");
            classes = classes.filter(Boolean);
            for (var i = 0; i < classes.length; i++) {
                var name = classes[i];
                if (name === className) {
                    return true;
                } else {
                    if (className === 'verifyList') {
                        if (self.classes.lists.indexOf(name) !== -1) {
                            return name;
                        } else {
                            return false;
                        }
                    }
                }
            }
        } else {
            return false;
        }
    },
    loadJSONFiles: function () {
        var self = NG.forms;
        if (self.global.getSupportFiles) {
            var filesLength = self.global.getSupportFiles.length;
            for (var i = 0; i < filesLength; i++) {
                var type = self.global.getSupportFiles[i].type;
                var path = self.global.getSupportFiles[i].path;
                 self.loadJSON(path, function (text) {
                    var data = JSON.parse(text);
                    var dataType = data.type
                    self[dataType] = data;                    
                });
            }
        }
    },
    addEventListener: function (target, type, listener) {
        target.addEventListener(type, listener, false);
    },

    eventHandler: {
        handleSubmit: function (e) {
            e.preventDefault();
            var self = NG.forms;
            self.sortFields()
            var elements = self.fields;
            if (!self.default.settings.trackInit) {
                self.default.settings.trackInit = true;
                if (typeof DB.trackFormInit === 'function') {
                    DB.trackFormInit();
                }
            }
            self.validateHandler.validStatus(elements, e.type);
            if (self.isValid) {
                $(window).trigger('SHOW_SPINNER');
                self.submitHandler.buildFormDatas();
            } else {
                self.errorHandler.errorFocus();
            }
        },
        handleClick: function (e) {
            var self = NG.forms;
            if (!self.default.settings.trackInit) {
                self.default.settings.trackInit = true;
                if (typeof DB.trackFormInit === 'function') {
                    DB.trackFormInit();
                }
            }
            self.callActiveSession();
        },
        handleBlur: function (e) {
            var self = NG.forms;
            var field = e.target;
            var type = e.type;
            if (!self.default.settings.trackInit) {
                self.default.settings.trackInit = true;
                if (typeof DB.trackFormInit === 'function') {
                    DB.trackFormInit();
                }
            }
            self.callActiveSession();
            self.validateHandler.validates(field, type);
        },
        handleTouchend: function (e) {
            var self = NG.forms;
            self.sortFields()
            var elements = self.fields;
            if (!self.default.settings.trackInit) {
                self.default.settings.trackInit = true;
                if (typeof DB.trackFormInit === 'function') {
                    DB.trackFormInit();
                }
            }
            self.callActiveSession();
            self.validateHandler.validStatus(elements, e.type);
            if (self.isValid) {
                self.submitHandler.buildFormDatas();
            } else {
                self.errorHandler.errorFocus();
            }
        },
        handleChange: function (e) {
            var self = NG.forms
            var field = e.target;
            var type = e.type;
            if (self.hasClass(field, 'post-number')) {
                self.loadPostName(field);
            }
            if (!self.default.settings.trackInit) {
                self.default.settings.trackInit = true;
                if (typeof DB.trackFormInit === 'function') {
                    DB.trackFormInit();
                }
            }
            self.callActiveSession();
            self.validateHandler.validates(field, type);
        },
        handleFeedback: function (e) {
            e.preventDefault();
            var self = NG.forms
            var field = e.target;
            var radioElement = field.id + '_hdn';
            document.getElementById(radioElement).checked = true;
            var type = field.dataset.response;
            var hostName = window.location.hostname;
            var market = hostName.substring((hostName.lastIndexOf(".") + 1)).toLowerCase();
            var commentSection = document.querySelector("#yes-comment");
            commentSection.setAttribute("maxlength", "250");
            self.feedbackForms(type);
        }
    },
    feedbackForms: function (type) {
        var el = document.querySelector('.csl-feedback');
        var message = el.getElementsByClassName('csl-message');
        var yesOption = el.querySelector('.yes');
        var noOption = el.querySelector('.no');
        for (var i = 0; i < message.length; i++) {
            message[i].style.display = "block";
        }
        switch (type) {
            case "yes":
                yesOption.style.display = "block";
                noOption.style.display = "none";
                break;
            case "no":
                yesOption.style.display = "none";
                noOption.style.display = "block";
                break;
        }
        DB.trackFeedback(type);
        return
    },
    destroyEvents: function () {
        var self = NG.forms;
        var form = self.formContainerId;
        var submitButton = form.querySelector('.ngSendButton') || form.querySelector('.ngEsigning');
        var feedbackBtn = form.getElementsByClassName('feedback');
        submitButton.removeEventListener('click', self.eventHandler.handleSubmit, false);
        form.removeEventListener('blur', self.eventHandler.handleBlur, false);
        form.removeEventListener('change', self.eventHandler.handleChange, false);
        form.removeEventListener('click', self.eventHandler.handleClick, false);
        form.removeEventListener('touch', self.eventHandler.handleTouchend, false);
        if (feedbackBtn) {
            for (var i = 0; i < feedbackBtn.length; i++) {
                feedbackBtn[i].addEventListener('click', self.eventHandler.handleFeedback, false);
                feedbackBtn[i].addEventListener('touch', self.eventHandler.handleFeedback, false);
            }
        }
    },
    formLoadTracking: function () {
        var self = NG.forms;
        DB.trackFormLoad({
            form_product: self.global.pageTitle,
            form_type: "Homepages",
            form_name: self.formName,
            form_step: (self.formStep === null) ? 'Single Step' : 'Multi Step'
        });
    },
    settingMaxLength: function () {
        var self = NG.forms;
        var fields = self.fields;
        for (var i = 0; i < fields.length; i++) {
            var tagName = fields[i].type;
            var hasAttr = fields[i].hasAttribute('maxlength');
            if (tagName !== 'select-one' && !hasAttr) {
                var fldName = fields[i].getAttribute('data-mappingfieldname');
                var attr = self.maxlength.name[fldName];
                var attrLen = (attr !== undefined) ? self.maxlength.name[fldName].maxlength : 20;
                fields[i].setAttribute('maxlength', attrLen);
            }
        }
    },
    asideHandler: function () {
        var self = NG.forms;
        var redirectURL = self.global.redirectURL;
        if (redirectURL === "") {
            document.location.href = "/";
        } else {
            document.location.href = redirectURL;
        }
    },
    insertAfter: function (target, element) {
        target.parentNode.insertBefore(element, target.nextSibling);
    },
    getTextCount: function (e) {
        var element = e.target;
        var textareaValue = e.target.value;
        var textareaMaxLength = e.target.getAttribute('maxlength');
        if (textareaValue != "") {
            var charactersLength = textareaValue.length;
            element.parentNode.querySelector('.entered-char').textContent = charactersLength;
            element.parentNode.querySelector('.total-char').textContent = ' / ' + textareaMaxLength;
        } else {
            element.parentNode.querySelector('.entered-char').textContent = '';
            element.parentNode.querySelector('.total-char').textContent = textareaMaxLength;
        }
    },
    showTextLimiter: function () {
        var self = NG.forms;
        var showLimiterDiv = document.createElement('div');
        showLimiterDiv.className = 'char-limit';
        showLimiterDiv.innerHTML = `<span class="entered-char"></span> <span class="total-char"></span>`;
        var form = self.formContainerId;
        var txtArea = form.querySelector('.show-limiter');
        if (txtArea !== null) {
            var textareaMaxlength = txtArea.hasAttribute('maxlength') ? txtArea.getAttribute('maxlength') : 400;
            self.insertAfter(txtArea, showLimiterDiv);
            txtArea.parentNode.querySelector('.total-char').textContent = textareaMaxlength;
            var textareaElement = form.querySelector('.show-limiter');
            self.addEventListener(textareaElement, 'input', self.getTextCount);
        }
    },
    builtServerUpdate: function () {
        var self = NG.forms;
        DB.track('eGain Server Down or Sitecore Component issue');
        var heading = self.errorHandler.getErrorMessage('errHeading');
        var displayName = self.errorHandler.getErrorMessage('user');
        heading = self.errorHandler.buildNameError(heading, 'name', displayName);
        var technicalError = self.errorHandler.getErrorMessage('technicalError');
        var el = document.createElement('div');
        el.className = 'callout alert-box radius alert';
        var attrs = {
            "tabindex": "0",
            "aria-live": "assertive",
            "role": "alertdialog",
            "data-closable": "slide-out-up"
        }
        self.setAttributes(el, attrs);
        el.innerHTML = `<svg class="icon alert xlarge "><use xlink:href="#svg-alert"></use></svg><h3 class="font-human">${heading}</h3><p>${technicalError}</p><button tabindex="0" aria-label="Close Alert" data-close="" class="close"><svg class="icon close"><use xlink:href="#svg-close"></use></svg></button>`;
        var form = self.formContainerId;
        var parent = form.parentNode;
        self.insertAfter(form, el);
        form.style.display = "none";
        el.focus();
    },
    asheConfig: function(){
        var self = NG.forms;
        var paramSearch = DB.utils.getSearchParam();
        var asheItemID = document.getElementsByName('AsheSettingsId')[0] !== undefined ? document.getElementsByName('AsheSettingsId')[0].value : document.getElementsByName('AsheSettingsId')[0];
        var hostNameSearch = document.location.hostname.indexOf("editor.");
        if (!paramSearch.hasOwnProperty("code")) {
            if (hostNameSearch === -1) {
                self.callingAsheSolution(asheItemID);
            }
        } else {
            self.asheSuccessFlow(asheItemID);
        }
    },
    callingAsheSolution: function (id) {
        var origin = location.origin;
        var self = NG.forms;
        var verifyRedirectURL =
            origin + "/api/Ashe/CallAsheWithParameters" + "?asheSettingsId=" + id;
        var response = self.httpGet(verifyRedirectURL, false);
        if (response) {
            var redirectURL = decodeURIComponent(response);
            document.location.href = redirectURL;
        } else {
            DB.track('Error in generating URL');
        }
    },

    asheSuccessFlow: function (id) {
        var self = NG.forms;
        var urlParams = DB.utils.getSearchParam();
        var authCode = DB.utils.getQueryParam("code");
        var sessionCheck = sessionStorage.getItem("sessionStatusSet");
        var localCheck = localStorage.getItem("sessionStatusSet");
        var sessionCheck = (localCheck == null) ? 1 : Number(localCheck) + 1;
        if (urlParams.hasOwnProperty("code") && sessionCheck === 1) {
            var authCode = DB.utils.getQueryStringValue("code");
            var authCodeLen = authCode.length;
            if (authCodeLen > 0) {
                var origin = location.origin;
                var verifyURL = origin + "/api/Ashe/VerifyCode?AuthorizationCode=" + authCode + "&asheSettingsId=" + id;
                var status = self.httpGet(verifyURL, false);
                if (status !== "Token retrieval failed") {
                    var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname;
                        window.history.replaceState({path: newurl,},"", newurl);                        
                        var customerData = JSON.parse(status);
                        if (customerData.hasOwnProperty("CustomerNumber")) {
                            // Existing Customer
                            var customerNumber = customerData.CustomerNumber !== undefined ? customerData.CustomerNumber : " ";
                            if (customerData.identity !== null) {
                                var firstName = customerData.identity.names.personNames[0].firstName;
                                firstName = firstName !== undefined ? firstName : "";
                                var lastName = customerData.identity.names.personNames[0].lastName;
                                lastName = lastName !== undefined ? lastName : "";
                                var fullName = firstName + " " + lastName;
                                var email = customerData.contactInformation.emails[0].emailAddress;
                                email = email !== undefined ? email : "";
                                if (firstName !== "undefined") {
                                    self.disableField('prefillFirstName', true);
                                    document.getElementsByClassName('prefillFirstName')[0].value = firstName;
                                } else {
                                    self.disableField('prefillFirstName', false);
                                }
                                if (lastName !== "undefined") {
                                    self.disableField('prefillLastName', true);
                                    document.getElementsByClassName('prefillLastName')[0].value = lastName;
                                } else {
                                    self.disableField('prefillLastName', false);
                                }
                                if (fullName !== "undefined") {
                                    if(document.getElementsByClassName('prefillName')[0] !== undefined) {
                                        self.disableField('prefillName', true);
                                        document.getElementsByClassName('prefillName')[0].value = fullName;
                                    }
                                } else {
                                    self.disableField('prefillName', false);
                                }
                                if (email !== "undefined") {
                                    self.disableField('prefillEmail', true);
                                        document.getElementsByClassName('prefillEmail')[0].value = email;
                                } else {
                                    self.disableField('prefillEmail', false);
                                }
                                if (customerNumber !== "undefined") {
                                    document.getElementsByClassName('prefillCustomerNumber')[0].value = customerNumber;
                                    self.disableField('prefillCustomerNumber', true);
                                } else {
                                    self.disableField('prefillCustomerNumber', false);
                                }
                            } else {
                                document.getElementsByClassName('prefillCustomerNumber')[0].value = "";
                                document.getElementsByClassName('prefillName')[0].value = "";
                                document.getElementsByClassName('prefillFirstName')[0].value = "";
                                document.getElementsByClassName('prefillLastName')[0].value = "";
                                document.getElementsByClassName('prefillEmail')[0].value = "";
                            }
                            
                            
                        } else {
                            // Non Customer
                            var findCustomerID = JSON.parse(customerData.principal);
                            var filterCustomerId =
                                findCustomerID.id !== undefined ? findCustomerID.id : " ";
                            if (filterCustomerId !== "undefined") {
                                document.getElementsByClassName('prefillCustomerNumber')[0].value = filterCustomerId;
                                self.disableField('prefillCustomerNumber', true);
                            } else {
                                self.disableField('prefillCustomerNumber', false);
                            }
                        }
                        localStorage.setItem("sessionStatusSet", Number(localCheck) + 1);
                        sessionStorage.setItem("sessionStatusSet",sessionCheck);
                        self.showForm(true);
                    } else {
                        self.showForm(false);
                        DB.track('not authorised user or token retrieving failed');
                    }
            }
        }else{
           var url = window.location.href;
            url = url.split('?')[0];   
            sessionStorage.removeItem("sessionStatusSet");
            localStorage.removeItem("sessionStatusSet");
            self.clearSession(url);
        }
    },

    clearSession: function (path) {
        var self = NG.forms;
        var origin = location.origin;
        var clearSessionURL = origin + "/api/Ashe/ClearSession";
        var response = self.httpGet(clearSessionURL, false);
        if (response) {
            if(path){
                document.location.href = path;
            }else{
                document.location.reload();
            }
        } else {
             DB.track('ASHE session clear getting failed');
        }
    },
    callActiveSession: function(){
        var self = NG.forms;
        var isAsheValid = document.getElementsByName('__asheLogin')[0] !== undefined ? document.getElementsByName('__asheLogin')[0].value : document.getElementsByName('__asheLogin')[0];        
        var asheItemID = document.getElementsByName('AsheSettingsId')[0] !== undefined ? document.getElementsByName('AsheSettingsId')[0].value : document.getElementsByName('AsheSettingsId')[0];
        var hostNameSearch = document.location.hostname.indexOf("editor.");
        if (isAsheValid === "True" && asheItemID !== undefined && hostNameSearch === -1) {
            if (!self.checkActiveSession(asheItemID)) {
                document.location.reload();
            }
        }
    },
    checkActiveSession: function (id) {
        var self = NG.forms;
        var origin = location.origin;
        var checkSessionURL =
            origin + "/api/Ashe/CheckActiveSession" + "?asheSettingsId=" + id;

        var response = self.httpGet(checkSessionURL, false);
        if (response) {
            sessionStatus = response;
        } else {
            DB.track('Active session status failed ');
        }
        return sessionStatus;
    },

    disableField: function(cname, status){
        document.getElementsByClassName(cname)[0].setAttribute("disabled", status);
    },
    showForm: function(validUser){
        if (validUser) {
            $(".ngcontactform").css("display", "block");
        } else {
            $(".ngcontactform").css("display", "none");
        }
    },
    httpGet: function(theUrl, async){
        var xmlHttp = new XMLHttpRequest();
        xmlHttp.open( "GET", theUrl, async ); // false for synchronous request
        xmlHttp.send( null );
        if (xmlHttp.status === 200) {
            return JSON.parse(xmlHttp.responseText);
        }  
    },
    init: function () {
         $(window).trigger("SHOW_SPINNER");
        var self = NG.forms;
        self.default.getLanguagecode();
        self.global;
        self.default;
        self.validateHandler;
        self.submitHandler;
        self.eventHandler;
        self.destroyEvents();     
        var isAsheValid = document.getElementsByName('__asheLogin')[0] !== undefined ? document.getElementsByName('__asheLogin')[0].value : document.getElementsByName('__asheLogin')[0];
        if(isAsheValid === 'True') { self.asheConfig();} // ASHE forms Configurations

        //self.showForm(false);
        self.loadJSONFiles(); // Loading supporting JSON Files
        
        // Form load tracking enabling
        if (typeof DB.trackFormLoad === 'function') {
            self.formLoadTracking();
        }

        if (!self.elementsArePrepared) {
            self.sortFields();   // Sorting Fields for validations
            self.settingMaxLength(); //Setting maxlengths for each fields
            self.showTextLimiter();  // Displaying comment sections text counts
            self.loadDataListItems(); // Loading data items in relevant dropdowns 
        }

        if (self.global.serverStatus) {
            self.builtServerUpdate();
            return false;
        }

        var form = self.formContainerId;
        var submitButton = form.querySelector('.ngSendButton') || form.querySelector('.ngEsigning');
        var feedbackBtn = form.getElementsByClassName('feedback');
        if (self.elementsArePrepared) {
            if (document.addEventListener) {
                submitButton.addEventListener('click', self.eventHandler.handleSubmit, false);
                form.addEventListener('blur', self.eventHandler.handleBlur, true);
                form.addEventListener('change', self.eventHandler.handleChange, true);
                form.addEventListener('click', self.eventHandler.handleClick, true);
                form.addEventListener('touch', self.eventHandler.handleTouchend, true);
                if (feedbackBtn) {
                    for (var i = 0; i < feedbackBtn.length; i++) {
                        feedbackBtn[i].addEventListener('click', self.eventHandler.handleFeedback, true);
                        feedbackBtn[i].addEventListener('touch', self.eventHandler.handleFeedback, true);
                    }
                }
            }
        };

        setTimeout(function(){ $(window).trigger('HIDE_SPINNER'); }, 500);
         
        // Back button 

        var sessionStatus = false;
        var _listnercheck = function (e) {
            e.preventDefault();
            var sessionCheck = sessionStorage.getItem("sessionStatusSet");
            if (sessionCheck === 'active') {
                NG.forms.clearSession();
            }
        }

        window.addEventListener("unload", _listnercheck, false);

        window.onpageshow = function (event) {
            if (event.persisted) {
                NG.forms.clearSession();
            }
        };

        if (sessionStorage.getItem("sessionStatusSet") == "1") {
            window.onbeforeunload = function (evt) {
                return "custom message";
            };
       }
    }
};

NG.start(NG.forms);
