//Egain API for NextGen Forms || Developed by Duraimanickam M 

// Version 1.0

'use strict';
var api_base_url = window.location.origin;

NG["egainAPI"] = {
	jsonObj: {},
	__apiResponse: null,
	endpointURL: api_base_url + '/api/formshelper/sendtoegain',
	apiKey: 'B8ED07F6-6258-4A3C-BB38-6B54D3FFA45B',
	invokeAPI: async function (ngForms) {
		if (typeof ngForms !== 'undefined') {
			var params = ngForms.default.params;
			var lang = ngForms.global.language;
			this.__initializeVars(params, lang);
			this.__buildBody(params.labelParams);
			let apiResponse = await this.__callAPI(this.jsonObj);
			if (apiResponse === "success") {
				return true;
			}
			else {
				return false;
			}

		}

	},
	__initializeVars: function (params, language) {
		let primaryEmail = (params.labelParams.email && params.labelParams.email.value) ?? 'no-reply@scuser.com';
		let primaryName = (params.labelParams.name && params.labelParams.name.value) ?? '';
		let primaryFirstName = (params.labelParams.firstName && params.labelParams.firstName.value) ?? 'scuser';
		if (primaryFirstName == 'scuser' && primaryName != '') {
			primaryFirstName = primaryName;
		}
		let dsId = params.hiddenParams.__dsID ?? '';
		let emailSubject = params.hiddenParams.__formSubj ?? '';
		let webFormName = params.hiddenParams.__webFormName ?? '';
		let includePageUrlInMail = params.hiddenParams.__URLPARAM ?? 'true';
		this.jsonObj = {
			"email": primaryEmail,
			"name": primaryName,
			"firstname": primaryFirstName,
			"emailsubject": emailSubject,
			"webformname": webFormName,
			"dsid": dsId,
			"IncludePageUrlInMail": includePageUrlInMail,
			"language": language,
			"version": "v1",
			"formfieldsdata":
			{
				"formfields": []
			}
		};

	},

	__buildBody: function (params) {
		var phoneCode = "";
		let phoneElements = document.getElementsByName("phoneCode")
		if (phoneElements.length == 1) {
			phoneCode = phoneElements[0].value;
		}
		for (var key in params) {
			let formFields = {};
			let value = params[key].value;

			//Remove ! and + as Egain DB doesn't support
			value = value.replace(/[!+]/g, '');
			//Remove % as Egain DB doesn't support % character
			value = value.replace(/[%]/g, ' Percent');

			//Combine Phone code to phone number

			if (params[key].NameMap == 'customer_phone') {

				value = phoneCode + "" + params[key].value;
				value = value.replace(/\D/g, "");//Remove + or any other chars
			}


			formFields["fieldname"] = params[key].NameMap;
			formFields["fieldlabel"] = params[key].labelMap;
			formFields["fieldvalue"] = value;
			formFields["maptoegain"] = params[key].eGainMap;
			formFields["isheader"] = params[key].isHeading;
			formFields["includeinmailboxemail"] = params[key].includeInMail;
			this.jsonObj.formfieldsdata.formfields.push(formFields);
		}


	},
	__callAPI: async function (_data) {

		//POST to API
		const response = await fetch(this.endpointURL, {
			method: "POST",
			body: JSON.stringify(_data),
			headers: { "Content-type": "application/json;charset=UTF-8", "sc_apikey": this.apiKey }
		});
		return await response.json();



	},
	init: function () {
		this.invokeAPI();

	}
}
document.addEventListener("DOMContentLoaded", function (event) {
	NG.egainAPI.init();
});