﻿
(function ($) {
 $(document).ready(function () {
	

	// Initial vars: Nominell rente. Effektiv rente regnes ut i js
	var nomrenteUng = '2.25',
		nomrenteHoy = '2',
		nomrenteLav = '2.60';

	var ung = false;


		var tidConfig = {
			value: 6000,
			range: 'min',
			animate: "fast",
			min: 5000,
			max: 20000,
			step: 500,
			slide: function( event, ui ) {
				slideTid(ui.value);
				var tidVal = $('.tid .amount').attr('value');
				$('.tid .amount').val(tidVal); 
			}
		},
		renteConfig = {
			value: 4,
			range: 'min',
			animate: "fast",
			min: 1,
			max: 5,
			step: 1,
			slide: function( event, ui ) {
				slideRente(ui.value);
				var renteVal = $('.rente .amount').attr('value');
				$('.rente .amount').val(renteVal);
			}
		};

	$("#tid").slider(tidConfig);
	$("#rente-slider").slider(renteConfig);

	
	$( ".tid .amount" ).keyup(function(event) {
		  if (event.which == 13) {
			var tid = $(this).val();
			tid = parseInt(tid);
			tid = Math.max(tid, tidConfig.min);
			tid = Math.min(tid, tidConfig.max);
			slideTid(tid);
			var tidVal = $('.tid .amount').attr('value');
			$('.tid .amount').val(tidVal);
		}
	});
	
	$( ".tid .amount" ).blur(function(event) {
		   var tid = $(this).val();
			tid = parseInt(tid);
			tid = Math.max(tid, tidConfig.min);
			tid = Math.min(tid, tidConfig.max);
			slideTid(tid);
			var tidVal = $('.tid .amount').attr('value');
			$('.tid .amount').val(tidVal);
	});

	$( ".rente .amount" ).keyup(function(event) {
		  if (event.which == 13) {
			var rente = $(this).val().replace(',', '.');
			rente = parseFloat(rente);
			rente = Math.max(rente, renteConfig.min);
			rente = Math.min(rente, renteConfig.max);
			slideRente(rente);
			var renteVal = $('.rente .amount').attr('value');
			$('.rente .amount').val(renteVal);
		}
	});
	
	$( ".rente .amount" ).blur(function(event) {
			var rente = $(this).val().replace(',', '.');
			rente = parseFloat(rente);
			rente = Math.max(rente, renteConfig.min);
			rente = Math.min(rente, renteConfig.max);
			slideRente(rente);
			var renteVal = $('.rente .amount').attr('value');
			$('.rente .amount').val(renteVal);
	});


	$( ".amount" ).focus(function() {
		var value = $(this).val().toString().replaceAll(" ","");
		$(this).val(value);

	}).keyup(function(event) {
		if(event.which != 13) {
			$(this).parent('.right').find('.tooltip-enter').slideDown(300);
		} else {

			// Next tabindex
			var tab = $(this).attr("tabindex");
			$("[tabindex='" + (tab+1) + "']").focus();
		}

	}).blur(function() {
		$(this).parent('.right').find('.tooltip-enter').slideUp(300);
		prettyOutput = prettyNumbers($(this).val());
		$(this).val(prettyOutput);
	});


	var slideTid = function(value) {
		$('#tid').slider('option','value', value);
		$('.tid').find('.amount').attr("value", value);
		$('.tid input.amount').val(value);
		
		regnUtSum();
	}

	var slideRente = function(value) {
		$('#rente-slider').slider('option','value', value);
		$('.rente').find('.amount').attr("value", value)
		$('.rente input.amount').val(value);
		regnUtSum();
	}


	// Prettify numbers
	function prettyNumbers(x) {
		return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ");
	}

	// Find replace all
	String.prototype.replaceAll = function(search, replacement) {
		var target = this;
		return target.split(search).join(replacement);
	};

	// Tooltip: Renteforklaringer
	$('.q').hover(function(){
		// Hover over code
		var title = $(this).attr('title');
		$(this).data('tipText', title).removeAttr('title');
		$('<p class="tooltip-renter"></p>')
		.text(title)
		.appendTo('body')
		.fadeIn(400);
	}, function() {
			// Hover out code
			$(this).attr('title', $(this).data('tipText'));
			$('.tooltip-renter').remove();
	}).mousemove(function(e) {
			var mousex = e.pageX - 100; //Get X coordinates
			var mousey = e.pageY + 10; //Get Y coordinates
			$('.tooltip-renter')
			.css({ top: mousey, left: mousex })
	});

	// Funksjon som kan gjenbrukes ved ulike events for å hente ut verdiene
	hentVerdier = function() {
		var tid = $('.tid').find('.amount').val(),
			rente = $('.rente').find('.amount').val()
			console.log('H function--------' )
			tid = parseInt(tid);
			rente = parseInt(rente);
		
		return {
			aar: tid,
			rente: rente
		};
	}

	
	// Regn ut månedspris
	regnUtSum = function() {
		var v 	= hentVerdier(),
		n = v.rente * 12;
		p = 6/12;
		dividend = Math.pow( (1+(p / 100)) , n ) * (p/100);
		divisor = Math.pow( (1+(p / 100)),n) - 1;
		a = ( dividend / divisor )	* v.aar;
		
		console.log("v.rente 1: "+v.rente);
		 
		var sumMnd = (a);
		var sum = prettyNumbers(sumMnd.toFixed(0));
		$('#sum').html(sum);
		
        console.log("n : "+n);
		console.log("v.rente 2 : "+v.rente);
		console.log("sum : "+sum);
		
	}

	// Trigger ved page load
	var v 	= hentVerdier();
	regnUtSum();
});
})(jQuery);