/*! @preserve
 * bootbox.js
 * version: 5.0.0
 * author: Nick Payne <nick@kurai.co.uk>
 * license: MIT
 * http://bootboxjs.com/
 */
!function(root,factory){"use strict";"function"==typeof define&&define.amd?define(["jquery"],factory):"object"==typeof exports?module.exports=factory(require("jquery")):root.bootbox=factory(root.jQuery)}(this,function init($,undefined){"use strict";var hasOwnProperty,hasDontEnumBug,dontEnums,dontEnumsLength;Object.keys||(Object.keys=(hasOwnProperty=Object.prototype.hasOwnProperty,hasDontEnumBug=!{toString:null}.propertyIsEnumerable("toString"),dontEnumsLength=(dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"]).length,function(obj){if("function"!=typeof obj&&("object"!=typeof obj||null===obj))throw new TypeError("Object.keys called on non-object");var result=[],prop,i;for(prop in obj)hasOwnProperty.call(obj,prop)&&result.push(prop);if(hasDontEnumBug)for(i=0;i<dontEnumsLength;i++)hasOwnProperty.call(obj,dontEnums[i])&&result.push(dontEnums[i]);return result}));var exports={},VERSION="5.0.0";exports.VERSION="5.0.0";var locales={},templates={dialog:'<div class="bootbox modal" tabindex="-1" role="dialog" aria-hidden="true"><div class="modal-dialog"><div class="modal-content"><div class="modal-body"><div class="bootbox-body"></div></div></div></div></div>',header:'<div class="modal-header"><h5 class="modal-title"></h5></div>',footer:'<div class="modal-footer"></div>',closeButton:'<button type="button" class="bootbox-close-button close" aria-hidden="true">&times;</button>',form:'<form class="bootbox-form"></form>',button:'<button type="button" class="btn"></button>',option:"<option></option>",promptMessage:'<div class="bootbox-prompt-message"></div>',inputs:{text:'<input class="bootbox-input bootbox-input-text form-control" autocomplete="off" type="text" />',textarea:'<textarea class="bootbox-input bootbox-input-textarea form-control"></textarea>',email:'<input class="bootbox-input bootbox-input-email form-control" autocomplete="off" type="email" />',select:'<select class="bootbox-input bootbox-input-select form-control"></select>',checkbox:'<div class="form-check checkbox"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-checkbox" type="checkbox" /></label></div>',radio:'<div class="form-check radio"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-radio" type="radio" name="bootbox-radio" /></label></div>',date:'<input class="bootbox-input bootbox-input-date form-control" autocomplete="off" type="date" />',time:'<input class="bootbox-input bootbox-input-time form-control" autocomplete="off" type="time" />',number:'<input class="bootbox-input bootbox-input-number form-control" autocomplete="off" type="number" />',password:'<input class="bootbox-input bootbox-input-password form-control" autocomplete="off" type="password" />',range:'<input class="bootbox-input bootbox-input-range form-control-range" autocomplete="off" type="range" />'}},defaults={locale:"en",backdrop:"static",animate:!0,className:null,closeButton:!0,show:!0,container:"body",value:"",inputType:"text",swapButtonOrder:!1,centerVertical:!1,multiple:!1};function mapArguments(args,properties){var argn=args.length,options={};if(argn<1||argn>2)throw new Error("Invalid argument length");return 2===argn||"string"==typeof args[0]?(options[properties[0]]=args[0],options[properties[1]]=args[1]):options=args[0],options}function mergeArguments(defaults,args,properties){return $.extend(!0,{},defaults,mapArguments(args,properties))}function mergeDialogOptions(className,labels,properties,args){var locale,swapButtons,baseOptions;args&&args[0]&&(locale=args[0].locale||defaults.locale,(args[0].swapButtonOrder||defaults.swapButtonOrder)&&(labels=labels.reverse()));return validateButtons(mergeArguments({className:"bootbox-"+className,buttons:createLabels(labels,locale)},args,properties),labels)}function validateButtons(options,buttons){var allowedButtons={};return each(buttons,function(key,value){allowedButtons[value]=!0}),each(options.buttons,function(key){if(allowedButtons[key]===undefined)throw new Error("button key `"+key+"` is not allowed (options are "+buttons.join(" ")+")")}),options}function createLabels(labels,locale){for(var buttons={},i=0,j=labels.length;i<j;i++){var argument=labels[i],key=argument.toLowerCase(),value=argument.toUpperCase();buttons[key]={label:getText(value,locale)}}return buttons}function getText(key,locale){var labels=locales[locale];return labels?labels[key]:locales.en[key]}function sanitize(options){var buttons,total;if("object"!=typeof options)throw new Error("Please supply an object of options");if(!options.message)throw new Error("`message` option must not be null or an empty string.");return(options=$.extend({},defaults,options)).buttons||(options.buttons={}),buttons=options.buttons,total=getKeyLength(buttons),each(buttons,function(key,button,index){if($.isFunction(button)&&(button=buttons[key]={callback:button}),"object"!==$.type(button))throw new Error("button with key `"+key+"` must be an object");if(button.label||(button.label=key),!button.className){var isPrimary=!1;isPrimary=options.swapButtonOrder?0===index:index===total-1,button.className=total<=2&&isPrimary?"btn-primary":"btn-secondary btn-default"}}),options}function getKeyLength(obj){return Object.keys(obj).length}function each(collection,iterator){var index=0;$.each(collection,function(key,value){iterator(key,value,index++)})}function processCallback(e,dialog,callback){var preserveDialog;e.stopPropagation(),e.preventDefault(),$.isFunction(callback)&&!1===callback.call(dialog,e)||dialog.modal("hide")}function validateMinOrMaxValue(input,type,name,value,compareValue,options){if(value!==undefined)if("date"===type)input.attr(name,value),/(\d{4})-(\d{2})-(\d{2})/.test(value)||console.warn("Browsers which natively support the `date` input type expect date values to be of the form `YYYY-MM-DD`  (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your "+name+" value may not be enforced by this browser.");else if("time"===type){if(!/([01][0-9]|2[0-3]):[0-5][0-9]?:[0-5][0-9]/.test(value))throw new Error("`"+name+"` is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.");if(!(compareValue===undefined||options.max>options.min))throw new Error("`max` must be greater than `min`. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-"+name+" for more information.");input.attr(name,value)}else{if(isNaN(value))throw new Error("`"+name+"` must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-"+name+" for more information.");if(!(compareValue===undefined||options.max>options.min))throw new Error("`max` must be greater than `min`. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-"+name+" for more information.");input.attr(name,value)}return input}return exports.locales=function(name){return name?locales[name]:locales},exports.addLocale=function(name,values){return $.each(["OK","CANCEL","CONFIRM"],function(_,v){if(!values[v])throw new Error("Please supply a translation for `"+v+"`")}),locales[name]={OK:values.OK,CANCEL:values.CANCEL,CONFIRM:values.CONFIRM},exports},exports.removeLocale=function(name){if("en"===name)throw new Error("`en` is used as the default and fallback locale and cannot be removed.");return delete locales[name],exports},exports.setLocale=function(name){return exports.setDefaults("locale",name)},exports.setDefaults=function(){var values={};return 2===arguments.length?values[arguments[0]]=arguments[1]:values=arguments[0],$.extend(defaults,values),exports},exports.hideAll=function(){return $(".bootbox").modal("hide"),exports},exports.init=function(_$){return init(_$||$)},exports.dialog=function(options){if($.fn.modal===undefined)throw new Error("`$.fn.modal` is not defined; please double check you have included the Bootstrap JavaScript library. See http://getbootstrap.com/javascript/ for more details.");if(options=sanitize(options),$.fn.modal.Constructor.VERSION){options.fullBootstrapVersion=$.fn.modal.Constructor.VERSION;var i=options.fullBootstrapVersion.indexOf(".");options.bootstrap=options.fullBootstrapVersion.substring(0,i)}else options.bootstrap="2",options.fullBootstrapVersion="2.3.2",console.warn("Bootbox will *mostly* work with Bootstrap 2, but we do not officially support it. Please upgrade, if possible.");var dialog=$(templates.dialog),innerDialog=dialog.find(".modal-dialog"),body=dialog.find(".modal-body"),header=$(templates.header),footer=$(templates.footer),buttons=options.buttons,callbacks={onEscape:options.onEscape};if(body.find(".bootbox-body").html(options.message),getKeyLength(options.buttons)>0&&(each(buttons,function(key,b){var button=$(templates.button);switch(button.data("bb-handler",key),button.addClass(b.className),key){case"ok":case"confirm":button.addClass("bootbox-accept");break;case"cancel":button.addClass("bootbox-cancel")}button.html(b.label),footer.append(button),callbacks[key]=b.callback}),body.after(footer)),!0===options.animate&&dialog.addClass("fade"),options.className&&dialog.addClass(options.className),options.size&&(options.fullBootstrapVersion.substring(0,3)<"3.1"&&console.warn("`size` requires Bootstrap 3.1.0 or higher. You appear to be using "+options.fullBootstrapVersion+". Please upgrade to use this option."),"large"===options.size?innerDialog.addClass("modal-lg"):"small"===options.size&&innerDialog.addClass("modal-sm")),options.title&&(body.before(templates.header),dialog.find(".modal-title").html(options.title)),options.closeButton){var closeButton=$(templates.closeButton);options.title?options.bootstrap>3?dialog.find(".modal-header").append(closeButton):dialog.find(".modal-header").prepend(closeButton):closeButton.prependTo(body)}return options.centerVertical&&(options.fullBootstrapVersion<"4.0.0"&&console.warn("`centerVertical` requires Bootstrap 4.0.0-beta.3 or higher. You appear to be using "+options.fullBootstrapVersion+". Please upgrade to use this option."),innerDialog.addClass("modal-dialog-centered")),dialog.one("hide.bs.modal",function(e){e.target===this&&(dialog.off("escape.close.bb"),dialog.off("click"))}),dialog.one("hidden.bs.modal",function(e){e.target===this&&dialog.remove()}),dialog.one("shown.bs.modal",function(e){dialog.find(".bootbox-accept:first").trigger("focus")}),"static"!==options.backdrop&&dialog.on("click.dismiss.bs.modal",function(e){dialog.children(".modal-backdrop").length&&(e.currentTarget=dialog.children(".modal-backdrop").get(0)),e.target===e.currentTarget&&dialog.trigger("escape.close.bb")}),dialog.on("escape.close.bb",function(e){callbacks.onEscape&&processCallback(e,dialog,callbacks.onEscape)}),dialog.on("click",".modal-footer button:not(.disabled)",function(e){var callbackKey=$(this).data("bb-handler");processCallback(e,dialog,callbacks[callbackKey])}),dialog.on("click",".bootbox-close-button",function(e){processCallback(e,dialog,callbacks.onEscape)}),dialog.on("keyup",function(e){27===e.which&&dialog.trigger("escape.close.bb")}),$(options.container).append(dialog),dialog.modal({backdrop:!!options.backdrop&&"static",keyboard:!1,show:!1}),options.show&&dialog.modal("show"),dialog},exports.alert=function(){var options;if((options=mergeDialogOptions("alert",["ok"],["message","callback"],arguments)).callback&&!$.isFunction(options.callback))throw new Error("alert requires the `callback` property to be a function when provided");return options.buttons.ok.callback=options.onEscape=function(){return!$.isFunction(options.callback)||options.callback.call(this)},exports.dialog(options)},exports.confirm=function(){var options;if(options=mergeDialogOptions("confirm",["cancel","confirm"],["message","callback"],arguments),!$.isFunction(options.callback))throw new Error("confirm requires a callback");return options.buttons.cancel.callback=options.onEscape=function(){return options.callback.call(this,!1)},options.buttons.confirm.callback=function(){return options.callback.call(this,!0)},exports.dialog(options)},exports.prompt=function(){var options,promptDialog,form,input,shouldShow,inputOptions;if(form=$(templates.form),(options=mergeDialogOptions("prompt",["cancel","confirm"],["title","callback"],arguments)).value||(options.value=defaults.value),options.inputType||(options.inputType=defaults.inputType),shouldShow=options.show===undefined?defaults.show:options.show,options.show=!1,options.buttons.cancel.callback=options.onEscape=function(){return options.callback.call(this,null)},options.buttons.confirm.callback=function(){var value;if("checkbox"===options.inputType)value=input.find("input:checked").map(function(){return $(this).val()}).get();else if("radio"===options.inputType)value=input.find("input:checked").val();else{if(input[0].checkValidity&&!input[0].checkValidity())return!1;value="select"===options.inputType&&!0===options.multiple?input.find("option:selected").map(function(){return $(this).val()}).get():input.val()}return options.callback.call(this,value)},!options.title)throw new Error("prompt requires a title");if(!$.isFunction(options.callback))throw new Error("prompt requires a callback");if(!templates.inputs[options.inputType])throw new Error("Invalid prompt type");switch(input=$(templates.inputs[options.inputType]),options.inputType){case"text":case"textarea":case"email":case"password":input.val(options.value),options.placeholder&&input.attr("placeholder",options.placeholder),options.pattern&&input.attr("pattern",options.pattern),options.maxlength&&input.attr("maxlength",options.maxlength),options.required&&input.prop({required:!0});break;case"date":case"time":case"number":case"range":if(input.val(options.value),options.placeholder&&input.attr("placeholder",options.placeholder),options.pattern&&input.attr("pattern",options.pattern),options.required&&input.prop({required:!0}),"date"!==options.inputType&&options.step){if(!("any"===options.step||!isNaN(options.step)&&options.step>0))throw new Error("`step` must be a valid positive number or the value `any`. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.");input.attr("step",options.step)}input=validateMinOrMaxValue(input,options.inputType,"min",options.min,options.max,options),input=validateMinOrMaxValue(input,options.inputType,"max",options.max,options.min,options);break;case"select":var groups={};if(inputOptions=options.inputOptions||[],!$.isArray(inputOptions))throw new Error("Please pass an array of input options");if(!inputOptions.length)throw new Error("prompt with `inputType` set to `select` requires at least one option value");options.placeholder&&input.attr("placeholder",options.placeholder),options.required&&input.prop({required:!0}),options.multiple&&input.prop({multiple:!0}),each(inputOptions,function(_,option){var elem=input;if(option.value===undefined||option.text===undefined)throw new Error("each option needs a `value` property and a `text` property");option.group&&(groups[option.group]||(groups[option.group]=$("<optgroup />").attr("label",option.group)),elem=groups[option.group]);var o=$(templates.option);o.attr("value",option.value).text(option.text),elem.append(o)}),each(groups,function(_,group){input.append(group)}),input.val(options.value);break;case"checkbox":var checkboxValues=$.isArray(options.value)?options.value:[options.value];if(!(inputOptions=options.inputOptions||[]).length)throw new Error("prompt with `inputType` set to `checkbox` requires one or more options");input=$('<div class="bootbox-checkbox-list"></div>'),each(inputOptions,function(_,option){if(option.value===undefined||option.text===undefined)throw new Error("each option needs a `value` property and a `text` property");var checkbox=$(templates.inputs[options.inputType]);checkbox.find("input").attr("value",option.value),checkbox.find("label").append("\n"+option.text),each(checkboxValues,function(_,value){value===option.value&&checkbox.find("input").prop("checked",!0)}),input.append(checkbox)});break;case"radio":if(options.value!==undefined&&$.isArray(options.value))throw new Error("prompt with `inputType` set to `radio` requires a single, non-array value for `value`.");if(!(inputOptions=options.inputOptions||[]).length)throw new Error("prompt with `inputType` set to `radio` requires one or more options");input=$('<div class="bootbox-radiobutton-list"></div>');var checkFirstRadio=!0;each(inputOptions,function(_,option){if(option.value===undefined||option.text===undefined)throw new Error("each option needs a `value` property and a `text` property");var radio=$(templates.inputs[options.inputType]);radio.find("input").attr("value",option.value),radio.find("label").append("\n"+option.text),options.value!==undefined&&option.value===options.value&&(radio.find("input").prop("checked",!0),checkFirstRadio=!1),input.append(radio)}),checkFirstRadio&&input.find('input[type="radio"]').first().prop("checked",!0)}if(form.append(input),form.on("submit",function(e){e.preventDefault(),e.stopPropagation(),promptDialog.find(".bootbox-accept").trigger("click")}),""!==$.trim(options.message)){var message=$(templates.promptMessage).html(options.message);form.prepend(message),options.message=form}else options.message=form;return(promptDialog=exports.dialog(options)).off("shown.bs.modal"),promptDialog.on("shown.bs.modal",function(){input.focus()}),!0===shouldShow&&promptDialog.modal("show"),promptDialog},exports.addLocale("en",{OK:"OK",CANCEL:"Cancel",CONFIRM:"OK"}),exports});
/*! @preserve
 * bootbox.locales.js
 * version: 5.0.0
 * author: Nick Payne <nick@kurai.co.uk>
 * license: MIT
 * http://bootboxjs.com/
 */
!function(global,factory){"function"==typeof define&&define.amd?define(["bootbox"],factory):"object"==typeof module&&module.exports?factory(require("./bootbox")):factory(global.bootbox)}(this,function(bootbox){bootbox.addLocale("ar",{OK:"موافق",CANCEL:"الغاء",CONFIRM:"تأكيد"}),bootbox.addLocale("az",{OK:"OK",CANCEL:"İmtina et",CONFIRM:"Təsdiq et"}),bootbox.addLocale("bg_BG",{OK:"Ок",CANCEL:"Отказ",CONFIRM:"Потвърждавам"}),bootbox.addLocale("br",{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Sim"}),bootbox.addLocale("cs",{OK:"OK",CANCEL:"Zrušit",CONFIRM:"Potvrdit"}),bootbox.addLocale("da",{OK:"OK",CANCEL:"Annuller",CONFIRM:"Accepter"}),bootbox.addLocale("de",{OK:"OK",CANCEL:"Abbrechen",CONFIRM:"Akzeptieren"}),bootbox.addLocale("el",{OK:"Εντάξει",CANCEL:"Ακύρωση",CONFIRM:"Επιβεβαίωση"}),bootbox.addLocale("en",{OK:"OK",CANCEL:"Cancel",CONFIRM:"OK"}),bootbox.addLocale("es",{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Aceptar"}),bootbox.addLocale("eu",{OK:"OK",CANCEL:"Ezeztatu",CONFIRM:"Onartu"}),bootbox.addLocale("et",{OK:"OK",CANCEL:"Katkesta",CONFIRM:"OK"}),bootbox.addLocale("fa",{OK:"قبول",CANCEL:"لغو",CONFIRM:"تایید"}),bootbox.addLocale("fi",{OK:"OK",CANCEL:"Peruuta",CONFIRM:"OK"}),bootbox.addLocale("fr",{OK:"OK",CANCEL:"Annuler",CONFIRM:"Confirmer"}),bootbox.addLocale("he",{OK:"אישור",CANCEL:"ביטול",CONFIRM:"אישור"}),bootbox.addLocale("hu",{OK:"OK",CANCEL:"Mégsem",CONFIRM:"Megerősít"}),bootbox.addLocale("hr",{OK:"OK",CANCEL:"Odustani",CONFIRM:"Potvrdi"}),bootbox.addLocale("id",{OK:"OK",CANCEL:"Batal",CONFIRM:"OK"}),bootbox.addLocale("it",{OK:"OK",CANCEL:"Annulla",CONFIRM:"Conferma"}),bootbox.addLocale("ja",{OK:"OK",CANCEL:"キャンセル",CONFIRM:"確認"}),bootbox.addLocale("ko",{OK:"OK",CANCEL:"취소",CONFIRM:"확인"}),bootbox.addLocale("lt",{OK:"Gerai",CANCEL:"Atšaukti",CONFIRM:"Patvirtinti"}),bootbox.addLocale("lv",{OK:"Labi",CANCEL:"Atcelt",CONFIRM:"Apstiprināt"}),bootbox.addLocale("nl",{OK:"OK",CANCEL:"Annuleren",CONFIRM:"Accepteren"}),bootbox.addLocale("no",{OK:"OK",CANCEL:"Avbryt",CONFIRM:"OK"}),bootbox.addLocale("pl",{OK:"OK",CANCEL:"Anuluj",CONFIRM:"Potwierdź"}),bootbox.addLocale("pt",{OK:"OK",CANCEL:"Cancelar",CONFIRM:"Confirmar"}),bootbox.addLocale("ru",{OK:"OK",CANCEL:"Отмена",CONFIRM:"Подтвердить"}),bootbox.addLocale("sk",{OK:"OK",CANCEL:"Zrušiť",CONFIRM:"Potvrdiť"}),bootbox.addLocale("sl",{OK:"OK",CANCEL:"Prekliči",CONFIRM:"Potrdi"}),bootbox.addLocale("sq",{OK:"OK",CANCEL:"Anulo",CONFIRM:"Prano"}),bootbox.addLocale("sv",{OK:"OK",CANCEL:"Avbryt",CONFIRM:"OK"}),bootbox.addLocale("th",{OK:"ตกลง",CANCEL:"ยกเลิก",CONFIRM:"ยืนยัน"}),bootbox.addLocale("tr",{OK:"Tamam",CANCEL:"İptal",CONFIRM:"Onayla"}),bootbox.addLocale("uk",{OK:"OK",CANCEL:"Відміна",CONFIRM:"Прийняти"}),bootbox.addLocale("zh_CN",{OK:"OK",CANCEL:"取消",CONFIRM:"确认"}),bootbox.addLocale("zh_TW",{OK:"OK",CANCEL:"取消",CONFIRM:"確認"})});