/**
 * xhr.js
 */

/*
 * This piece of software was created by Ubisecure Solutions, Inc.
 * All rights reserved. The software is protected by copyright
 * laws and international treaties.
 *
 * Unauthorized reproduction or distribution is prohibited.
 */ 
 
if (typeof XMLHttpRequest == "undefined") {
    XMLHttpRequest = function () {
        try { return new ActiveXObject("Msxml2.XMLHTTP.6.0"); }
        catch (e) {}
        try { return new ActiveXObject("Msxml2.XMLHTTP.3.0"); }
        catch (e) {}
        try { return new ActiveXObject("Microsoft.XMLHTTP"); }
        catch (e) {}
        throw new Error("This browser does not support XMLHttpRequest.");
    };
}

function getFirstNodeValue(xml, nodeName) {
    var list = xml.getElementsByTagName(nodeName);
    if(list == null || list.length < 1) return null;
    var node = list[0];
    var value = "";
    for(var i = 0; i < node.childNodes.length; i++) {
        var n = node.childNodes[i];
        if(n.nodeType != 3) continue;
        value += n.nodeValue;
    }
    return value;
}
