/**
 * view.js
 */

/*
 * This piece of software was created by Ubisecure Solutions, Inc.
 * All rights reserved. The software is protected by copyright
 * laws and international treaties.
 *
 * Unauthorized reproduction or distribution is prohibited.
 */ 
 
function View(obj) {
    this.obj = obj;
}

View.prototype = (function() {
    function buildConversationUrl(base, action, query) {
        var url = base;
        url += "/" + this.obj.conversation.name;
        if(this.obj.conversation.id != null) {
            url += "/" + this.obj.conversation.id;
        }
        url += "/" + action;
        url = this.appendQueryString(url, {
            "entityID":this.obj.conversation.agentRef,
            "locale":this.obj.locale
        });
        url = this.appendQueryString(url, query);
        return url;
    }
    function appendQueryString(url, query) {
        var c = (url.indexOf("?") < 0) ? "?" : "&";
        if(query != null) {
            for(var i in query) {
                var value = query[i];
                if(value == null) continue;
                url += c + encodeURIComponent(i) + "=" + encodeURIComponent(value);
                c = "&";
            }
        }
        return url;
    }
    function getConversationUrl(action, query) {
        return this.buildConversationUrl(this.obj.conversation.baseURL, action, query);
    }
    function getConversationPath(action, query) {
        return this.buildConversationUrl(this.obj.conversation.contextPath, action, query);
    }
    function getMethod() {
        return this.obj.methodRef;
    }
    function getViewServerPage() {
        return this.obj.serverpage;
    }

    function getTemplateName() {
        return this.obj.template.name;
    }
    function getConversationName() {
        return this.obj.conversation.name;
    }
    function getUsername() {
        return this.obj.username;
    }
    function isUsernameReadonly() {
        return this.obj.isUsernameReadonly;
    }
    function getStatus() {
        return this.obj.status;
    }
    function getSubStatus() {
        return this.obj.subStatus;
    }

    
    function getApplicationLink(name) {
        var links = this.obj.links;
        var link = links[name];
        if(link == null) return null;
        var url = this.appendQueryString(link.url, {
            "returnurl":this.getConversationUrl("resume"),
            "entityID":this.obj.conversation.agentRef,
            "locale":this.obj.locale,
            "template":this.obj.template.name,
            "method":this.getMethod(),
            "username":this.obj.username
        });
        return url;
    }
    function getApplicationLinkByRegexp(name) {
       
        var re = new RegExp(name);
        var links = this.obj.links;
        
        var names = Object.keys(links);
        for (var i=0; i<names.length; i++) {
            var name=names[i];
            if (re.test(name)) {
                var link = links[name];
                var url = this.appendQueryString(link.url, {
                    "returnurl":this.getConversationUrl("resume"),
                    "entityID":this.obj.conversation.agentRef,
                    "locale":this.obj.locale,
                    "template":this.obj.template.name,
                    "method":this.getMethod(),
                    "username":this.obj.username
                });
                return url;
            }
        }
        return null;
    }
    function navigate(name) {
        var url = this.getApplicationLink(name);
        if(url == null) return;
        window.location.replace(url);
    }
    function navigate2(name) {
        var url = this.getApplicationLinkByRegexp(name);
        if(url == null) return;
        window.location.href = url;
    }
    function getSessionRelayLink(name, params) {
        var link = this.obj.links[name];
        if(link == null || link.entityID == null) return null;
        var url = this.obj.conversation.contextPath + "/saml2/SessionRelayService";
        var query = {
            "entityID":link.entityID,
            "RelayState":this.getApplicationLink(name)
        };
        if(params) {
            if(params["isPassive"]) query["isPassive"] = "true";
            if(params["forceAuthn"]) query["forceAuthn"] = "true";
            if(params["oneTimeUse"]) query["oneTimeUse"] = "true";
        }
        return this.appendQueryString(url, query);        
    }
    function unsolicited(name, params) {
        var url = this.getSessionRelayLink(name, params);
        if(url == null) return;
        window.location.replace(url);
    }
    function getDiscoveryInfoUrl() {
        var url = this.obj.conversation.contextPath;
        url += "/discovery";
        url = this.appendQueryString(url, {"id":this.obj.conversation.id});
        return url;
    }
    return {
        constructor: View,
        buildConversationUrl: buildConversationUrl,
        appendQueryString: appendQueryString,
        getConversationUrl: getConversationUrl,
        getConversationPath: getConversationPath,
        getMethod: getMethod,
        getViewServerPage: getViewServerPage,
        getTemplateName: getTemplateName,
        getConversationName: getConversationName,
        getUsername: getUsername,
        isUsernameReadonly: isUsernameReadonly,
        getStatus: getStatus,
        getSubStatus: getSubStatus,
        getApplicationLink: getApplicationLink,
        getApplicationLinkByRegexp: getApplicationLinkByRegexp,
        navigate: navigate,
        navigate2: navigate2,
        getSessionRelayLink: getSessionRelayLink,
        unsolicited: unsolicited,
        getDiscoveryInfoUrl: getDiscoveryInfoUrl
    };
})();
