/**
 * script.js
 */

/*
 * This piece of software was created by Ubisecure Solutions, Inc.
 * All rights reserved. The software is protected by copyright
 * laws and international treaties.
 *
 * Unauthorized reproduction or distribution is prohibited.
 */ 
 
function OnWindowLoad() {
    AutoFocus();
}

function AutoFocus() {
    var i;
    var form = document.forms[0];
    if(form != null) {
        if(form.focus != null) {
            try {
                form.focus();
            } catch(err) {
                // ignore
            }
        }
        for(i = 0; i < form.elements.length; i++) {
            var e = form.elements[i];
            if(e == null) continue;
            if(e.type != null && e.type == "hidden") continue;
            if(e.type != null && e.type == "reset") continue;
            if(e.readOnly != null && e.readOnly) continue;
            if(e.disabled != null && e.disabled) continue;
            try {
                var pos = e.value.length;
                if (e.setSelectionRange) {
                    e.setSelectionRange(pos, pos);
                } 
                else if (e.createTextRange) {
                    var range = e.createTextRange();
                    range.collapse(true);
                    range.moveEnd('character', pos);
                    range.moveStart('character', pos);
                    range.select();
                }
            } catch(err) {
                // ignore
            }
            try {
                e.focus();
                break;
            } catch(err) {
                // ignore
            }
        }
    }
}

function OnSubmitClick(event,form) {

    if(!event.target && event.srcElement) {
        event.srcElement.disabled = true;
    } else if(event.target) {
        event.target.disabled = true;
    }
    DisableSubmit(form);
    form.submit();
    return false;

}

function DisableSubmit(form) {
    if(form == null) return;
    for(i = 0; i < form.elements.length; i++) {
        var e = form.elements[i];
        if(e.type != null && e.type == "submit") e.disabled = true;        
    }
}

/**
 * Disables the enter key pressing in the input field where this function is put as the onKeyPress function.
 * The elementToFocus parameter is used to put focus to some other field.
 *
 * @param e
 * @param elementToFocus
 */
function disableEnterKeyAndFocus(e, elementToFocus) {
    var key = (window.event) ? event.keyCode : e.which;
    if (key == 13) {
        elementToFocus.focus();
        return false;
    } else {
        return true;
    }
}

/**
 * Append event handler for given event
 * event name is specified without "on" prefix 
 */
function addEventHandler(name,handler) {
    if(window.addEventListener) {
        window.addEventListener(name, handler, false);
    } else if(window.attachEvent) {
        window.attachEvent("on" + name, handler);
    } else {
        window["on" + name] = handler;
    }
}
