(function() {
    function onPossibleDoubleSubmit(event) {
        if (!event.target) { return; }
        var lastTimeStamp = event.target.getAttribute('data-submittimestamp') || 0;
        var now = new Date().getTime();
        var isDoubleSubmit = (now - lastTimeStamp) < 5000;
        if (isDoubleSubmit) {
            event.preventDefault();
            event.stopPropagation();
            event.stopImmediatePropagation();
            return false;
        } else {
            event.target.setAttribute('data-submittimestamp', now)
            return true;
        }
    }

    function preventDoubleSubmit() {
        var nodes = document.querySelectorAll('.no-double-submit');
        if (!nodes || nodes.length <= 0) { return; }
        for (var i=0; i < nodes.length; i++) {
            nodes[i].addEventListener('click', onPossibleDoubleSubmit);
        }
    }

    function onInputFocus(event) {
        if (!event.target || !event.target.parentNode) { return; }
        var  parent = event.target.parentNode;
        if ((parent.className || "").indexOf('focused', 0) >= 0) { return; }
        parent.className = (parent.className || "") + (parent.className ? " ": "") + "focused";
    }

    function onInputBlur(event) {
        if (!event.target || !event.target.parentNode) { return; }
        var parent = event.target.parentNode;
        if (parent.className && parent.className.indexOf('focused', 0) >= 0) {
            parent.className = (parent.className || "").replace(/\s*focused/g, "");
        }
    }

    function onInputWrapperClick(event) {
        if (!event.target || event.target != this) { return; }
        var  childInputs = event.target.getElementsByTagName("input");
        if (childInputs && childInputs[0]) { childInputs[0].focus(); }
    }

    function wrapInput(labelElem, inputElem) {
        var parent = labelElem.parentNode;
        var wrapper = document.createElement('div');
        var extraClass = inputElem.getAttribute('data-wrapperclass');
        wrapper.className = "posti-input-container" + (extraClass ? " " + extraClass : "");
        parent.replaceChild(wrapper, labelElem);
        wrapper.appendChild(labelElem);
        wrapper.appendChild(inputElem);
        wrapper.addEventListener('click', onInputWrapperClick);
        inputElem.addEventListener('focus', onInputFocus);
        inputElem.addEventListener('blur', onInputBlur);
    }

    function onLanguageChange(event) {
        if (!event || !event.target) { return; }
        event.preventDefault();
        var selectedLanguage = event.target.value;
        var languageselector = document.getElementById("languageselector");
        if (!languageselector) { return; }
        var link = languageselector.querySelector("#" + selectedLanguage + " > a");
        if (!link) { return; }
        document.location = link.href;
    }

    function createLanguageSelector() {
        var footer = document.getElementById("footer");
        if (!footer || !footer.parentNode) { return; }
        var languageselector = document.getElementById("languageselector");
        if (!languageselector) { return; }

        var container = document.createElement("div");
        container.id = "posti-langmenu-wrapper";

        var selector = document.createElement("select");
        selector.id = "posti-langmenu";

        var entries = languageselector.getElementsByTagName("li");
        for (var i=0; i < entries.length; i++) {
           var looper = entries[i];
           var link = looper.getElementsByTagName("a")[0];
           var opt = document.createElement("option");
           opt.setAttribute("lang", looper.id);
           opt.value = looper.id;
           opt.innerText = link.innerText;
           selector.appendChild(opt);
           if (looper.className.indexOf("selectedlocale", 0) !== -1) {
              selector.value = opt.value;
           }
        }

        container.appendChild(selector);
        var sibling = footer.hasChildNodes() ? footer.childNodes[0] : null;
        footer.insertBefore(container, sibling);
        selector.addEventListener('change', onLanguageChange);
    }

    function wrapInputsWithLabels() {
        var labels = document.getElementsByTagName("label");
        for (var i=0; i < labels.length; i++) {
            var labelElem = labels[i];
            forAttr = labelElem.getAttribute("for");
            if (forAttr && document.getElementById(forAttr)) {
                wrapInput(labelElem, document.getElementById(forAttr));
            }
        }
    }

    function hideBlankElements(ids) {
        for (var i=0; i<ids.length; i++) {
            var elem = document.getElementById(ids[i]);
            if (elem && (elem.innerText || "").trim() == "") {
                elem.className += " hidden";
            }
        }
    }

    function hideEmptyGeneralColumn() {
        var container = document.getElementById("general");
        if (!container || (container.innerText || "").trim() != '') { return; }
        var parent = container.parentNode;
        if ((parent.className || "").indexOf('single-column', 0) >= 0) { return; }
        parent.className = (parent.className || "") + (parent.className ? " ": "") + "single-column";
    }

    function toggleExternalMethodAccordion(event) {
        if (event) { event.preventDefault(); }
        var container = document.getElementById("external");
        if (!container) { return; }
        if ((container.className || "").indexOf('open', 0) >= 0) {
            container.className = (container.className || "").replace(/\s*open/g, "");
        } else {
            container.className = (container.className || "") + " open";
        }
    }

    function initExternalMethodAccordion() {
        var container = document.getElementById("external");
        var title = document.getElementById("externaltitlelink");
        if (!container) { return; }
        if ((container.className || "").indexOf('accordion', 0) < 0) { return; }
        if (!title) { return; }
        if ((title.className || "").indexOf('hidden', 0) >= 0) { return; }
        title.addEventListener('click', toggleExternalMethodAccordion);
    }

    function showErrorInPopup(errorElem, errorPopUp) {
        var bodyContent = document.getElementById("bodycontent");
        if (!errorElem || !errorPopUp) { return false; }
        if (!bodyContent || !bodyContent.parentNode) { return false; }

        var popupContainer = document.createElement("div");
        popupContainer.id = "postiErrorPopUpContent";
        var errorLogo = document.createElement("img");
        errorLogo.id = "postiErrorLogo";
        errorLogo.src = "/uas/template/posti/resource/error_logo.svg";
        errorLogo.setAttribute("aria-hidden", "true");
        popupContainer.appendChild(errorLogo);
        popupContainer.appendChild(errorPopUp);
        bodyContent.parentNode.insertBefore(popupContainer, bodyContent);
        errorElem.className += " hidden";
        bodyContent.className += " hidden";

        var closeBtn = document.getElementById("postiErrorPopupCloseBtn");
        if (closeBtn) {
            closeBtn.addEventListener('click', function (e) {
            	e.preventDefault();
                bodyContent.className = bodyContent.className.replace("hidden", "");
                popupContainer.className += " hidden";
            });
        }

        return true;
    }

    function relocateLoginError() {
        var errorContainer = document.getElementById("loginerror");
        if (!errorContainer) { return; }

        var errorPopUp = document.getElementById("postiErrorPopUp");
        if (errorPopUp) {
            if (showErrorInPopup(errorContainer, errorPopUp)) { return; }
        }

        // If page contains both external login methods and username/password,
        // ensure that error messages are displayed at the same location
        var loginitemlists = document.getElementsByClassName("loginitemlist");
        if (!loginitemlists || loginitemlists.length <= 0) { return; }
        var sibling = loginitemlists[0];
        if (!sibling.parentNode) { return; }
        sibling.parentNode.insertBefore(errorContainer, sibling);
    }

    function onPageLoad() {
        preventDoubleSubmit();
        createLanguageSelector();
        wrapInputsWithLabels();
        hideBlankElements(["introtitle", "introtext", "helptitle", "helptext", "logintitle", "logintext", "externaltitle", "externaltext", "posti-register-intro"]);
        hideEmptyGeneralColumn();
        relocateLoginError();
        initExternalMethodAccordion();
    }

    window.clearGenericMfaStrongAuthCookie = function() {
        if (document.cookie.includes("UseMfaStrongAuth=true")) {
            document.cookie="UseMfaStrongAuth=; path=/; expires=Thu, 01 Jan 1970 00:00:01 GMT";
        }
    };

    window.setMfaStrongAuthUrl = function(resumeUrl) {
        var getQueryParam = function getParameterByName(name, url = window.location.href) {
            name = name.replace(/[\[\]]/g, '\\$&');
            var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)');
            var results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, ' '));
        };

        var link = document.getElementById("postiMfaStrongAuthLink");
        if (!link) { return; }
        link.addEventListener('click', function (e) {
        	e.preventDefault();
            document.cookie = "UseMfaStrongAuth=" + (getQueryParam("_id") || "true") + "; path=/";
            window.location.replace(resumeUrl);
        });
    }

    document.addEventListener('DOMContentLoaded', onPageLoad, false);
})();
