﻿DB.fileSizeNotOk = function (file) {
    if (file.length < 1 || file.length > 0 && file[0].files[0].size > 5242880) {
        var fileResult = file.get(0).files;
        for (var x = 0; x < fileResult.length; x++) {
            var fle = fileResult[x];
            var errorText = $("#fileSizeErrorMessage").html();
            $(".filename")
                .append("<tr class='file-up error'><td><div class='input-setm error'><label>" +
                    fle.name +
                    "</label><span class='form-error is-visible'>" +
                    errorText +
                    "</span></td><td><a class='slet' data-file='-1'></a></td></tr>");
        }
        return true;
    }
    return false;
}

DB.disableOrEnableFileInput = function () {
    if ($("#general-upload-files tr.file-up").length >= 10) {
        $('#document-file-label').hide();
        $('#document-file-label-disabled').show();
    } else {
        $('#document-file-label').show();
        $('#document-file-label-disabled').hide();
    }
}

DB.setTimestampField = function () {
    var tidChars = "bcdfghjkmnpqrstvxz";
    var tidStringLength = 4;
    var transId1 = '';
    var transId2, tidTransId;
    var tidNum = 0;
    var i = 0;
    if ($("[id$='fldTimestampH']").val() === '') {
        for (i = 0; i < tidStringLength; i++) {
            tidNum = Math.floor(Math.random() * tidChars.length);
            transId1 += tidChars.substring(tidNum, tidNum + 1);
        }
        transId2 = new Date().getTime();
        tidTransId = transId1 + transId2;
        $("input[id$='fldTimestampH']").val(tidTransId);
    }
}

DB.generalUploadSendSuccess = function () {
    $("#gu-input").fadeOut(700, function () {
        $(this).hide();
    });
    $("#gu-receipt").show();
}

DB.generalUploadSendError = function (errMsg) {
    $("#gu-alert-wrapper").show();
};

DB.checkFileInputWithInsert = function () {
    if ($("#question-container-4 input[type=file]").length >= 10) {
        $('#document-file-label')
            .prop("disabled", "disabled")
            .addClass("disabled")
            .on('click',
                function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                });
    } else {
        if ($("#question-container-4 input[type=file]:last").get(0).files.length > 0) {
            var rand = new Date().getTime();
            $('<input />')
                .prop("type", "file")
                .prop("id", "DocumentFile" + rand)
                .insertBefore($("#question-container-4 input[type=file]:first"));

            $('#document-file-label')
                .prop("for", "DocumentFile" + rand)
                .removeAttr("disabled")
                .removeClass("disabled")
                .off("click");
        }
    }
};

DB.generalUploadAttach = function (file) {
    if (DB.fileSizeNotOk(file)) {
        return false;
    }

    $("tr.error").remove();
    $("#gu-alert-wrapper").hide();
    $("#general-upload-files").trigger('SHOW_SPINNER');

    //DB.stform.timestampFields();
    //DB.stform.setSubject(DB.stform.settings.defaultSubject);
    //DB.stform.setSubject("[Add BPM ID]");
    // $("#fldSubjFile").val(DB.stform.getSubject());
    //$("#uploadFileAction").val("1");
    var formData = new FormData($("#generalUploadForm")[0]);
    $.ajax({
        type: "POST",
        url: "/web/generalupload/attach/",
        data: formData,
        dataType: "json",
        cache: false,
        async: true,
        contentType: false,
        processData: false,
        success: function (result) {
            if (result.ErrorId === "0" || result.ErrorId === "4") {
                $("#general-upload-files").trigger('HIDE_SPINNER');
                var fileIdFromUpload = result.FileId;
                var attachId = result.AttachId;
                var uploadClass = " good";
                var deleteLabel = $("#deleteFileLinkText").text();
                var errorSpan = "";
                if (result.ErrorId === "4") {
                    uploadClass = " error";
                    deleteLabel = "";
                    errorSpan = "<span class='form-error is-visible'>" + $("#technicalErrorMessage").text() + "</span>";
                }
                var fileResult = file.get(0).files;
                for (var x = 0; x < fileResult.length; x++) {
                    var fle = fileResult[x];
                    $(".filename")
                        .append("<tr class='file-up" +
                            uploadClass +
                            "'><td><div class='input-setm" +
                            uploadClass +
                            "'><label>" +
                            fle.name +
                            "</label>" +
                            errorSpan +
                            "</td><td><a class='slet' data-file='" +
                            fileIdFromUpload +
                            "'>" +
                            deleteLabel +
                            "</a></td></tr>");
                }

                DB.disableOrEnableFileInput();

                $(".filename .slet")
                    .off('click')
                    .on('click',
                        function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            DB.generalUploadRemove($(this));
                        });
                file.val("");
                if (attachId !== "" && attachId != null) {
                    $("#AttachId").val(attachId);
                }
            } else {
                $("#general-upload-files").trigger('HIDE_SPINNER');
                errorSpan = "<span class='form-error is-visible'>" + $("#technicalErrorMessage").text() + "</span>";
                $(".filename")
                    .append("<tr class='file-up error'><td><div class='input-setm error'>" +
                    errorSpan +
                    "</td></tr>");
                file.val("");
            }
        },
        error: function (response) {
            $("#general-upload-files").trigger('HIDE_SPINNER');
            errorSpan = "<span class='form-error is-visible'>" + $("#technicalErrorMessage").text() + "</span>";
            $(".filename")
                .append("<tr class='file-up error'><td><div class='input-setm error'>" +
                errorSpan +
                "</td></tr>");
            file.val("");
        }
    });
    return false;
}

DB.generalUploadRemove = function (link) {
    $("gu-alert-wrapper").hide();
    $("#general-upload-files").trigger('HIDE_SPINNER');
    $("input[id$='fldFileId']").val(link.data("file"));
    var formData = new Object();
    formData.FldNavnH = $("#fldNavnH").val();
    formData.FldSubjH = $("#fldSubjH").val();
    formData.FldTimestampH = $("#fldTimestampH").val();
    formData.FldText = $("#fldText").val();
    formData.FileId = $("#fldFileId").val();
    formData.FldSendTo = $("#FldSendTo").val();
    formData.DSId = $("#fldDSId").val();
    formData.DocumentFile0 = $("#gu-document-file").get(0).files;
    formData.Language = $("#fldLang").val();
    formData.AttachId = $("#AttachId").val();
    $.ajax({
        type: "POST",
        url: "/web/generalupload/remove/",
        data: JSON.stringify(formData),
        dataType: "json",
        cache: false,
        async: true,
        contentType: "application/json; charset=utf-8",
        processData: false,
        success: function (result) {
            $("#gu-alert-wrapper").hide();
            $("#general-upload-files").trigger('HIDE_SPINNER');
            if (result.ErrorId === "0") {
                link.closest('.file-up').remove();
                var uploadFileId = link.data('file');
                $('#' + uploadFileId).remove();
                DB.disableOrEnableFileInput();
            }
            else {
                $("#gu-alert-wrapper").show();
            }
        },
        error: function (response) {
            $("#gu-alert-wrapper").show();
            $("#general-upload-files").trigger('HIDE_SPINNER');
        }
    });
}

DB.generatePreText = function (preText) {
    return preText + "!#!#";
};

DB.getlineforEmailString = function (label, value) {
    //val = val.replace(/(\r\n|\n|\r)/gm, '##');
    return label + ": " + value + "!#";
};

DB.generalUploadSendParam = function (from, subject, text) {
    $("input[id$='fldNavnH']").val(from);
    $("input[id$='fldSubjH']").val(subject);
    $("input[id$='fldText']").val(text);
    DB.generalUploadSend();
};

//override this and get your magic done, if you need an action before send call.
DB.beforeGeneralUploadSend = function () {
};

DB.generalUploadSend = function () {
    $("gu-alert-wrapper").hide();
    $("#general-upload-files").trigger('SHOW_SPINNER');
    DB.beforeGeneralUploadSend();
    DB.setTimestampField();
    var formData = new Object();
    formData.FldNavnH = $("#fldNavnH").val();
    formData.FldSubjH = $("#fldSubjH").val();
    formData.FldTimestampH = $("#fldTimestampH").val();
    formData.FldText = $("#fldText").val();
    formData.FileId = $("#fldFileId").val();
    formData.FldSendTo = $("#FldSendTo").val();
    formData.DSId = $("#fldDSId").val();
    formData.DocumentFile0 = $("#gu-document-file").get(0).files;
    formData.Language = $("#fldLang").val();
    formData.AttachId = $("#AttachId").val();
    $.ajax({
        type: "POST",
        url: "/web/generalupload/send/", //window.location.pathname,
        data: JSON.stringify(formData),
        dataType: "json",
        cache: false,
        async: true,
        contentType: "application/json; charset=utf-8",
        processData: false,
        success: function (result) {
            $("#general-upload-files").trigger('HIDE_SPINNER');
            if (result.ErrorId === "0") {
                DB.generalUploadSendSuccess();
                DB.trackFormSubmit();
            } else {
                DB.generalUploadSendError(result.ErrorId);
                DB.trackFormSubmit(result.ErrorId);
            }
        },
        error: function (response) {
            $("#general-upload-files").trigger('HIDE_SPINNER');
            DB.generalUploadSendError(response);
            DB.trackFormSubmit(response);
        }
    });
}

$(document).ready(function () {
    // multiple file uploads + validation
    $("#generalUploadForm").on('change', 'input[type=file]', function () {
        $("#gu-alert-wrapper").hide();
        $("#general-upload-files .input-set .form-error").hide();
        var ext = this.value.substr(this.value.lastIndexOf('.') + 1);
        switch (ext.toLowerCase()) {
            case "pdf":
            case "doc":
            case "docx":
            case "txt":
            case "xls":
            case "xlsx":
            case "jpg":
            case "jpeg":
            case "png":
            case "gif":
                break;
            case '':
                return false;
            default:
                $("#gu-alert-wrapper").show();
                this.value = "";
                return false;
        }
        DB.generalUploadAttach($(this));
        return false;
    });

    $("#gu-sendbutton").on('click', function () {
        DB.generalUploadSend();
        return false;
    });
});