var cqThemeQuiz = null;

if (location.hash) {
    window.scrollTo(0, 0);
    setTimeout(function() {
        window.scrollTo(0, 0); // run it a bit later for browser compatibility
    }, 1);
}

(function($) {
	"use strict";
	
	cqThemeQuiz = {
		onReady : function(){

			if($('.cq-wrapper').length > 0) {

				var clickHandler = (('ontouchstart' in window) || (window.DocumentTouch && document instanceof DocumentTouch)) ? 'touchstart' : 'click';

				var cqWelcome = $('.cq-welcome');
				var cqItem = $('.cq-item');
				var cqOptionItem = $('.cq-option-item');
				var cqResult = $('.cq-result');
				var cqNext = $('.cq-next');
				var cqNextButton = cqNext.find("button");
				var cqSubmit = $('.cq-submit');
				var cqLength = cqItem.length;
				var cqCount = 0;
				var welcomeScreenActive = true;
				var lastQuestionActive = false;
				var endScreenActive = false;

				var cqIsBinary = $('.cq-wrapper')[0].getAttribute('type') === 'binary';
				$('.cq-count-total').html(cqItem.length);

				setTimeout(function() {
					if (location.hash) {
					  /* we need to scroll to the top of the window first, because the browser will always jump to the anchor first before JavaScript is ready, thanks Stack Overflow: http://stackoverflow.com/a/3659116 */
					  //window.scrollTo(0, 0);
					  var target = location.hash.split('#');
					  smoothScrollTo($('#'+target[1]));
					}
				}, 1);

				// hastag smooth scrollto handler
				$('.cq-wrapper a[href*="#"]:not([href="#"])').click( function() {
					if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
						var target = $(this.hash);
						target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
						if (target.length) {
							$('html,body').animate({
								scrollTop: target.offset().top - 80
							}, 500);
							return false;
						}
					}
				});

				$('.cq-share-item a').on("click",function(e) {
					e.preventDefault();

					var activeImage = $('.cq-result-image.active').eq(0);
					var activeResult = $('.cq-result-item.active');
					var shareApiUrl;

					// Share href
					var shareHref = $(this).attr("href");

					// Result rel id
					var resultId = activeResult.attr("rel");

					// Result persona caption
					var resultTitle = activeResult.parent().find("h2 .cq-result-heading-item[rel="+resultId+"]").text();

					// Result description
					var resultDescription = activeResult.text();

					if($(this).hasClass("cq-share-fb")) {
						// Share href
						var shareAppId = getQueryString('app_id',shareHref);
						var shareLink = getQueryString('link',shareHref);
						var shareRedirectUri = getQueryString('redirect_uri',shareHref);

						// Result share img
						var resultShareImg = activeImage.attr("data-shareimg");

						// Check and set possible data attribute
						var resultDataShare = activeResult.attr("data-sharefb");

						if(resultDataShare != "") {
							resultDescription = resultDataShare;
						}
						
						shareApiUrl = "https://www.facebook.com/dialog/feed?app_id="+shareAppId+"&display=popup&amp;&caption="+resultTitle+"&description="+$.trim(resultDescription)+"&picture="+resultShareImg+"&link="+shareLink+"&redirect_uri="+shareRedirectUri+"";
						
						// Tracking
						cqThemeQuiz.saveGATrackingEvent(
							"Button - Facebook share",
							"Click"
						);
					}
					if($(this).hasClass("cq-share-twitter")) {
						var shareLink = getQueryString('url',shareHref);

						// Check and set possible data attribute
						var resultDataShare = activeResult.attr("data-sharetwitter");

						if(resultDataShare != "") {
							resultDescription = resultDataShare;
						}

						shareApiUrl = "http://twitter.com/intent/tweet?text="+$.trim(resultDescription)+"&amp;url="+shareLink+"";

						// Tracking
						cqThemeQuiz.saveGATrackingEvent(
							"Button - Twitter share",
							"Click"
						);
					}

					if($(this).hasClass("cq-share-linkedin")) {
						var shareLink = getQueryString('url',shareHref);
						var shareSource = getQueryString('source',shareHref);

						// Check and set possible data attribute
						var resultDataShare = activeResult.attr("data-sharelinkedin");

						if(resultDataShare != "") {
							resultDescription = resultDataShare;
						}

						shareApiUrl = "https://www.linkedin.com/shareArticle?mini=true&url="+shareLink+"&title=Keep it Safe"+"&summary="+$.trim(resultDescription)+"&source="+shareSource+"";

						// Tracking
						cqThemeQuiz.saveGATrackingEvent(
							"Button - LinkedIn share",
							"Click"
						);
					}

					$(this).attr("href",shareApiUrl);

					//window.open( $(this).attr("href"),null, "height=200,width=400,status=yes,toolbar=no,menubar=no,location=no");
					window.open( shareApiUrl,null, "height=300,width=400,status=yes,toolbar=no,menubar=no,location=no");
				});

				var getQueryString = function ( field, url ) {
				    var href = url ? url : window.location.href;
				    var reg = new RegExp( '[?&]' + field + '=([^&#]*)', 'i' );
				    var string = reg.exec(href);
				    return string ? string[1] : null;
				};

				var smoothScrollTo = function (target) {
				target = target.length ? target : $('[name=' + this.hash.slice(1) +']');

					if (target.length) {
					  $('html,body').animate({
					    scrollTop: (target.offset().top - 100)
					  }, 500);
					}
				}

				/* */
				/* Q1 - 1 */
				/* */
				var slLaptop = $('.cq-laptop-main, .cq-laptop-bg');

				var tlQ1_1 = new TimelineMax({paused: true});
				var slQ1_1 = $('.cq-tablet-q1_1');

				tlQ1_1.from(slQ1_1, 0.8,
					{
						autoAlpha: 0,
						top: "-10",
						rotation: -10,
						ease: Elastic.easeOut.config(1, 0.8)
			   		}
				);

				/* */
				/* Q1 - 2 */
				/* */
				var tlQ1_2 = new TimelineMax({paused: true});
				var slQ1_2 = $('.cq-tablet-cake-container');
				var slQ1_flame = $('.cq-tablet-candlefire');

				tlQ1_2.from(slQ1_2, 0.6,
					{
						autoAlpha: 0,
						ease: Linear.easeNone
			   		}
				);
				tlQ1_2.fromTo(slQ1_flame, 3,
					{
						scale: 0,
						rotation: 20,
						autoAlpha: 0
					},
					{
						autoAlpha: 1,
						rotation: -10,
						scale: 0.8,
						ease: Power2.easeOut,
			   		}
				);
				tlQ1_2.fromTo(slQ1_flame, 1.4,
					{
						scale: 0.8,
					},
					{
						scale: 1,
						rotation: 0,
						ease: Power2.easeInOut,
						repeat: 5,
						yoyo: true
			   		}
				);

				/* */
				/* Q1 - 3 */
				/* */
				var tlQ1_3 = new TimelineMax({paused: true});
				var slNumber1 = $('.cq-tablet-number1');
				var slNumber2 = $('.cq-tablet-number2');
				var slNumber3 = $('.cq-tablet-number3');

				tlQ1_3.from(slNumber1, 0.4,
					{
						autoAlpha: 0,
						clip:"rect(0px, 0px, 100px, 0px)",
						ease: Power2.easeOut
			   		}
				);
				tlQ1_3.from(slNumber2, 0.4,
					{
						autoAlpha: 0,
						clip:"rect(0px, 130px, 100px, 130px)",
						ease: Power2.easeOut
			   		}
				);
				tlQ1_3.from(slNumber3, 0.4,
					{
						autoAlpha: 0,
						clip:"rect(0px, 0px, 100px, 0px)",
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q1 - 4 */
				/* */
				var tlQ1_4 = new TimelineMax({paused: true});
				var slArmRight = $('.cq-tablet-armright');
				var slArmLeft = $('.cq-tablet-armleft');
				var slArmContainer = $('.cq-tablet-face-container');

				tlQ1_4.from(slArmContainer, 0.6,
					{
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ1_4.from(slArmLeft, 0.8,
					{
						autoAlpha: 0,	
						top: "+=10",
						ease: Power2.easeInOut
			   		}
			   	,"-=0.6");

				tlQ1_4.from(slArmRight, 0.8,
					{
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeInOut
			   		}
			   	,"-=0.4");

				/* */
				/* Q2 - 1 */
				/* */
				var tlQ2_1 = new TimelineMax({paused: true});
				var slCalender1 = $('.cq-laptop-calender1');
				var slCalender2 = $('.cq-laptop-calender2');

				tlQ2_1.from(slCalender1, 0.6,
					{
						autoAlpha: 0,
						scale: 1.4,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
				);
				tlQ2_1.from(slCalender2, 0.6,
					{
						autoAlpha: 0,
						scale: 1.4,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.2");

				/* */
				/* Q2 - 2 */
				/* */
				var tlQ2_2 = new TimelineMax({paused: true});
				var slMaContainer = $('.cq-laptop-man-container');
				var slManArm = $('.cq-laptop-manarm');
				var slManQuestionmark1 = $('.cq-laptop-questionmark1');
				var slManQuestionmark2 = $('.cq-laptop-questionmark2');
				var slManQuestionmark3 = $('.cq-laptop-questionmark3');

				tlQ2_2.from(slMaContainer, 0.4,
					{	
						autoAlpha: 0
			   		}
				);
				tlQ2_2.from(slManArm, 0.6,
					{	
						top: "+=20",
						rotation: -10,
						ease: Power2.easeOut
			   		}
				,"-=0.2");
				tlQ2_2.from(slManQuestionmark1, 0.6,
					{
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.2");
				tlQ2_2.from(slManQuestionmark2, 0.6,
					{
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.4");
				tlQ2_2.from(slManQuestionmark3, 0.6,
					{
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.4");

				/* */
				/* Q2 - 3 */
				/* */
				var tlQ2_3 = new TimelineMax({paused: true});
				var slSpiderGloss = $('.cq-laptop-spiderweb_gloss');
				var slSpiderWeb = $('.cq-laptop-spiderweb');

				tlQ2_3.from(slSpiderGloss, 0.4,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ2_3.from(slSpiderWeb, 1,
					{	
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.4)
			   		}
				);

				/* */
				/* Q2 - 4 */
				/* */
				var tlQ2_4 = new TimelineMax({paused: true});
				var sl1234567 = $('.cq-laptop-1234567');
				var sl1234567Circle = $('.cq-laptop-1234567_circle');

				tlQ2_4.from(sl1234567, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ2_4.from(sl1234567Circle, 0.4,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q3 - 1 */
				/* */
				var tlQ3_1 = new TimelineMax({paused: true});
				var slCouple = $('.cq-tablet-couple');
				var slCoupleQuestionmark = $('.cq-tablet-couple-questionmark');

				tlQ3_1.from(slCouple, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
				);
				tlQ3_1.from(slCoupleQuestionmark, 1,
					{	
						autoAlpha: 0,
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.8)
			   		}
				);

				/* */
				/* Q3 - 2 */
				/* */
				var tlQ3_2 = new TimelineMax({paused: true});
				var slPosponeExc = $('.cq-tablet-pospone_exc');
				var slPosponeCircular = $('.cq-tablet-pospone-circular');
				var slPosponeSun = $('.cq-tablet-pospone-sun');
				var slPosponeMoon = $('.cq-tablet-pospone-moon');

				tlQ3_2.from(slPosponeCircular, 1,
					{	
						autoAlpha: 0,
						rotation: 180,
						ease: Power2.easeOut
			   		}
				);
				tlQ3_2.from(slPosponeExc, 1,
					{	
						autoAlpha: 0,
						scale: 1.6,
						ease: Bounce.easeOut
			   		}
			   	,"-=0.8");
				tlQ3_2.from(slPosponeSun, 0.5,
					{	
						autoAlpha: 0,
						left: "+=5%",
						ease: Power2.easeOut
			   		}
			   	,"-=0.8");
				tlQ3_2.from(slPosponeMoon, 0.5,
					{	
						autoAlpha: 0,
						left: "-=5%",
						ease: Power2.easeOut
			   		}
			   	,"-=0.8");

				/* */
				/* Q3 - 3 */
				/* */
				var tlQ3_3 = new TimelineMax({paused: true});
				var slSaintHead = $('.cq-tablet-saint-head');
				var slSaintGlory = $('.cq-tablet-saint-glory');
				var slSaintLines = $('.cq-tablet-saint-lines');

				tlQ3_3.from(slSaintHead, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ3_3.from(slSaintGlory, 1,
					{	
						autoAlpha: 0,
						top: "+=8",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");
				tlQ3_3.from(slSaintLines, 0.8,
					{	
						autoAlpha: 0,
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.6");

				/* */
				/* Q3 - 4 */
				/* */
				var tlQ3_4 = new TimelineMax({paused: true});
				var slHideContainer = $('.cq-tablet-hide-container');
				var slHideArm = $('.cq-tablet-hide-arm');
				var slHideHand = $('.cq-tablet-hide-hand');

				tlQ3_4.from(slHideContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ3_4.from(slHideArm, 0.6,
					{	
						rotation: 20,
						left: "-=5",
						ease: Power2.easeOut
			   		}
			   	,"-=0.6");
				tlQ3_4.from(slHideHand, 0.6,
					{	
						rotation: 20,
						left: "-=5",
						ease: Power2.easeOut
			   		}
			   	,"-=0.6");

				/* */
				/* Q4 - 1 */
				/* */
				var tlQ4_1 = new TimelineMax({paused: true});
				var slNewsContainer = $('.cq-laptop-news-container');
				var slNewsLines1 = $('.cq-laptop-news-lines1');
				var slNewsLines2 = $('.cq-laptop-news-lines2');

				tlQ4_1.from(slNewsContainer, 0.6,
					{	
						top: 10,
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ4_1.from(slNewsLines1, 0.8,
					{	
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.4");
				tlQ4_1.from(slNewsLines2, 0.8,
					{	
						autoAlpha: 0,
						scale: 0.8,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.6");

				/* */
				/* Q4 - 2 */
				/* */
				var tlQ4_2 = new TimelineMax({paused: true});
				var slCoupleTrust = $('.cq-laptop-couple-trust');

				tlQ4_2.from(slCoupleTrust, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q4 - 3 */
				/* */
				var tlQ4_3 = new TimelineMax({paused: true});
				var slWomanTrust = $('.cq-laptop-woman-trust');

				tlQ4_3.from(slWomanTrust, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q4 - 4 */
				/* */
				var tlQ4_4 = new TimelineMax({paused: true});
				var slBinocular = $('.cq-laptop-binocular');

				tlQ4_4.from(slBinocular, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q5 - 1 */
				/* */
				var tlQ5_1 = new TimelineMax({paused: true});
				var slLowhighContainer = $('.cq-tablet-lowhigh-container');
				var slLowhighQmark = $('.cq-tablet-lowhigh-qmark');

				tlQ5_1.from(slLowhighContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ5_1.from(slLowhighQmark, 0.6,
					{	
						scale: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	,"-=0.4");

				/* */
				/* Q5 - 2 */
				/* */
				var tlQ5_2 = new TimelineMax({paused: true});
				var slLowhighContainer2 = $('.cq-tablet-lowhigh2-container');
				var slLowhighPointer2 = $('.cq-tablet-lowhigh2-pointer');

				tlQ5_2.from(slLowhighContainer2, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ5_2.fromTo(slLowhighPointer2, 3,
					{
						rotation: 20,
					},
					{	
						rotation: -100,
						ease: Elastic.easeOut.config(1, 0.5)
			   		}
			   	,"-=0.2");

				/* */
				/* Q5 - 3 */
				/* */
				var tlQ5_3 = new TimelineMax({paused: true});
				var slLowhighContainer3 = $('.cq-tablet-lowhigh3-container');
				var slLowhighPointer = $('.cq-tablet-lowhigh3-pointer');

				tlQ5_3.from(slLowhighContainer3, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ5_3.from(slLowhighPointer, 4,
					{	
						rotation: -100,
						ease: Elastic.easeOut.config(1, 0.3)
			   		}
			   	,"-=0.2");

				/* */
				/* Q5 - 4 */
				/* */
				var tlQ5_4 = new TimelineMax({paused: true});
				var slLowhighContainer4 = $('.cq-tablet-lowhigh4-container');
				var slLowhighPointer2 = $('.cq-tablet-lowhigh4-pointer');

				tlQ5_4.from(slLowhighContainer4, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ5_4.fromTo(slLowhighPointer2, 1,
					{
						rotation: -40
					},
					{	
						rotation: 60,
						ease: Power2.easeInOut
			   		}
			   	,"-=0.2");
				tlQ5_4.to(slLowhighPointer2, 2,
					{	
						rotation: 0,
						ease: Elastic.easeOut.config(1, 0.6)
			   		}
			   	);

				/* */
				/* Q6 - 1 */
				/* */
				var tlQ6_1 = new TimelineMax({paused: true});
				var slLockContainer = $('.cq-laptop-lock-container');
				var slLock = $('.cq-laptop-lock');

				tlQ6_1.from(slLockContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ6_1.from(slLock, 0.6,
					{	
						top: "-=10",
						scale: 0.8,
						ease: Bounce.easeOut
			   		}
			   	,"-=0.4");

				/* */
				/* Q6 - 2 */
				/* */
				var tlQ6_2 = new TimelineMax({paused: true});
				var slLock2Container = $('.cq-laptop-lock2-container');
				var slLock2 = $('.cq-laptop-lock2');
				var slLock2Holes = $('.cq-laptop-lock2-holes');

				tlQ6_2.from(slLock2Container, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ6_2.from(slLock2, 0.6,
					{	
						top: "-=10",
						scale: 0.8,
						ease: Bounce.easeOut,
						onComplete: function () {
							setTimeout(function(){ 
								slLock2Holes.css("visibility","visible");
								slLock2.css("visibility","hidden");
							}, 200);
						}
			   		}
			   	,"-=0.4");

				/* */
				/* Q6 - 3 */
				/* */
				var tlQ6_3 = new TimelineMax({paused: true});
				var slDoor = $('.cq-laptop-door');

				tlQ6_3.from(slDoor, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q6 - 4 */
				/* */
				var tlQ6_4 = new TimelineMax({paused: true});
				var slConfusedContainer = $('.cq-laptop-confused-container');
				var slConfusedQmark1 = $('.cq-laptop-confused-qmark1');
				var slConfusedQmark2 = $('.cq-laptop-confused-qmark2');
				var slConfusedQmark3 = $('.cq-laptop-confused-qmark3');

				tlQ6_4.from(slConfusedContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ6_4.from(slConfusedQmark1, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");
				tlQ6_4.from(slConfusedQmark2, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");
				tlQ6_4.from(slConfusedQmark3, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");

				/* */
				/* Q7 - 1 */
				/* */
				var tlQ7_1 = new TimelineMax({paused: true});
				var slWifiContainer = $('.cq-tablet-wifi-container');
				var slWifiLock = $('.cq-tablet-wifi-lock');
				var slWifiSignal = $('.cq-tablet-wifi-signal');

				tlQ7_1.from(slWifiContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ7_1.from(slWifiLock, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");
				tlQ7_1.from(slWifiSignal, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						scale: 0,
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");

				/* */
				/* Q7 - 2 */
				/* */
				var tlQ7_2 = new TimelineMax({paused: true});
				var slLocksX3 = $('.cq-tablet-locksx3');

				tlQ7_2.from(slLocksX3, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q7 - 3 */
				/* */
				var tlQ7_3 = new TimelineMax({paused: true});
				var slLinkContainer = $('.cq-tablet-link-container');
				var slLinkHand = $('.cq-tablet-link-hand');

				tlQ7_3.from(slLinkContainer, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
				);
				tlQ7_3.from(slLinkHand, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");

				/* */
				/* Q7 - 4 */
				/* */
				var tlQ7_4 = new TimelineMax({paused: true});
				var slPinContainer = $('.cq-tablet-pin-container');
				var slPinOn = $('.cq-tablet-pin-on');
				var slPinOff = $('.cq-tablet-pin-off');

				tlQ7_4.from(slPinContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ7_4.from([slPinOn, slPinOff], 1,
					{	
						left: "+=15%",
						ease: Power2.easeInOut
			   		}
			   	,"-=0.4");
				tlQ7_4.from(slPinOff, 1,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
			   	,"-=0.6");

				/* */
				/* Q8 - 1 */
				/* */
				var tlQ8_1 = new TimelineMax({paused: true});
				var slAncContainer = $('.cq-laptop-q8_1');

				tlQ8_1.from(slAncContainer, 0.6,
					{	
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);
				tlQ8_1.to(slLaptop, 1,
					{	
						rotation: -10,
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");
				tlQ8_1.from(slAncContainer, 0.8,
					{	
						top: "+=20%",
						//left: "-=15%",
						rotation: -20,
						ease: Power2.easeInOut
			   		}
			   	,"-=1.2");

				/* */
				/* Q8 - 2 */
				/* */
				var tlQ8_2 = new TimelineMax({paused: true});
				var slLadyContainer = $('.cq-tablet-lady-container');
				var slLadyHearts1 = $('.cq-tablet-lady-hearts1');
				var slLadyHearts2 = $('.cq-tablet-lady-hearts2');

				tlQ8_2.from(slLadyContainer, 0.6,
					{	
						delay: 0.1,
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
				);
				tlQ8_2.from(slLadyHearts1, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.2");
				tlQ8_2.from(slLadyHearts2, 0.6,
					{	
						autoAlpha: 0,
						top: "+=10",
						ease: Power2.easeOut
			   		}
			   	,"-=0.4");

				/* */
				/* Q8 - 3 */
				/* */
				var tlQ8_3 = new TimelineMax({paused: true});
				var slSearch = $('.cq-tablet-search');

				tlQ8_3.from(slSearch, 0.4,
					{	
						delay: 0.1,
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				/* */
				/* Q8 - 4 */
				/* */
				var tlQ8_4 = new TimelineMax({paused: true});
				var slEarBeefs = $('.cq-laptop-q8_4');

				tlQ8_4.from(slEarBeefs, 0.4,
					{	
						delay: 0.1,
						autoAlpha: 0,
						ease: Power2.easeOut
			   		}
				);

				setTimeout(function(){ 
					//tlQ1_1.play();
					//tlQ1_2.play();
					//tlQ1_3.play();
					//tlQ1_4.play();
					//tlQ2_1.play();
					//tlQ2_2.play();
					//tlQ2_3.play();
					//tlQ2_4.play();
					//tlQ3_1.play();
					//tlQ3_2.play();
					//tlQ3_3.play();
					//tlQ3_4.play();
					//tlQ4_1.play();
					//tlQ4_2.play();
					//tlQ5_2.play();
					//tlQ5_3.play();
					//tlQ5_4.play();
					//tlQ6_2.play();
					//tlQ6_3.play();
					//tlQ7_1.play();
					//tlQ7_2.play();
					//tlQ7_3.play();
					//tlQ7_4.play();
					//tlQ8_1.play();
					//tlQ8_3.play();
					//tlQ8_4.play();

				}, 600);

				var dbOnLastQuestion = function()
					{
						lastQuestionActive = true;
					}

				var dbOnEnd = function()
					{
						showStat();
						endScreenActive = true;
						TweenMax.to(cqNext, 0.3, {autoAlpha: 0, ease: Power2.easeOut});
					}

				var showStat = function()
					{
						if (cqIsBinary)
							{
								$('.cq-question-count').addClass('hidden');
								var correct = 0, total = 0;
								for (var i=0; i<cqItem.length; i++)
									{
										total ++;
										if ($(cqItem[i]).hasClass('correctly')) correct ++;
									}
								$('.cq-result-stat')[0].innerHTML =
									correct + ' correct out of ' + total;
								$('.cq-result-stat').removeClass('hidden');
							}

						// Tracking
						cqThemeQuiz.saveGATrackingEvent(
							"RESULT:",
							$('.cq-result-heading-item.active').text()
						);
					}

				var dbNavToNext = function()
					{
						cqSubmit.prop('disabled', true);

						if(lastQuestionActive) {
							TweenMax.to(cqNext, 0.4, {autoAlpha: 0, ease: Power2.easeOut});
							TweenMax.to($('.cq-step'), 0.4, {autoAlpha: 0, ease: Power2.easeOut});
						}

						cqCount++;
						if (cqCount < cqLength)
							{
								dbNav({ to: cqItem[cqCount] });
								if (cqCount == cqLength-1) dbOnLastQuestion();
							}
						else
							{
								dbNav({ to: cqResult });
								dbOnEnd();
							}
					}

				var activeSlide = cqItem[0];

				var dbNav = function(ini)
					{
						if(welcomeScreenActive) {
							TweenMax.to(cqWelcome, 0.8, {left: "-110%", ease: Back.easeIn.config(1), onComplete: function() {
								TweenMax.to(cqNext, 0.4, {autoAlpha: 1, ease: Power2.easeOut});
								TweenMax.fromTo($('.cq-step'), 0.4, {autoAlpha: 0},{autoAlpha: 1, ease: Power2.easeOut});
							}});

							welcomeScreenActive = false;
						} else {
							TweenMax.to(cqNext, 0.3, {autoAlpha: 0, ease: Power2.easeOut, onComplete: function() {
								cqNextButton.removeClass("active");
							}});
						}

						TweenMax.to(activeSlide, 0.8, {left: ini.back?
										'110%' : '-110%', ease: Back.easeIn.config(1)});

						activeSlide = ini.to;
						

						TweenMax.to(activeSlide, 0.8, {delay: 0.6, left: 0, ease: Back.easeOut.config(1), onComplete: function() {
							
							if(endScreenActive == false) {
								TweenMax.to(cqNext, 0.3, {autoAlpha: 1, ease: Power2.easeOut});
							}
						}});

					}

				var dbUpdateProgress = function()
					{
						$('.cq-count-current').html(Math.min(cqLength, cqCount + 1));

						var stepIndicator = $('.step-indicator');
						var stepIndicatorLink = stepIndicator.find(".step-indicator-link");
						var stepCount = cqCount;

						// client script generates an empty div - if detected we skip it
						if(stepIndicator.eq(stepCount).hasClass("steps-hidden")) {
							stepCount++;
						}

						// Remove active class
						stepIndicator.removeClass("active");
						stepIndicatorLink.removeClass("active");

						// Add active class for next step
						stepIndicator.eq(stepCount).addClass("active");
						stepIndicatorLink.eq(stepCount).addClass("active");
					}

				var dbClearAnswers = function()
					{
						for (var i=0; i < cqItem.length; i++)
							{
								var question = cqItem[i];
								var answers = $(question).find('.cq-option-item');
								for (var j=0; j<answers.length; j++)
									$(answers[j]).removeClass('selected');
								
								//var submit = $(".cq-submit");
								cqSubmit.prop('disabled', true);
							}
					}

				var dbResetAnimation = function()
					{
						for (var i=1; i < cqItem.length; i++)
							cqItem[i].style.left = '100%';
					}

				var dbRestart = function()
					{
						// Reset question animation
						tlQ1_1.seek(0).pause();
						tlQ1_2.seek(0).pause();
						tlQ1_3.seek(0).pause();
						tlQ1_4.seek(0).pause();
						tlQ2_1.seek(0).pause();
						tlQ2_2.seek(0).pause();
						tlQ2_3.seek(0).pause();
						tlQ2_4.seek(0).pause();
						tlQ3_1.seek(0).pause();
						tlQ3_2.seek(0).pause();
						tlQ3_3.seek(0).pause();
						tlQ3_4.seek(0).pause();
						tlQ4_1.seek(0).pause();
						tlQ4_2.seek(0).pause();
						tlQ4_3.seek(0).pause();
						tlQ4_4.seek(0).pause();
						tlQ5_1.seek(0).pause();
						tlQ5_2.seek(0).pause();
						tlQ5_3.seek(0).pause();
						tlQ5_4.seek(0).pause();
						tlQ6_1.seek(0).pause();
						tlQ6_2.seek(0).pause();
						tlQ6_3.seek(0).pause();
						tlQ6_4.seek(0).pause();
						tlQ7_1.seek(0).pause();
						tlQ7_2.seek(0).pause();
						tlQ7_3.seek(0).pause();
						tlQ7_4.seek(0).pause();
						tlQ8_1.seek(0).pause();
						tlQ8_2.seek(0).pause();
						tlQ8_3.seek(0).pause();
						tlQ8_4.seek(0).pause();

						// Reset Misc
						cqCount = 0;
						lastQuestionActive = false;
						endScreenActive = false;
						cqNextButton.removeClass("active");
						cqOptionItem.attr('checked', false);
						dbNav({ to: cqItem[0], back: true });
						TweenMax.to(cqNext, 1, {autoAlpha: 1, ease: Power2.easeOut});
						TweenMax.to($('.cq-step'), 1, {delay: 0.4, autoAlpha: 1, ease: Power2.easeOut});
						dbUpdateProgress();
						dbClearAnswers();
						dbResetAnimation();

						$(".button-group").removeClass('answered');

						if (cqIsBinary)
							for (var i=0; i < cqItem.length; i++)
								$(cqItem[i]).removeClass('answered').removeClass('correctly').removeClass('incorrectly');

						if (cqIsBinary)
							{
								$('.cq-question-count').removeClass('hidden');
								$('.cq-result-stat').addClass('hidden');
							}

						// Tracking
						cqThemeQuiz.saveGATrackingEvent(
							"Button - Restart",
							"Click"
						);

					}

				var dbCalculateResult = function()
					{

						var endResult;

						var results = $('.cq-result-item');

						if (cqIsBinary)
							{

	//console.log('binary quiz');

								var points = 0;
								for (var i=0; i < cqItem.length; i++)
									{
										var question = cqItem[i];
										if ($(question).hasClass('correctly')) points ++;
									}
	//console.log('points:');
	//console.log(points);
								for (var j=0; j<results.length; j++)
									{
										var result = results[j];
										var pointsRequired = result.getAttribute('pointsRequired');
										var match = pointsRequired.match(/^\s*(\d+)\s*-\s*(\d+)\s*$/);
										if (match)
											{
												if (points >= match[1]
														&& points < match[2])
													{
														endResult = result;
														break;
													}
											}
										else
											{
												var pointsRequired = parseInt(pointsRequired);
												if (points == pointsRequired)
													{
														endResult = result;
														break;
													}
											}
									}
							}
						else
							{

								//console.log('complex quiz');

								var votes = {};
								for (var i=0; i < cqItem.length; i++)
									{

										var question = cqItem[i];
										var answerValues = [];
										if ($(question).hasClass('cq-type-multiple'))
											{
												var answers
													= question.getElementsByClassName('cq-option-item');

												if ($(question).hasClass('cq-type-multiple-complex'))
													{
														for (var j=0; j<answers.length; j++)
															if ($(answers[j]).hasClass('selected'))
															answerValues.push(parseInt(answers[j].getAttribute('rel')));
													}
												else
													{
														var counter = 0;
														for (var j=0; j<answers.length; j++)
															if ($(answers[j]).hasClass('selected')) counter ++;
														answerValues = [counter];
													}
											}
										else
											{
												var answer = $(question).find('.selected')[0];
												if (answer)
													answerValues = [parseInt(answer.getAttribute('rel'))];
											}
										var logic = question.getAttribute('logic');
										if (!answerValues.length) continue;
										if (logic)
											{

												var result = null, resultPointsToAdd;

				//console.log('logic:');
				//console.log(logic);

										// Only saves current loop
										if(i == cqCount) {

											if($(question).hasClass("cq-type-multiple-complex")) { // radio buttons

												var radioSelected1 = $(question).find(".input-set").eq(0).find(".cq-option-item.selected").val();
												var radioSelected2 = $(question).find(".input-set").eq(1).find(".cq-option-item.selected").val();
												var radioSelected3 = $(question).find(".input-set").eq(2).find(".cq-option-item.selected").val();
												var radioSelected4 = $(question).find(".input-set").eq(3).find(".cq-option-item.selected").val();

												// Tracking
												cqThemeQuiz.saveGATrackingEvent(
													"ANSWER STEP - "+(i+1)+": ",
													"G1: "+radioSelected1+" - G2: "+radioSelected2+ " - G3: "+radioSelected3+ " - G4: "+radioSelected4
												);
											} else { // normal buttons
												// Tracking
												cqThemeQuiz.saveGATrackingEvent(
													"ANSWER STEP - "+(i+1)+": ",
													$.trim($(question).find(".cq-option-item.selected").text())
												);
											}
										}

				//console.log('answerValues:');
				//console.log(answerValues);

												logic = logic.split(/\s*;\s*/);

												for (var k=0; k<logic.length; k++)
													{
														var rule = logic[k];
														var values = [];
														rule = rule.split(/\s*:\s*/);
														var intervals = rule[0];
														var intervalResult = rule[1];
														var pointsToAdd = parseInt(rule[2]);
														if (isNaN(pointsToAdd)) pointsToAdd = 1;
				// console.log('intervals');
				// console.log(intervals);
				// console.log('intervalResult');
				// console.log(intervalResult);
														intervals = intervals.replace(/^\[/, '').replace(/\]$/, '');
														intervals = intervals.split(/\s*,\s*/);
														for (var l=0; l<intervals.length; l++)
															{
					var interval = intervals[l];
					interval = interval.replace(/\s*/, '');
					if (interval.match(/^\d+$/))
						values.push(parseInt(interval));
					else
						{
							var match = interval.match(/^(\d+)\.\.(\d+)?$/);
							if (match)
								{
									var start = parseInt(match[1]);
									var end = match[2] ?
												parseInt(match[2]) :
													Math.max.apply(null, answerValues);
									for (var n=start; n<=end; n++)
										values.push(n);
								}
							else throw(interval + " is not a number neither an interval");
						}
															}
				//console.log('values');
				//console.log(values);
														for (var l=0; l<values.length; l++)
															for (var m=0;
																	m<answerValues.length;
																		m++)
																if (answerValues[m]
																		=== values[l])
																{
																	result = intervalResult;
																	resultPointsToAdd =
																		pointsToAdd;
																		
				//console.log('result '+result+' +'+pointsToAdd+' pts');
																	if (!votes[result])
																		votes[result] = 0;
																	votes[result]
																		+= resultPointsToAdd;

																}

													}

											}

									}
								//console.log('votes:');
								//console.log(votes);

								// Tracking
								cqThemeQuiz.saveGATrackingEvent(
									"ANSWER STEP - "+(cqCount+1)+" - Votes:",
									"R1: "+votes[1] + " R2: "+votes[2] + " R3: "+votes[3] + " R4: "+votes[4] + " R5: "+votes[5]
								);


								var max = 0, endResultNumber;
								
								var weight = {}, precedence
										= cqResult[0].getAttribute('precedence');

								if (precedence)
									{
										precedence = precedence.split(/\s*,\s*/);
										var n = precedence.length;
										for (var i=0; i<n; i++)
											weight[parseInt(precedence[i])] = n - i;
									}

								for (var i in votes)
									if ((votes[i] > max)
										|| (votes[i] == max
												&& weight && weight[i]>weight[endResultNumber]))
										{
											endResultNumber = i;
											max = votes[i];
										}

								for (var j=0; j<results.length; j++)
									{
										var result = results[j];
										var resultNumber = parseInt(result.getAttribute('rel'));
										if (resultNumber == endResultNumber)
											{
												endResult = result;
												break;
											}
									}
							}

						//console.log('endResult:');
						//console.log(endResult);

						// setting active result style
						for (var j=0; j<results.length; j++)
							{
								var result = results[j];
								var activeRel = $(result).attr("rel");
								var imageItem = $(".cq-result-image[rel='"+activeRel+"']");
								var headingItem = $(".cq-result-heading-item[rel='"+activeRel+"']");
								var relevantItem = $(".cq-relevant[rel='"+activeRel+"']");
								if (result == endResult) {
									imageItem.addClass('active');
									headingItem.addClass('active');
									relevantItem.addClass('active');
									$(result).addClass('active');
								} else {
									$(result).removeClass('active');
									imageItem.removeClass('active');
									headingItem.removeClass('active');
									relevantItem.removeClass('active');
								}
							}
					}

				var answerClicked = function(e)
					{
						var gotRadio = false;
						var question = $(this).parent().parent();
						var questionContainerMain = question.parent().parent();
						var answers = question.find('.cq-option-item');

						var thisRel = $(this).attr("rel");
						var cqItemMain = $(this).closest(".cq-item.cq-type-multiple-complex");
						var cqItemIndex = $(this).closest(".cq-item").index();
						

						if (cqIsBinary && question.hasClass('answered')) return;

						//var submit = $(".cq-submit")[0];

						if (question.hasClass('cq-type-multiple'))
							{
								$(this).toggleClass('selected');
								for (var j=0; j<answers.length; j++)
									if ($(answers[j]).hasClass('selected'))
										{
											//submit.removeAttribute('disabled');
											cqSubmit.prop('disabled', false);
											break;
										}
							}
						else if (cqItemMain.length > 0)
							{
								gotRadio = true;
								var buttonGroupLength = cqItemMain.find(".button-group .cq-yesno");
								
								for (var j=0; j<answers.length; j++)
									if ($(answers[j]).hasClass('selected')) $(answers[j]).removeClass('selected');
								$(this).addClass('selected');

								// All YES NO are chosen
								if(buttonGroupLength.length == buttonGroupLength.find(".cq-option-item.selected").length) {
									question.addClass('answered');
									cqSubmit.prop('disabled', false);
									cqNextButton.addClass("active");
								}
								
							}
						else
							{
								question.addClass('answered');
								for (var j=0; j<answers.length; j++)
									if ($(answers[j]).hasClass('selected')) $(answers[j]).removeClass('selected');
								$(this).addClass('selected');
								//submit.removeAttribute('disabled');
								cqSubmit.prop('disabled', false);
								cqNextButton.addClass("active");
							}

						if (cqIsBinary)
							{
								question.addClass('answered');
								question.addClass(this.hasAttribute('correct') ? 
									'correctly' : 'incorrectly');
							}

						var tabletORLaptop;
						var cqItemIndexRewrite = cqItemIndex - 1;

						if(isOdd(cqItemIndexRewrite)) {
							tabletORLaptop = "tablet";
						} else {
							tabletORLaptop = "laptop";
						}

						var thisRelRewrite;

						if(cqItemMain.length > 0) {
							if(thisRel == 1 || thisRel == 2) {
								thisRelRewrite = 1;
							}
							if(thisRel == 3 || thisRel == 4) {
								thisRelRewrite = 2;
							}
							if(thisRel == 5 || thisRel == 6) {
								thisRelRewrite = 3;
							}
							if(thisRel == 7 || thisRel == 8) {
								thisRelRewrite = 4;
							}
						} else {
							thisRelRewrite = thisRel;
						}

						if(gotRadio) {
							var cqItemIllu = cqItemMain.find(".cq-"+tabletORLaptop+" .cq-illu-item");
							var cqItemIlluRel = cqItemMain.find(".cq-"+tabletORLaptop+" .cq-illu-item[rel='"+thisRelRewrite+"']");
						} else {
							var cqItemIllu = questionContainerMain.find(".cq-"+tabletORLaptop+" .cq-illu-item");
							var cqItemIlluRel = questionContainerMain.find(".cq-"+tabletORLaptop+" .cq-illu-item[rel='"+thisRelRewrite+"']");
						}

						cqItemIllu.removeClass("active");
						cqItemIlluRel.addClass("active");

						toggleButtonAnimation(cqItemIndexRewrite, thisRelRewrite);

/*
						// Check for YES NO setup
						if (questionContainerMain.hasClass('cq-type-multiple-complex')) {
							var buttonGroupLength = questionContainerMain.find(".button-group .cq-yesno");

							// All YES NO are chosen
							if(buttonGroupLength.length == buttonGroupLength.find(".cq-option-item.selected").length) {
								cqSubmit.prop('disabled', true);
								cqNextButton.addClass("active");
							}
						} else {
							cqSubmit.prop('disabled', false);
							cqNextButton.addClass("active");
						}
*/
					}

				var toggleButtonAnimation = function(index, buttonAnim) {
					if(index == 1) {
						if(buttonAnim == 1) {
							tlQ1_1.play();
						} else if(buttonAnim == 2) {
							tlQ1_2.play();
						} else if(buttonAnim == 3) {
							tlQ1_3.play();
						} else if(buttonAnim == 4) {
							tlQ1_4.play();
						}
					}

					if(index == 2) {
						if(buttonAnim == 1) {
							tlQ2_1.play();
						} else if(buttonAnim == 2) {
							tlQ2_2.play();
						} else if(buttonAnim == 3) {
							tlQ2_3.play();
						} else if(buttonAnim == 4) {
							tlQ2_4.play();
						}
					}

					if(index == 3) {
						if(buttonAnim == 1) {
							tlQ3_1.play();
						} else if(buttonAnim == 2) {
							tlQ3_2.play();
						} else if(buttonAnim == 3) {
							tlQ3_3.play();
						} else if(buttonAnim == 4) {
							tlQ3_4.play();
						}
					}

					if(index == 4) {
						if(buttonAnim == 1) {
							tlQ4_1.play();
						} else if(buttonAnim == 2) {
							tlQ4_2.play();
						} else if(buttonAnim == 3) {
							tlQ4_3.play();
						} else if(buttonAnim == 4) {
							tlQ4_4.play();
						}
					}

					if(index == 5) {
						if(buttonAnim == 1) {
							tlQ5_1.play();
						} else if(buttonAnim == 2) {
							tlQ5_2.play();
						} else if(buttonAnim == 3) {
							tlQ5_3.play();
						} else if(buttonAnim == 4) {
							tlQ5_4.play();
						}
					}

					if(index == 6) {
						if(buttonAnim == 1) {
							tlQ6_1.play();
						} else if(buttonAnim == 2) {
							tlQ6_2.play();
						} else if(buttonAnim == 3) {
							tlQ6_3.play();
						} else if(buttonAnim == 4) {
							tlQ6_4.play();
						}
					}


					if(index == 7) {
						if(buttonAnim == 1) {
							tlQ7_1.play();
						} else if(buttonAnim == 2) {
							tlQ7_2.play();
						} else if(buttonAnim == 3) {
							tlQ7_3.play();
						} else if(buttonAnim == 4) {
							tlQ7_4.play();
						}
					}

					if(index == 8) {
						if(buttonAnim == 1) {
							tlQ8_1.play();
						} else if(buttonAnim == 2) {
							tlQ8_2.play();
						} else if(buttonAnim == 3) {
							tlQ8_3.play();
						} else if(buttonAnim == 4) {
							tlQ8_4.play();
						}

						// Resets laptop rotation
						if(buttonAnim !=1) {
							TweenMax.to(slLaptop, 0.1,
								{	
									rotation: 0,
									ease: Power2.easeOut
						   		}
						   	);
						}
					}

				}

				var isOdd = function(num) {
					 if(num % 2){

					  //return "odd";
					  return true;

					 }else{

					  //return "even";
					  return false;

					 }
				}

				cqOptionItem.on( 'click', answerClicked);

				$('.cq-welcome-btn').on( 'click', function() {
						dbNav({ to: cqItem[0], back: true });
						TweenMax.to(cqNext, 1, {autoAlpha: 1, ease: Power2.easeOut});

						// Tracking
						cqThemeQuiz.saveGATrackingEvent(
							"Button - Welcome",
							"Click"
						);
				});

				$('.cq-result-reset').on('click', dbRestart);

				cqSubmit.on( 'click', function() {
					dbCalculateResult();
					dbNavToNext();
					dbUpdateProgress();
				});

				$('.step-indicator-link').on( 'click', function(e) {
					e.preventDefault();
				});

			}

	        cqThemeQuiz.onResize();

		},
		saveGATrackingEvent: function(valEventAction, valEventLabel) {

			//console.log("CQ: "+valEventAction+" "+valEventLabel);

			//DB tracking function
			DB.track("CQ: "+valEventAction+" "+valEventLabel);
		},
		onResize : function() {

		},
		onLoad: function() {}
	};

	$(document).ready( cqThemeQuiz.onReady );
	$(window).load( cqThemeQuiz.onLoad );
	$(window).resize( cqThemeQuiz.onResize );

})(jQuery);