//New Form script v. 1

(function ($) {

	var gem = {
		settings : {
			sendTo : 'syst-mcp2@danskebank.dk',
			defaultFrom : 'Home Pages',
			defaultSubject : 'Contact Form',
			geminiSubmitID : 'sendbutton',
			formContainerId: 'contactFormGen',
			receiptId:'contactFormGen-receipt',
			formId:'',
			lanCode: 'DK',
			numCount: 0,
			counterStart: 1000,
			numField: false,
			fields :[],
			fieldValPairDelim : ': ',
			multivalueDelim : '; ',
			tablevalueDelim : ', ',
			kvitURL : '',
		},
		changeTriggers:['number','alpha','alpha-number','email','dropdown','date-my','date','max-number','min-number','cpr-number','cvr-number','post-number','max-char','min-char','allow-symbols'],
		defaultClasses:['default','required'],
		errorObj: [],
		isBlurEvent: false,
		isPostValid: false,
		isDateValid: true,
		ismonthValid: true,
		splitClassStatus:false,
		eachStop: false,
		//countFld: $('textarea.textComment'),
		
		init : function() {
			var formId = $('#'+gem.settings.formContainerId).find('input#__formID').val()
			if(formId != ''){
				gem.settings.formContainerId =  gem.settings.formContainerId + formId;
				$('.contactForm').attr('id',gem.settings.formContainerId);
			}
			else{
				gem.settings.formContainerId = gem.settings.formContainerId + '0';
				$('.contactForm').attr('id',gem.settings.formContainerId);
			}
			
			$('#' + gem.settings.formContainerId).on('blur', 'input', function(){
				gem.validate('blur', $(this));
	
			});
			$('#' + gem.settings.formContainerId).on('blur', 'textarea', function(){
				gem.validate('blur', $(this));
			});
			
			$('#' + gem.settings.formContainerId).on('blur', '.responsive-dropdown', function(){
				gem.validate('blur', $(this));
	
			});
			
			$('#' + gem.settings.formContainerId).on('click', 'input[type="radio"]', function(){
				$(this).parent().find('.default').removeClass('default')
				if ($(this).prop('checked')==true){ 
					$(this).addClass('default')
				}
			});
			
			$('#' + gem.settings.formContainerId).on('click', 'input[type="checkbox"]', function(){
				$(this).parent().find('.default').removeClass('default')
				if ($(this).prop('checked')==true){ 
					$(this).addClass('default')
				}
			});
			
			$('.upload-sendform').on('click', function(e){
				var formcontainer = document.getElementById(gem.settings.formContainerId);
				if(gem.validate('click',formcontainer) === true){
					if(gem.uSubmitForm() === true){
					   gem.checkSubmit()
					}
				}
			});
			
			$('.sendform').on('click', function(e){
				if(gem.validate() === true){
					if(gem.nSubmitForm() === true){
					   
					}
				}
			});
			
			$('.counter').on('focus keydown mousedown', function(e){
				gem.counter(gem.settings.counterStart, $(this))
			});
			
			
			gem.setTo(gem.settings.sendTo);
			gem.setFrom(gem.settings.defaultFrom);
			gem.setSubject(gem.settings.defaultSubject);
			gem.timestampFields();
			
			var lanCodeVal = $('#'+gem.settings.formContainerId).find('input#__lanCode').val()
			gem.settings.lanCode = lanCodeVal;
			gem.getLanguageCode(gem.settings.lanCode)
		},
		
		counter: function(countVal, fld){
			actualvalue = fld.val();
			actual = countVal - actualvalue.length;
			//actdisplay = "(" + actual + " tegn tilbage)";
			actdisplay = "( "+ actual + " )";
			if(actual < 0  || actual > countVal){actdisplay = "" + actual + ""}
			$("#count").html(actdisplay);
		},

		sortDataFields: function(formcontainer) {
			var count = 1;
			var order;
			var fld;
			var dataFlds = $('input.default:visible,input.radioCollection:checked,input.checkboxCollection:checked,.responsive-dropdown:visible,textarea:visible',formcontainer);
			for (var i=0;i<dataFlds.length;i++) {
				fld = dataFlds[i];
					if ( $(fld).attr('data-cblabelorder') != undefined ) {
						order = parseInt( $(fld).attr('data-cblabelorder') );
						for (j=order;j<100;j++) {
							if (gem.settings.fields[j] == undefined) {
								gem.settings.fields[j] = fld;
								break;
							}
						}
					} else {
						for (j=count;j<(dataFlds.length+1);j++) {
							if (gem.settings.fields[j] == undefined) {
								gem.settings.fields[j] = fld;
								break;
							}
						}
						count = j;
					}
			}
		},

		getLanguageCode: function(lan) {
			if(lan == 'SE')
				return 'SE';
			else if(lan == 'DK')
				return 'DK';
			else if(lan == 'NO')
				return 'NO';
			else if(lan == 'FI')
				return 'FI';
			else if(lan == 'UK')
				return 'UK';
			else if(lan == 'EN')
					return 'UK';
			else
				return 'DK';
		},

		getErrorMessage: function(fieldName) {
			switch(gem.getLanguageCode(gem.settings.lanCode)){
				case 'SE':
					return error[fieldName].se.replace('***',gem.settings.numCount);
				case 'DK':
					return error[fieldName].dk.replace('***',gem.settings.numCount);
				case 'FI':
					return error[fieldName].fi.replace('***',gem.settings.numCount);
				case 'NO':
					return error[fieldName].no.replace('***',gem.settings.numCount);
				case 'UK':
					return error[fieldName].uk.replace('***',gem.settings.numCount);
				default:
					return error[fieldName].dk.replace('***',gem.settings.numCount);
			}
		},
		
		findClass: function (target){
			var relevant = false;
			var classes = target.split(' ');
			for (var i = 0; i < classes.length; i++) {
				var classFunction = classes[i];
				var count = (classFunction.match(/--/g) || []).length;
				if(count > 0){
					var restNum = classFunction.substring(0, classFunction.lastIndexOf("--"));
					var lastNum = classFunction.substring(classFunction.lastIndexOf("-") + 1, classFunction.length);
					classFunction = restNum
					gem.settings.numCount = lastNum;
					
				}
				if (classFunction != '' && gem.changeTriggers.indexOf(classFunction) > -1) {
					relevant = true;
					break;
				}
			}
			if(relevant === true){
				return classFunction;
			}
		},
		validateRequired: function(myEvent,fields) {
			if(myEvent == 'click'){
				var fld = $(fields).find('.default,.responsive-dropdown');
			}
			else{
				var fld = $(fields).parent().find('.default,.responsive-dropdown');
			}
			var rqdFldLen = fld.length
			var fldlist = [];
			for(j=0; j<rqdFldLen; j++){
				fldlist.push(fld[j])
				var fldClass = fldlist[j].className;
				switch(gem.findClass(fldClass)){
					case 'number':
					  var fldtype = "number";
					  gem.validateFields(myEvent,fld,fldtype);
					  break;
					case 'email':
					  var fldtype = "email";
					  gem.validateFields(myEvent,fld,fldtype);
					  break;
					case 'alpha':
					  var fldtype = "alpha";
					  gem.validateFields(myEvent,fld,fldtype);
					  break;
					case 'alpha-number':
						var fldtype = "alphanumber";
						gem.validateFields(myEvent,fld,fldtype);
						break;
					case 'dropdown':
						var fldtype = "dropdown";
						gem.validateFields(myEvent,fld,fldtype);
						break;
					case 'date-my':
						var fldtype = "datemy";
						gem.validateFields(myEvent,fld,fldtype);
						break;
					case 'date':
						var fldtype = "date";
						gem.validateFields(myEvent,fld,fldtype);
						break;
					case 'max-number':
						  var fldtype = "maxnumber";
						  gem.validateFields(myEvent,fields,fldtype);
						  break;
					case 'min-number':
						  var fldtype = "minnumber";
						  gem.validateFields(myEvent,fields,fldtype);
						  break;
					case 'max-char':
						  var fldtype = "maxchar";
						  gem.validateFields(myEvent,fields,fldtype);
						  break;
					case 'min-char':
					  var fldtype = "minchar";
					  gem.validateFields(myEvent,fields,fldtype);
					  break;
					case 'cpr-number':
					  var fldtype = "cpr";
					  gem.validateFields(myEvent,fields,fldtype);
					  break;
					case 'cvr-number':
					  var fldtype = "cvr";
					  gem.validateFields(myEvent,fields,fldtype);
					  break;
					case 'allow-symbols':
						var fldtype = "symbols";
						gem.validateFields(myEvent,fields,fldtype);
						break;
					case 'post-number':
						var fldtype = "postnumber";
						gem.validateFields(myEvent,fields,fldtype);
						break;
					
				}
			}
		},
		

		validateFields: function(myEvent,fields,fldtype){
			if(fldtype != '' || fldtype != 'undefined'){
				switch(fldtype){
					case 'number':
						var fields = $(fields).parent().find('.number:visible');
						gem.validateNumber(myEvent,fields,fldtype);
						break;
					case 'email':
						var fields = $(fields).parent().find('.email:visible');
						gem.validateEmail(myEvent,fields,fldtype);
						break;
					case 'alpha':
						var fields = $(fields).parent().find('.alpha:visible');
						gem.validateAlpha(myEvent,fields,fldtype);
						break;
					case 'alphanumber':
						var fields = $(fields).parent().find('.alpha-number:visible');
						gem.validateAlphaNum(myEvent,fields,fldtype);
						break;
					case 'dropdown':
						var fields = $(fields).parent().find('.dropdown:visible');
						gem.validateDropdown(myEvent,fields,fldtype);
						break;
					case 'datemy':
						var fields = $(fields).parent().find('.date-my:visible');
						gem.validateMonth(myEvent,fields,fldtype);
						break;
					case 'date':
						var fields = $(fields).parent().find('.date:visible');
						gem.validateDate(myEvent,fields,fldtype);
						break;
					case 'maxnumber':
						var fields = $(fields).parent().find('.max-number'+'--'+gem.settings.numCount+':visible');
						gem.validateMaxNumber(myEvent,fields,fldtype);
						break;
					case 'minnumber':
						var fields = $(fields).parent().find('.min-number'+'--'+gem.settings.numCount+':visible');
						gem.validateMinNumber(myEvent,fields,fldtype);
						break;
					case 'maxchar':
						var fields = $(fields).parent().find('.max-char'+'--'+gem.settings.numCount+':visible');
						gem.validateMaxChar(myEvent,fields,fldtype);
						break;
					case 'minchar':
					 	var fields = $(fields).parent().find('.min-char'+'--'+gem.settings.numCount+':visible');
						gem.validateMinChar(myEvent,fields,fldtype);
						break;
					case 'cpr':
						var fields = $(fields).parent().find('.cpr-number:visible');
						gem.validateCprNumber(myEvent,fields,fldtype);
						break;
					case 'cvr':
						var fields = $(fields).parent().find('.cvr-number:visible');
						gem.validateCvrNumber(myEvent,fields,fldtype);
						break;
					case 'symbols':
						var fields = $(fields).parent().find('.allow-symbols:visible');
						gem.validateSymbols(myEvent,fields,fldtype);
						break;
					case 'postnumber':
						var fields = $(fields).parent().find('.post-number:visible');
						var lCode = gem.getLanguageCode(gem.settings.lanCode)
						gem.validatePostNumber(myEvent,fields,fldtype,lCode);
						break;
				}
			}
		},
		
		validatePostNumber: function(myEvent,fields,fldtype,lCode){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0){
					if(fields.val().length > 0){
						var postVal = 'Nr' + fields.val();
						gem.isPostValid = false;
						$.each( PostNumre[lCode], function( key, value ) {
							if(key != postVal){
								$('#'+fields.attr('id')+'-value').val('');
								$('#'+fields.attr('id')+'-hdn').val('');
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
								$('#'+fields.attr('id')+'-value').val(value);
								$('#'+fields.attr('id')+'-hdn').val(value);
								gem.isPostValid = true;
								return false;
							}
							


						});	
						
						if(gem.isPostValid === false){
							gem.errorShow(myEvent,fields,fldtype);
						}
							
					}
					else{
						fields.parent().find('.error_msg').remove();
						$('#'+fields.attr('id')+'-value').val('');
						$('#'+fields.attr('id')+'-hdn').val('');
						gem.removeError(myEvent,fields,fldtype);
					}
				}
			}
			else{
				if(fields != '' && fields.length > 0 && fields.is(":visible") === true){
					if(fields.length > 1){
						$(fields).each(function() {
							var fields = $(this)
							if(fields.val().length > 0){
								//var self = fields
								var postVal = 'Nr' + fields.val();
								gem.isPostValid = false;
								$.each( PostNumre[lCode], function( key, value ) {
									if(key != postVal){
										//gem.removeError(myEvent,fields,fldtype);
										$('#'+fields.attr('id')+'-value').val('');
										$('#'+fields.attr('id')+'-hdn').val('');
										//gem.errorShow(myEvent,fields,fldtype);
									}
									else{
										gem.removeError(myEvent,fields,fldtype);
										$('#'+fields.attr('id')+'-value').val(value);
										$('#'+fields.attr('id')+'-hdn').val(value);
										gem.isPostValid = true;
										return false;
								
									}
								});
								if(gem.isPostValid === false){
									gem.errorShow(myEvent,fields,fldtype);
								}
							}
							else{
								if($(fields).hasClass('required') === true){
									$('#'+fields.attr('id')+'-value').val('');
									$('#'+fields.attr('id')+'-hdn').val('');
									gem.addError(myEvent,fields,fldtype)
								}
								if($(fields).hasClass('notReq') === true){
									$('#'+fields.attr('id')+'-value').val('');
									$('#'+fields.attr('id')+'-hdn').val('');
									gem.removeError(myEvent,fields,fldtype)
								}
								
							}
	
						});

					}else{
						if(fields.val().length > 0){
							//var self = fields
							var postVal = 'Nr' + fields.val();
							gem.isPostValid = false;
							$.each( PostNumre[lCode], function( key, value ) {
								if(key != postVal){
									$('#'+fields.attr('id')+'-value').val('');
									$('#'+fields.attr('id')+'-hdn').val('');
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
									$('#'+fields.attr('id')+'-value').val(value);
									$('#'+fields.attr('id')+'-hdn').val(value);
									gem.isPostValid = true;
									return false;
								}
								
							});	
							if(gem.isPostValid === false){
								gem.errorShow(myEvent,fields,fldtype);
							}
						}
						else{
							if($(fields).hasClass('required') === true){
								$('#'+fields.attr('id')+'-value').val('');
								$('#'+fields.attr('id')+'-hdn').val('');
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								$('#'+fields.attr('id')+'-value').val('');
								$('#'+fields.attr('id')+'-hdn').val('');
								gem.removeError(myEvent,fields,fldtype)
							}
						}
					}
				}
			}
				
		},
		
		validateMaxNumber: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
								if(!/^[0-9]+$/.test(fields.val())){
									fldtype = 'number';
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									if(fields.val().length > parseInt(gem.settings.numCount)){
										gem.errorShow(myEvent,fields,fldtype);
									}
									else{
										gem.removeError(myEvent,fields,fldtype);
									}
								}
								
						}
						else{
								fields.parent().find('.error_msg').remove();
								gem.removeError(myEvent,fields,fldtype);
						}
				}
			}else{
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^[0-9]+$/.test(fields.val())){
								fldtype = 'number';
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								if(fields.val().length > parseInt(gem.settings.numCount)){
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
								}
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		validateNumber: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
								if(!/^[0-9]+$/.test(fields.val())){
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
								}
								
						}
						else{
								fields.parent().find('.error_msg').remove();
								gem.removeError(myEvent,fields,fldtype);
						}
				}
			}else{
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^[0-9]+$/.test(fields.val())){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		
		validateMinNumber: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
							if(!/^[0-9]+$/.test(fields.val())){
								fldtype = 'number';
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								if(fields.val().length < parseInt(gem.settings.numCount)){
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
								}
							}
						}
						else{
								fields.parent().find('.error_msg').remove();
								gem.removeError(myEvent,fields,fldtype);
						}
				}
			}else{
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^[0-9]+$/.test(fields.val())){
								fldtype = 'number';
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								if(fields.val().length < parseInt(gem.settings.numCount)){
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
								}
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		validateMaxChar: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
								if(!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())){
									fldtype = 'alpha';
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									if(fields.val().length > parseInt(gem.settings.numCount)){
										gem.errorShow(myEvent,fields,fldtype);
									}
									else{
										gem.removeError(myEvent,fields,fldtype);
									}
								}
								
						}
						else{
								fields.parent().find('.error_msg').remove();
								gem.removeError(myEvent,fields,fldtype);
						}
				}
			}else{
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())){
								fldtype = 'alpha';
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								if(fields.val().length > parseInt(gem.settings.numCount)){
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
								}
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		validateSymbols: function(myEvent,fields,fldtype) {
			if(myEvent === 'blur'){
					if(fields != '' && fields.length > 0 && fields.is(":visible")){
							if(fields.val().length > 0){
									if(/<|>/g.test(fields.val())){
										gem.errorShow(myEvent,fields,fldtype);
									}
									else{
										gem.removeError(myEvent,fields,fldtype);
									}
									
							}
							else{
									fields.parent().find('.error_msg').remove();
									gem.removeError(myEvent,fields,fldtype);
							}
					}
					}else{
						if(fields != '' && fields.length > 0 && fields.is(":visible")){
							$(fields).each(function() {
								var fields = $(this)
								if(fields.val().length > 0){
									if(/<|>/g.test(fields.val())){
										gem.errorShow(myEvent,fields,fldtype);
									}
									else{
										gem.removeError(myEvent,fields,fldtype);
									}
									
								}
								else{
									if($(fields).hasClass('required') === true){
										gem.addError(myEvent,fields,fldtype)
									}
									if($(fields).hasClass('notReq') === true){
										gem.removeError(myEvent,fields,fldtype)
									}
								}
		
							});
						}
				}

		},
		
		validateCprNumber: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
							if(!/^\d{6}-{0,1}\d{3,5}[A-Za-z]{0,1}$/.test(fields.val())){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
				}
			}else{
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^\d{6}-{0,1}\d{3,5}[A-Za-z]{0,1}$/.test(fields.val())){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		validateCvrNumber: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
							if(!/^\d{8,9}$/.test(fields.val())){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
				}
			}
		else{
			if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^\d{8,9}$/.test(fields.val())){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		validateMinChar: function(myEvent,fields,fldtype){
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
						if(fields.val().length > 0){
								if(!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())){
									fldtype = 'alpha';
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									if(fields.val().length < parseInt(gem.settings.numCount)){
										gem.errorShow(myEvent,fields,fldtype);
									}
									else{
										gem.removeError(myEvent,fields,fldtype);
									}
								}
								
						}
						else{
								fields.parent().find('.error_msg').remove();
								gem.removeError(myEvent,fields,fldtype);
						}
				}
			}else{
				if(fields != '' && fields.length > 0 && fields.is(":visible")){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.val().length > 0){
							if(!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F ]+$/.test(fields.val())){
								fldtype = 'alpha';
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								if(fields.val().length < parseInt(gem.settings.numCount)){
									gem.errorShow(myEvent,fields,fldtype);
								}
								else{
									gem.removeError(myEvent,fields,fldtype);
								}
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		
		validateEmail: function(myEvent,fields,fldtype) {
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0){
					if(fields.is(":visible") && fields.val().length > 0){
						if(!/^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/.test(fields.val())){
							gem.errorShow(myEvent,fields,fldtype);
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
						
					}
					else{
							fields.parent().find('.error_msg').remove();
							gem.removeError(myEvent,fields,fldtype);
					}
				}
			}
			else{
				if(fields != '' && fields.length > 0){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.is(":visible") && fields.val().length > 0){
							if(!/^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/.test(fields.val())){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}

		},
		
		validateAlpha: function(myEvent,fields,fldtype) {
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0){
					if(fields.is(":visible") && $.trim(fields.val()).length > 0){
						if(!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F -]+$/.test($.trim(fields.val()))){
							gem.errorShow(myEvent,fields,fldtype);
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
						
					}
					else{
							fields.parent().find('.error_msg').remove();
							gem.removeError(myEvent,fields,fldtype);
					}
				}
			}
			else{
				if(fields != '' && fields.length > 0){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.is(":visible") && $.trim(fields.val()).length > 0){
							if(!/^[a-zA-Z\u0080-\u00FF\u0100-\u017F\u0180-\u024F -]+$/.test($.trim(fields.val()))){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}

		},
		
		validateAlphaNum: function(myEvent,fields,fldtype) {
			var specialChar = '()-_+={}[]:;,.? '.replace(/([.*+?^=\-!:${}()|\[\]\/\\])/g, "\\$1");
			var digits = new RegExp('^[a-zA-Z0-9\u0080-\u00FF\u0100-\u017F\u0180-\u024F'+specialChar+']+$');
			if(myEvent === 'blur'){
				if(fields != '' && fields.length > 0){
					if(fields.is(":visible") && $.trim(fields.val()).length > 0){
						if(!digits.test($.trim(fields.val()))){
							gem.errorShow(myEvent,fields,fldtype);
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
						
					}
					else{
							fields.parent().find('.error_msg').remove();
							gem.removeError(myEvent,fields,fldtype);
					}
				}
			}
			else{
				if(fields != '' && fields.length > 0){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.is(":visible") && $.trim(fields.val()).length > 0){
							if(!digits.test($.trim(fields.val()))){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}

		},
		
		validateDropdown: function(myEvent,fields,fldtype) {
			if(myEvent === 'blur'){
					if(fields.is(":visible") === true){
						var selFld = fields['0'].attributes['data-selected-value'].value
						if(selFld == '' && selFld.length > 0){
							gem.removeError(myEvent,fields,fldtype);
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
						
					}
			}
			else{
				if(fields.is(":visible") === true){
					$(fields).each(function() {
						var fields = $(this)
						var selFld = fields['0'].attributes['data-selected-value'].value;
						if(selFld == ''){
							if($(fields).hasClass('required') === true){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
						}
						else{
							gem.removeError(myEvent,fields,fldtype);
						}
					});
						
				}
			}
		},
		
		validateMonth: function(myEvent,fields,fldtype) {
			if(myEvent === 'blur'){
				var validDate = gem.monthValidCheck(fields);
				if(fields.is(":visible") && fields.val().length > 0){
					if(!validDate){
						gem.errorShow(myEvent,fields,fldtype);
					}
					else{
						gem.removeError(myEvent,fields,fldtype);
					}
					
				}
				else{
						fields.parent().find('.error_msg').remove();
						gem.removeError(myEvent,fields,fldtype);
				}
				
			}
			else{
				
				if(fields != '' && fields.length > 0){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.is(":visible") && fields.val().length > 0){
							var validDate = gem.monthValidCheck(fields);
							if(!validDate){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
		},
		validateDate: function(myEvent,fields,fldtype) {
			if(myEvent === 'blur'){
				var validDate = gem.dateValidCheck(fields);
				if(fields.is(":visible") && fields.val().length > 0){
					if(!validDate){
						gem.errorShow(myEvent,fields,fldtype);
					}
					else{
						gem.removeError(myEvent,fields,fldtype);
					}
					
				}
				else{
						fields.parent().find('.error_msg').remove();
						gem.removeError(myEvent,fields,fldtype);
				}
				
			}
			else{
				
				if(fields != '' && fields.length > 0){
					$(fields).each(function() {
						var fields = $(this)
						if(fields.is(":visible") && fields.val().length > 0){
							var validDate = gem.dateValidCheck(fields);
							if(!validDate){
								gem.errorShow(myEvent,fields,fldtype);
							}
							else{
								gem.removeError(myEvent,fields,fldtype);
							}
							
						}
						else{
							if($(fields).hasClass('required') === true){
								gem.addError(myEvent,fields,fldtype)
							}
							if($(fields).hasClass('notReq') === true){
								gem.removeError(myEvent,fields,fldtype)
							}
						}

					});
				}
			}
			
		},
		monthValidCheck:function(fields){
			var dateString = fields.val();
			gem.isMonthValid = true;
			isMonthValid = /^\d{1,2}\/\d{4}$/.test(dateString);
			if(isMonthValid)
			{
				var parts = dateString.split("/");
				var day = 15;
				var month = parseInt(parts[0], 10);
				var year = parseInt(parts[1], 10);
				if(year < 1000 || year > 3000 || month == 0 || month > 12)
					gem.isMonthValid = false;
					var monthLength = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];

			// Adjust for leap years
			if(year % 400 == 0 || (year % 100 != 0 && year % 4 == 0))
				monthLength[1] = 29;
				isMonthValid = isMonthValid && (day > 0 && day <= monthLength[month - 1]);
			}
			return isMonthValid;
		},
		
		dateValidCheck:function(fields){
			var dateString = fields.val();
			gem.isDateValid = true;
			isDateValid = /^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateString);
			if(isDateValid)
			{
				var parts = dateString.split("/");
				var day = parseInt(parts[0], 10);
				var month = parseInt(parts[1], 10);
				var year = parseInt(parts[2], 10);
				if(year < 1000 || year > 3000 || month == 0 || month > 12)
				isDateValid = false;

				var monthLength = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];

			// Adjust for leap years
			if(year % 400 == 0 || (year % 100 != 0 && year % 4 == 0))
				monthLength[1] = 29;
				isDateValid = isDateValid && (day > 0 && day <= monthLength[month - 1]);
			}
			return isDateValid;
		},
		
		validate: function(eventParam, objfld){
			
			advisorAllvalid = true;
			advisorErrid = '';

			// Validation All on submit ***************************************************************************************************
			gem.errorObj = [];
			var classList = $(objfld).find('.default,.responsive-dropdown');
			$.each(classList, function(index, item) {
					if (!$(item).hasClass('required')) {
						$(item).addClass('notReq');
					}
			});
			gem.validateRequired(eventParam, objfld);
		
			if(gem.errorObj.length > 0)
			{
				advisorAllvalid = false;
			}
			
			
			// All validation end here******************************************************************************************************

			if(advisorAllvalid){
				return true;
			}
			else{
				return false;
			}
		},
		
		
		errorShow: function(myEvent,fields,fldtype){
			fields.parent().find('.error_msg').remove();
			fields.addClass('input-error');
			gem.errorObj.push(fields.attr('id'));
			fields.parent().append('<div class="error_msg"><span>&nbsp;</span>'+gem.getErrorMessage(fldtype)+'</div>');
		},
		addError: function(myEvent,fields,fldtype){
			fields.addClass('input-error');
			fields.attr('placeholder',gem.getErrorMessage('placeholderTxt'));
			gem.errorObj.push(fields.attr('id'));
		},
		removeError: function(myEvent,fields,fldtype){
			fields.parent().find('.error_msg').remove();
			fields.removeAttr('placeholder');
			fields.removeClass('input-error');
		},
		
		setTo : function(to) {
			$("[id$='fldSendTo']").val(to);
		},

		setFrom : function(from) {
			$("[id$='fldNavnH']").val(from);
		},

		setSubject : function(subj) {
			var oldSubj = subj;
			var newSubj = '';
			if(oldSubj != '' || oldSubj != 'undefined'){
				var lanCode = gem.getLanguageCode(gem.settings.lanCode);
				switch(lanCode){
					case 'SE':
					    newSubj = gem.getCustomSubject(lanCode);
						break;
					case 'DK':
						newSubj = gem.getCustomSubject(lanCode);
						break;
					case 'NO':
						newSubj = gem.getCustomSubject(lanCode);
						break;
					case 'FI':
						newSubj = gem.getCustomSubject(lanCode);
						break;
					case 'UK':
						newSubj = gem.getCustomSubject(lanCode);
						break;
					default:
						newSubj = gem.getCustomSubject(lanCode);
						break;
						
				}
				$("[id$='fldSubjH']").val(newSubj);
			}else{
				$("[id$='fldSubjH']").val(oldSubj);
				
			}
		},
		getCustomSubject: function(lanCode){
			var subj1Val = $('#'+ gem.settings.formContainerId).find('.subj1').val()

			if(subj1Val != undefined){
				subj1Val = subj1Val;
			}else{
				subj1Val = ''
			}
			
			var subj2Val = $('#'+ gem.settings.formContainerId).find('.subj2').val();
			if(subj2Val != undefined){
				subj2Val = gem.settings.tablevalueDelim + subj2Val;
			}else{
				subj2Val = ''
			}
			
			var subj3Val = $('#'+ gem.settings.formContainerId).find('.subj3').val();
			if(subj3Val != undefined){
				subj3Val = gem.settings.tablevalueDelim + subj3Val;
			}else{
				subj3Val = '';
			}
			
			
			if(lanCode == 'FI'){
				var subjStr = $('#__formSubj').val()
				var newSubj = subjStr + gem.settings.tablevalueDelim + ' ' + subj1Val + subj2Val + subj3Val
				return newSubj
			}else{
				var newSubj = 'Webform: ' + document.title + gem.settings.tablevalueDelim + subj1Val + subj2Val + subj3Val;
				return newSubj
			}
		},
		timestampFields : function() {
			var tidChars = "bcdfghjkmnpqrstvxz";
			var tidStringLength = 3;
			var transID1 = '';
			var transID2, tidTransID;
			var tidNum = 0;
			var i = 0;
			if ($("[id$='fldTimestampH']").val() === '') {
				for (i=0; i<tidStringLength; i++) {
					tidNum = Math.floor(Math.random() * tidChars.length);
					transID1 += tidChars.substring(tidNum, tidNum+1);
				}
				transID2 = new Date().getTime();
				tidTransID = transID1 + transID2;
				$("[id$='fldTimestampH']").val(tidTransID);
			}
		},

		escapeHTML : function(string) {
			var entityMap = { "&":"&amp;", "<":"&lt;", ">":"&gt;", '"':'&quot;', "'":'&#39;', "/":'&#x2F;' };
			return String(string).replace(/[&<>"'\/]/g, function (s) {
				return entityMap[s];
			});
		},

		getFieldIdList : function(fldListObj) {
			var fldIdList = [];
			var fld;
			for (var i=1;i<fldListObj.length;i++) {
					if (fldListObj[i] != undefined) {
						fld = fldListObj[i];
						var fldId = (fld.id == '' || fld.id == undefined ) ? fld.name : fld.id;
						fldIdList.push(fldId);
					}
			}

			return fldIdList;

		},

		getFieldLabel : function(fldListObj) {
			var fldLabelList = [];
			var fldLabel;
			for (var i=1;i<fldListObj.length;i++) {
					if (fldListObj[i] != undefined) {
						fld = fldListObj[i];
						if ($(fld).attr('data-cblabel') != undefined) {
							  fldLabel = $(fld).attr('data-cblabel');
						 } else {
							  fldLabel = gem.findLabel(fld);
						 }
						 fldLabelList.push(fldLabel);
					}
			}
			return fldLabelList;
		},

		findLabel: function(fld) {
			var labelTxt = '';
			var sibling;
			var siblings = fld.parentNode.childNodes;
			for (var i=0;i<siblings.length;i++) {
				sibling = siblings[i];
				if (sibling.nodeType == 1) {
					tagname = sibling.tagName.toUpperCase();
					if (tagname == 'LABEL' || tagname == 'LEGEND') {
						labelTxt = $(sibling).text();
						labelTxt = labelTxt.replace(/\*/gm,"");
						break;
					}
				}
			}
			return labelTxt;
		},

		getFieldValue : function(id) {

			var fldObj = $('#' + id);
			var val = '';
			if (fldObj.hasClass('radioCollection')) {
				var selected = fldObj;
				//if (selected.length > 0) {
					val = $.trim(selected.val());
				//}
			} else if (fldObj.hasClass('checkboxCollection')) {
				var selected = fldObj;
				var valList = [];
				$.each(selected, function() {
					valList.push($.trim($(this).val()));
				});
				val = valList.join(gem.settings.multivalueDelim);
			}

			else if (fldObj.hasClass('responsive-dropdown')) {
				var selectedVal = fldObj.attr('data-selected-value');
				val = $.trim(selectedVal);
			}

			 else {
				 val = $.trim(fldObj.val());

			}
			return val;
		},

		preText : function() {
			return '';
		},
		postDate:function(){
			var today = new Date();
			function z(t) {
				var p = t < 10 ? '0' : '';
				return p + t;
			}
			var postDate = z(today.getDate()) + '-' + z(today.getMonth()+1) + '-' + z(today.getFullYear());
			return postDate ;
		},
		postText : function() {
			var postTxt = '!#Timestamp (sent): ';
			var now = new Date();
			function z(t) {
				var p = t < 10 ? '0' : '';
				return p + t;
			}
			postTxt += z(now.getDate()) + '-' + z(now.getMonth()+1) + '-' + z(now.getFullYear()) + ' ';
			postTxt += z(now.getHours()) + ':' + z(now.getMinutes()) + ':' + z(now.getSeconds());
			return postTxt ;
		},

		fetchFields : function() {
			var formcontainer = document.getElementById(gem.settings.formContainerId);
			gem.sortDataFields(formcontainer);
			var curFields = gem.getFieldIdList(gem.settings.fields);
			var txt = '';
			var i = 0;
			var fldLabel = '';
			txt += gem.preText();
			for (i=0; i<curFields.length; i++) {
				fldLabel = gem.getFieldLabel(gem.settings.fields);
				txt += fldLabel[i] + gem.settings.fieldValPairDelim + gem.getFieldValue(curFields[i]) + '!#';

			}
			//txt += gem.postText();

			$("[id$='fldText']").val(txt);
		},
		dotNumberFormat: function(num) {
			var num = num.toString().replace('.', ',');
			return num.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1.") + ' kr'
		},
		getFieldValueFromFldText : function(id) {
			//used if you need to get some values for showing the receipt.
			var txt = $("[id$='fldText']").val();
			if (txt=='') { //if there is no text, no need to continue
				return;
			}
			var fldLabel = gem.getFieldLabel(id);
			var list = txt.split('!#'); //put all lines of the _fldText field into an array
			var fldDelim = gem.settings.fieldValPairDelim;
			var fldLine;
			var i = 0;
			for (i=0; i<list.length; i++) { //run through every line
				if ( list[i].indexOf(fldDelim) > -1 ) { //this is a line with a field
					fldLine = list[i].split(fldDelim); //split that linie into label and value
					if (fldLine[0] == fldLabel) {
						return fldLine[1];
					}
				}
			}
		},

		getBPMID : function() {
			// Will be added to subject, see setSubject function. Modify to suit specs.
			var cvr = $('#advisor-pantnr').val();
			var stamp = $("[id$='fldTimestampH']").val();
			var bpmid = "CVR:(" + cvr + ") ID:(" + stamp + ")";
			return bpmid;
		},
		
		
		textareaValuePass: function(){
			var txtArea = $('#'+ gem.settings.formContainerId + ' .textComment').attr('id');
			var txtAreaVal = $('#'+txtArea).val();
			$('#' + txtArea + '-hidden').val(txtAreaVal);
		},

		uSubmitForm : function() {
			gem.fetchFields();
			gem.textareaValuePass();
			var topic = gem.settings.defaultSubject;
			if (topic != '') {
				gem.setSubject(topic);
			}
			var from = 'R3732WAS';
			gem.setFrom(from);
			
			return true;
		},
		
		nSubmitForm : function() {
			var formcontainer = document.getElementById(gem.settings.formContainerId);
			gem.sortDataFields(formcontainer);
			var curFields = gem.getFieldIdList(gem.settings.fields);
			initFrm();
			$.DBGsendFormCBfr({
				 formContainerId: formcontainer,
				 setFormCharset: 'iso-8859-1',
				 setMail: 'MANJM',
				 setDestDB: 'Contacts\\DBContacts.nsf',
				 setMsgTxtBefLink: 'Click the below button to see the data:',
				 setMsgTxtAfterLink: '',
				 setCategory: 'Danske Bank\\Address\\Test\\Egain',
				 setSubject: 'Contact Us',
				 generateCBfields: true,
				 fieldIdList: curFields,
				 testmode: false
			});
			return true;
		},

		checkSubmit : function() {
			var topic = $("[id$='fldSubjH']").val();
			var from = $("[id$='fldNavnH']").val();
			var txt = $("[id$='fldText']").val();
			$("[id$='fldLang']").val('da');
			DB.generalUploadSendParam(from, topic, txt);
			if (typeof flashEventFunction == 'function') {
				flashEventFunction(s_sitecatalyst.pageName+' - kvittering','l','','');
			}
			gem.showReceipt();
			return true;

		},

		showAddressError : function() {
			alert('Error: Form recipient not valid.');
		},

		showReceipt : function() {
			$('#'+ gem.settings.formContainerId +'-receipt').foundation('open');
			$('#'+ gem.settings.formContainerId +'-receipt').on('click', function(){
		    	document.location.reload();
			});
		}
	}

	$(document).ready(function(){
		gem.init();

	});


})(jQuery);
