var trackingNames = {
    "pbebank": " - Logon Menu - Verkkopankki",
    "pbebank-en": " - Logon Menu - eBanking",
    "pbebank-sv": " - Logon Menu - Webbanken",
    "pbotmeet": " - Logon Menu - Verkkotapaaminen (other)",
    "pbotmeet-en": " - Logon Menu - Online meeting (other)",
    "pbotmeet-sv": " - Logon Menu - Webbm&#xF6;te (other)",
    "pbotebank": " - Logon Menu - Verkkopankki (other)",
    "pbotebank-en": " - Logon Menu - eBanking (other)",
    "pbotebank-sv": " - Logon Menu - Webbanken (other)",
    "pbdigital": " - Logon Menu - Allekirjoituspalvelu",
    "pbdigital-en": " - Logon Menu - Digital Signing",
    "pbdigital-sv": " - Logon Menu - Digital signering",
    "bbonline": " - Logon Menu - Business Online",
    "bbonline-en": " - Logon Menu - Business Online - en",
    "bbonline-sv": " - Logon Menu - Business Online - sv",
    "bbdigital": " - Logon Menu - Allekirjoituspalvelu",
    "bbauditorfi": " - Logon Menu - Tilintarkastajaportaali",
    "bbcemmfi": " - Logon Menu - CorporateExpenseManager",
    "bbdigital-en": " - Logon Menu - Digital Signing",    
    "dfAsiakasportaali": " - Logon Menu - Danske finance Asiakasportaali",
    "dfverkkopankki": " - Logon Menu - Danske finance verkkopankki",
    "dfvendoronline": " - Logon Menu - Danske finance Vendor Online",
    "dfbbAsiakasportaali": " - Logon Menu - Danske finance bb Asiakasportaali",
    "dfbbdistrict": " - Logon Menu - Danske finance bb District",
    "dfbbdfa": " - Logon Menu - Danske finance Allekirjoituspalvelu",
    "dfbbAllekirjoituspalvelu": " - Logon Menu - Danske finance bb Allekirjoituspalvelu",
    "bbdigital-sv": " - Logon Menu - Digital signering"
    
};

var loginGotoPage = {
    "pb": "/sinulle/asiakaspalvelu",    
    "df": "/danskefinance/henkiloasiakkaat/henkiloasiakkaat-landing-page",    
    "pb-en": "/en/for-you/customer-service",
    "pb-sv": "/se/for-dig/kundservice",
    "bb": "/yrityksille/asiakaspalvelu",
    "bb-en": "/en/for-businesses/customer-service",
    "bb-sv": "/se/for-foretag/kundservice"
};

var toggleIDs = {
};

function collapseAll(speed, except) {
    except = except || '';
    for (var x in toggleIDs) {
        if (x != except) {
            jQuery('#' + toggleIDs[x]).hide(speed);
        }
    }
};

function toggleMenu(id) {
    if (jQuery('#' + toggleIDs[id]).is(':visible')) {
        jQuery('#' + toggleIDs[id]).hide(500);
    } else {
        jQuery('#' + toggleIDs[id]).show(500);
        collapseAll(500, id);
    }
};

jQuery(window).load(function ($) {
    collapseAll(0);
});

jQuery(document).ready(function ($) {
    $('#loginPopup a').click(function () {
        var clickID = $(this).attr('id');
        if (trackingNames[clickID] !== undefined) {
            SetCookie("history_login", clickID, 365);
            DB.track(trackingNames[clickID]);
            var patt = new RegExp("(?:pbebank|online)");
            if (patt.test(clickID)) {
                var mainSection = clickID.substring(0, 2);
                var language = /[a-z]+-[a-z]{2}$/.test(clickID) ? clickID.substring(clickID.lastIndexOf('-')) : "";
                var loginPath = loginGotoPage[(mainSection + language)];
                location.href = 'https://' + location.hostname + loginPath + '?n-login=' + clickID;
            }
        } else {
            for (var x in toggleIDs) {
                if (clickID == x) {
                    toggleMenu(clickID);
                    break;
                }
            }
        }
    });
});

function netLogonParam(id, dl) {
    if (trackingNames[id] !== undefined) {
        DB.track(trackingNames[id].split(' Menu ').join(' Function '));
        var mainSection = id.substring(0, 2);
        var language = /[a-z]+-[a-z]{2}$/.test(clickID) ? clickID.substring(clickID.lastIndexOf('-')) : "";
        var loginPath = loginGotoPage[(mainSection + language)];
        var dlParm = (dl ? ('&DL=' + dl) : '');
        var logonUrl = 'https://' + location.hostname + loginPath + '?n-login=' + id + dlParm;
        location.assign(logonUrl);
    }
}

function SetCookie(c_name, value, exdays) {
    var exdate = new Date();
    exdate.setDate(exdate.getDate() + exdays);
    var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
    document.cookie = c_name + "=" + c_value + "; path=/";
}