﻿    var mapdata = '';
    var map;
    var mapsmall;
    var infoWindow; 
    var markers = [];
    var _currentLocation;
    var _linkLocation;
    var _queryStr;
    var _queryStrLocation;
    var displayList = false;
    var mobileFindus = false;
    var _currentPageIndex = 0;
    var _totalPages = 0;
    var _prPage = 4;
    var _radius = 0;
    var initCustomInfoWindow = true;
    var googletimeout = 300;
	var isFindUsClicked = false;
	var _language;
	var isIE = (window.navigator.userAgent.indexOf("MSIE") > 0 || navigator.appVersion.indexOf('Trident/index.html') > 0);
    var _encodedStr;
    var _htmlLang = document.documentElement.lang;
	var _selectedFilterValues='';
window.onpopstate = function(e) {
        (function($) {
            if (displayList) {
                $('#gmap').slideToggle();
                $('#mobileshowlist').slideToggle();
                //remove all but the first
                $("#mobileresults").empty();
			    if (mapdata.length > 0)
                {
                    generateListItem(mapdata[0], "#mobileresults", 1, _selectedFilterValues);
                }
                $(window).scrollTop();
                displayList = false;
                e.preventDefault();
            } 
            else if (mobileFindus)
            {
                window.location.reload(true);
            }   
        })(jQuery);    
    };

    window.onload = function() {
        //jquery is not available on document ready
        (function($) {
            gotoTab2();
            $('#showlist').on('click', showlist);
            $('#findus').on('click', findusClicked);
            $('input.type-filter').on('change', filterschanges);
            $('input.whatyouneed').on('change', filterschanges);
            $('#search-infobox-close').on('click', infoboxclose); 
			changeTabCounts(0);
			
			if(_country === 'EE'){
				var filtersElement = $('#filters');
				if(filtersElement) filtersElement.remove();
			}

            //on enter in search field or click on button search and tab2
            var $searchbutton = $('#searchcontainer .input-submit .button');
            $searchbutton.on('click', searchButtonClicked);
            $('#desktopsearch').on('keydown', isenter);
            $('#mobilesearch').on('keydown', isenter);			
            tab2();
			tab2 = DB.utils.debounce(tab2, 500); //Debounce after first run to prevent calling multiple times while resizing window
			var types = getQueryString('type');
			if(types !== null)
			{
			setQueryStringLocation(types);
			}
			var filters = getQueryString('filter');
			if(filters !== null)
			{
			setQueryStringFilter(filters);
			}
            $(window).resize(tab2);
			
            function findusClicked(e)
            {
				//DB.doSearch();
				isFindUsClicked = true;
                var isMobile = Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium');
                
                var $viewbusiness = $('span.viewbusiness');
                $viewbusiness.css('visibility', 'hidden');
				var filtersElement = $('#filters');
				if(filtersElement) filtersElement.css('visibility', 'hidden');
				
                setTimeout(function () { google.maps.event.trigger(gmap, 'resize'); }, googletimeout);      

                //load mobile version?
                //hook on to back button click if mobile 
                if (isMobile) 
                {
                    history.pushState(null, 'mobile tab2 clicked', _pagelink + '#tab2');
                    mobileFindus = true;
                    findusMobile();
                }
                else
                {
                    $('#area').css('display', 'block');
                }

                initQueryParameters();
                
                //have user entered something different from querystr - then search for that
                var searchstr = '';
                
                var $mobilesearch = $('#mobilesearch');
                var $desktopsearch = $('#desktopsearch');
                if (Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium'))
                {
                    searchstr = $mobilesearch.val();
                    $desktopsearch.val(searchstr);
                }
                else
                {
                    searchstr = $desktopsearch.val();
                    $mobilesearch.val(searchstr);
                }
                
				if(searchstr === 'undefined')
				{
					searchstr = '';
				}
                var qstr = $.trim(searchstr).toLowerCase();
                
                if (searchstr !== _queryStr)
                {
                    _queryStr = searchstr;
                }

                else if (_queryStr && _queryStr !== "")
                {			
					if (_country == "DK")
					{
						_language = "da-DK";
					}
					if (_country == "NO")
					{
						_language = "no-NO";
					}
					if (_country == "SE")
					{
						_language = "sv-SE";
					}
					if (_country == "FI")
					{
                        _language = "fi-FI";
					}
					if (_country == "GB")
					{
						_language = "en-GB";
					}
					if (_country == "LT")
					{
						_language = "lt-LT";
					}
					if (_country == "EE")
					{
						_language = "et-EE";
					}
					
					encodeString(_queryStr);

					
					var url = '/api/googlemaps/geocoding?address='+_encodedStr+'&components=country:' + _country + '&language=' + _language;

                    $.ajax( {
                        dataType: "json", 
                        url: url,
                        success: function (data) { 
                            if (data.results.length > 0) 
                            {
                                _queryStrLocation = data.results[0].geometry.location.lat + "," + data.results[0].geometry.location.lng;
                                var bounds = new google.maps.LatLngBounds(data.results[0].geometry.viewport.southwest, data.results[0].geometry.viewport.northeast);
                                
                                map = new google.maps.Map(document.getElementById('gmap'), {center : getMapCenter() , zoom: _zoom, scrollwheel: false});
                                map.fitBounds(bounds);
                                addMapListeners();
                            }
                            else
                            {
                                map = new google.maps.Map(document.getElementById('gmap'), {center : getMapCenter() , zoom: _zoom, scrollwheel: false});                
                                addMapListeners();
                            }
                            doMapSearch();
                        }
                    });
                }
                else
                {
                    nearest();
                }
            };

            function searchButtonClicked(e)
            {	
                if (isTab2())
                {
                    askgoogle(e); 
                }
                else
                {
                    gotoTab2(true);
                }
            }

            function isenter(e) 
            {
                if (e.keyCode == 13) {
                    if (isTab2()) 
                    {
                        e.preventDefault();
                        askgoogle(e); 
                    }
                    else
                    {
                        gotoTab2(true);
                    }
                }
            };

            function askgoogle()
            {				
				//DB.doSearch();
                var searchstr = '' ;
                var filters = '';
                var locationtypes = '';

                var $mobilesearch = $('#mobilesearch');
                var $desktopsearch = $('#desktopsearch');

                if (Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium'))
                {
                    searchstr = $mobilesearch.val();
                    $desktopsearch.val(searchstr);
                }
                else
                {
                    searchstr = $desktopsearch.val();
                    $mobilesearch.val(searchstr);
                }

                if (searchstr === "" || searchstr === 'undefined')
                {
                    return;
                }
				
				if (isMobile) 
                {
                    history.pushState(null, 'mobile tab2 clicked', _pagelink + '#tab2');
                    mobileFindus = true;
                    findusMobile();
                }

                _linkLocation = '';
                _currentLocation = '';

                _queryStr = searchstr
                //align the via google
				
				if (_country == "DK")
				{
					_language = "da-DK";
				}
				if (_country == "NO")
				{
					_language = "no-NO";
				}
				if (_country == "SE")
				{
					_language = "sv-SE";
				}
				if (_country == "FI")
				{
                    _language = "fi-FI";
                  
				}
				if (_country == "GB")
				{
					_language = "en-GB";
				}
				if (_country == "LT")
				{
					_language = "lt-LT";
				}
				if (_country == "EE")
				{
					_language = "et-EE";
				}
		
				encodeString(_queryStr);
				
				var url = '/api/googlemaps/geocoding?address='+_encodedStr+'&components=country:' + _country + '&language=' + _language;

                $.ajax( {
                    dataType: "json", 
                    url: url,
                    success: function (data) { 
                        if (data.results.length > 0) 
                        {
                            _queryStrLocation = data.results[0].geometry.location.lat + "," + data.results[0].geometry.location.lng;
                            var bounds = new google.maps.LatLngBounds(data.results[0].geometry.viewport.southwest, data.results[0].geometry.viewport.northeast);
                            
                            map = new google.maps.Map(document.getElementById('gmap'), {center : getMapCenter() , zoom: _zoom, scrollwheel: false});
                            map.fitBounds(bounds);
                            addMapListeners();
                        }
                        else
                        {
                            map = new google.maps.Map(document.getElementById('gmap'), {center : getMapCenter() , zoom: _zoom, scrollwheel: false});                
                            addMapListeners();
                        }
                        doMapSearch();
                    }
                });  
            }

            function tab2()
            {
                var filterwidth = parseFloat( $('#filtermobile').find('.float-right').css('width')) + 1;
                $('#inputmobile').css({'width': 'calc(100% - ' + filterwidth+ 'px)'});
                $('#inputmobile').css('visibility', 'visible');

                if (isTab2()) 
                {
                    findusClicked(null);
                } 
                else
                {
                    if ($('#searchcontent').length > 0)
                    {
						var filtersElement = $('#filters');
						if(filtersElement) filtersElement.css('visibility', 'visible');
                    }
                }
            };
			
			function getQueryString (field, url)
			{
				var href = url ? url : window.location.href;
				var reg = new RegExp( '[?&]' + field + '=([^&#]*)', 'i' );
				var string = reg.exec(href);
				return string ? string[1] : null;
			};
			
			function setQueryStringLocation(queryvalues)
			{
					var split_types = queryvalues.split(",");
					for (i = 0; i < split_types.length; ++i) 
					{
						var typespace = split_types[i];
						split_types[i] = typespace.replace(/-/g," ");
					}
					for (var i=0;i<labels.Types.length;i++)
					{
						if (split_types.indexOf(labels.Types[i].FilterDisplayName) !== -1) 
						{
							 var typeID = labels.Types[i].Id;
							 document.getElementById(typeID).checked = true;
						}
					}
			};
			
			function setQueryStringFilter(queryvalues)
			{
					var split_filters = queryvalues.split(",");
					for (i = 0; i < split_filters.length; ++i) 
					{
						var filterspace = split_filters[i];
						split_filters[i] = filterspace.replace(/-/g," ");
					}
					for (var i=0;i<labels.Filters.length;i++)
					{
						if (split_filters.indexOf(labels.Filters[i].FilterDisplayName) !== -1) 
						{
							 var filterId = labels.Filters[i].Id;
							 document.getElementById(filterId).checked = true;
						}
					}
			};
			
            function findusMobile() 
            {
                // $('#mobile-page-search-container').find('.float-right.tpad3').css('display', 'none');
                // var m = ($('#mobile-page-search-container')).detach();
                // m.insertBefore('#mobileresults');
                // $('#area').css('display', 'none');
				
				setTimeout(function(){ 
				var filterMob = document.getElementById('filtermobile');
					filterMob.style.visibility = 'visible';
				}, 1000);
				
				 //var filterMob = document.getElementById('filtermobile');
				 //filterMob.style.visibility = 'visible';
            };

            function nearest(e) 
            {
                if (navigator.geolocation) {
                    var location_timeout = setTimeout(redirectNoPostion, 10000);

                    navigator.geolocation.getCurrentPosition(function(position) {
                        clearTimeout(location_timeout);
                        //set current location
                        redirectnearest(position);
                    }, function(error) {
                        clearTimeout(location_timeout);
                        showerror(e);
                    }, {maximumAge: 300000, timeout:5000, enableHighAccuracy: true});
                } else {
                    // Fallback for no geolocation
                    showerror(e);
                }
            };

            function redirectNoPostion() 
            {
                if(!_currentLocation){
                    switch(_country){
                        case "DK":
                            _currentLocation = "55.6760968,12.5683372";
							_encodedStr = "København";
                            break;
                        case "NO":
                            _currentLocation = "59.9138688,10.7522454";
							_encodedStr = "Oslo";
                            break;
                        case "SE":
                            _currentLocation = "59.32932349999999,18.0685808";
							_encodedStr = "Stockholm";
                            break;
                        case "FI":
                            _currentLocation = "60.16985569999999,24.9383791";
							_encodedStr = "Helsinki";
                            break;
                        case "GB":
                            _currentLocation = "54.59728500000001,-5.93012";
							_encodedStr = "Belfast";
                            break;
                        case "LT":
                            _currentLocation = "54.6871555,25.2796514";
							_encodedStr = "Vilnius";
                            break;
                    }
                }
                doMapSearch();
            };
            
            function redirectnearest(position)
            {
                _currentLocation = position.coords.latitude + "," + position.coords.longitude;
                redirectNoPostion();
            };

            function showerror(error) {
                if (error) {
                    switch(error.code) {
                        case error.PERMISSION_DENIED:
                            console.log("User denied the request for Geolocation.");
                            break;
                        case error.POSITION_UNAVAILABLE:
                            console.log("Location information is unavailable.");
                            break;
                        case error.TIMEOUT:
                            navigator.geolocation.getCurrentPosition(function(position) {
                                clearTimeout(location_timeout);
                                redirectnearest(position);
                            }, function(error) {
                                clearTimeout(location_timeout);
                                showerror(e);
                            }, {maximumAge: 300000, timeout:5000, enableHighAccuracy: false});
                            
                            console.log("The request to get user location timed out.");
                            return;
                        case error.UNKNOWN_ERROR:
                            console.log("An unknown error occurred.");
                            break;
                    }
                }
                redirectNoPostion();
            };

            function infoboxclose(e)
            {
                $('#search-infobox').css('display', 'none');
            }

            function showlist(e) 
            {
                e.preventDefault();
                displayList = true;
                //hide the map
                $('#gmap').slideToggle("slow");

                $('#mobileshowlist').slideToggle("slow");
                //add the rest of the results
				
                for (var i = 1;i<mapdata.length;i++)
                {
                    generateListItem(mapdata[i], "#mobileresults", i + 1, _selectedFilterValues);
                }
                history.pushState(null, 'showlist', _pagelink + '#showlist');
            };
   
        })(jQuery);
    };

    function isTab2()
    {
        var url = window.location.href;
        var tab = url.split('#');
        		
        if (tab[tab.length-1] === "tab2") 
        {
            return true;
        } 
        return false;    
    }

    function gotoTab2(useInputField)
    {
		var url = window.location.href;
        var tab = url.split('#');
        if (!postalcodeformat)
        {
            postalcodeformat = "^[0-9]{4}$";
        }
        var re = new RegExp(postalcodeformat);

        var stringToTest = '';
        if (useInputField)
        {
            if (Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium'))
            {
                stringToTest = document.getElementById('mobilesearch').value;
            }
            else
            {
                stringToTest = document.getElementById('desktopsearch').value;
            }
        }
        else
        {
            stringToTest = _queryStr;
        }

        if (re.test(stringToTest)) {
            var l = window.location.href.split('#');
            window.location = l[0] + '#tab2';
        }
		
		checkLocationString();
    }
	
	function checkLocationString()
	{
		jQuery(document).ready(function($){
		
		var searchstr = '';               
        var $mobilesearch = $('#mobilesearch');
        var $desktopsearch = $('#desktopsearch');
        if (Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium'))
        {
            searchstr = $mobilesearch.val();
            $desktopsearch.val(searchstr);
        }
        else
        {
            searchstr = $desktopsearch.val();
            $mobilesearch.val(searchstr);
        }
          
		if (searchstr.length === 0 || searchstr === 'undefined') return;
		
        if ($('#gmap').css('visibility') === 'hidden')
        {
            $('#gmap').css('visibility', 'visible');
        }

		var locationtypes = '';
		_linkLocation = '';
        _currentLocation = '';
        _queryStr = searchstr;
		
		encodeString(_queryStr);
		var countrySearchLocation;
		switch(_country){
			case 'EE':
				countrySearchLocation = 'EE';
				_language = "ee";
				break;
			case 'SE':
				countrySearchLocation = 'SE';
				_language = "sv";
				break;
			case 'NO':
				countrySearchLocation = 'NO';
				_language = "no";
				break;
			case 'DK':
				countrySearchLocation = 'DK';
				_language = "da";
				break;
			case 'FI':
				countrySearchLocation = 'FI';
				_language = "fi";
				break;
			case 'LT':
				countrySearchLocation = 'LT';
				_language = "lt";
				break;
			case 'LV':
				countrySearchLocation = 'LV';
				_language = "lv";
				break;
			case 'GB':
				countrySearchLocation = 'UK';
				_language = "en-GB";
				break;
			default:
				countrySearchLocation = 'Europe'
				_language = "da";
				
		}
		var url = '/api/googlemaps/geocoding?address='+_encodedStr+'&components=country:' + countrySearchLocation + '&language=' + _language;

            $.ajax( {
                dataType: "json", 
                url: url,
                success: function (data){ 
				if (data.results.length > 0 && data.results[0].types[0] != "country") 
                {
                    _queryStrLocation = data.results[0].geometry.location.lat + "," + data.results[0].geometry.location.lng;
                     var bounds = new google.maps.LatLngBounds(data.results[0].geometry.viewport.southwest, data.results[0].geometry.viewport.northeast);
                            
                    map = new google.maps.Map(document.getElementById('gmap'), {center : getMapCenter() , zoom: 14, scrollwheel: false, minZoom: 14});
					map.setZoom(16);
                    map.fitBounds(bounds);					
					var center = getMapCenter();
					map.panTo(center);
					var locationtypes = '';
					_linkLocation = '';
					_currentLocation = '';
					
					if (_radius == 0)
					{
						google.maps.event.trigger(gmap, 'resize');
						var center = getMapCenter();
						map.setCenter(center);
						map.panTo(center);	
					}
											
					map.fitBounds(bounds);
					
					// version 3.34 had undefined bounds hence added this newbounds calculations
					
					getBoundsData(function(newbounds){
			
			       _radius = getmapradius(newbounds);
					
					// this code is a hack fix, will come back again.
					if(_country === "DK"){
                        var qstr = $.trim(_queryStr).toLowerCase();
                        if(qstr === "norreport" || qstr === "nørreport"){
                               
                            _radius = 0.3081979373101228;
                        }
                    }
					var queryCenter = getMapCenterOrg();
                    
                    if(_country === "FI"){
                        var qstr = $.trim(_queryStr).toLowerCase();
                        if(qstr === "konttori" || qstr === "konttorit"){
                             
                            _radius = 387;
                        }
                    }

					encodeString(_queryStr);
					
					if (_country == "LT")
					{
						var newsearchdataparam = searchdataparam.split('&l');
						searchdataparam = newsearchdataparam[0] + '&l=lt-LT';
                    }
					if (_country == "FI")
					{
						var newsearchdataparam = searchdataparam.split('&l');
						searchdataparam = newsearchdataparam[0] + '&l=fi-FI';
                    }
					if (_country == "DK")
					{
						var newsearchdataparam = searchdataparam.split('&l');
						searchdataparam = newsearchdataparam[0] + '&l=da';
                    }
					else if (_country == "EE")
					{
						var newsearchdataparam = searchdataparam.split('&l');
						searchdataparam = newsearchdataparam[0] + '&l=et-EE';
						if (_radius <= 1)
						{
							_radius = 40;
						}
                    }

					var url = mapsearchdataurl + searchdataparam + "&o=" + 0 + "&m=" + 999 + "&r=" + _radius + "&q=" + _encodedStr + "&cl=" + queryCenter + "&lt=" + locationtypes + "&f=";
						$.ajax({
							dataType: "json", 
							url: url,
							success: function (data) 							
								{ 
									if (data.length > 0) 
									{
										$('#findus').click(); 
									}
									else
									{
										 if (DB.Search.MarketFacet == 'foretag')
										 {
											 setTimeout(function(){ javascript:DB.setMarketAndDoSearch('f%C3%B6retag'); }, 500);
										 }
										changeTabCounts(0);
									}	
								}
							});
                  });
				 }
                    else
                    {
						if (DB.Search.MarketFacet == 'foretag')
						{
							setTimeout(function(){ javascript:DB.setMarketAndDoSearch('f%C3%B6retag'); }, 500);
						}
						changeTabCounts(0);
                    }
                }
            });
		});
	}

    function isShowList()
    {
        var url = window.location.href;
        var tab = url.split('#');
        
        if (tab[tab.length-1] === "showlist") 
        {
            return true;
        } 
        return false;               
    }

    function initQueryParameters()
    {
        var q = getParameterByName('q');
		if (q == null || q === 'undefined')
		{
			q = '';
		}
        if (!_queryStr)
        {
            _queryStr = q;
        }
        var n = getParameterByName('n'); //n is a get nearest request
        if (!_currentLocation)
        {
            _currentLocation = n;
        }
        var l = getParameterByName('l');
        if (!_linkLocation)
        {
            _linkLocation = l;
        }
    }

    function handleInfoboxEachNewSearch()
    {
        (function($) {
            if (_infoboxes.length > 0)
            {
                var data = getinfobox(_infoboxes, "{8367AB23-5354-4DDE-B2DD-A3E8A9D101C6}");
                if (data)
                {
                    var infobox = $('#search-infobox');
                    infobox.empty();
                    var html = '';
                    var hasNonDefaultColors = data.Color || data.ColorText;
                    if (hasNonDefaultColors)
                    {
                        html += '<div style="background-color: '+data.Color+'; color: '+data.ColorText+'">';
                    }
                    html += '<div class="large-10 large-offset-1">' +
                        '<div class="info-box-container"><span class="info-alarm-icon float-left">';
                    if (data.HereYouCan)
                    {
                        html += '<h4>'+data.HereYouCan+'</h4>';
                    }       
                    html += '</span><span class="info-text float-left">' +
                            '<h4>'+data.Name+'</h4><span>'+data.Description+'</span></span></div>' +
                        '</div>' +
                        '<div class="columns large-1 vertical-align float-right height100"><a href="javascript:closeinfobox()" id="search-infobox-close">' +
                            '<svg class="icon close large" style="color: white;"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#svg-close"></use></svg>' +
                        '</a></div>';
                    
                    if (hasNonDefaultColors)
                    {
                        html += '</div>';
                    }

                    $(html).appendTo(infobox);
                    infobox.css('display', 'table');
                }
            }
        })(jQuery);
    }

    function getMapCenter()
    {
        //priority
        if (_currentLocation)
        {
            return toLatLng(_currentLocation);
        }

        if (_linkLocation)
        {
            return toLatLng(_linkLocation);
        }

        if (_queryStrLocation)
        {
            return toLatLng(_queryStrLocation);
        }
        //_default lat long
        return toLatLng(_defaultlat + ','+ _defaultlng);
    }

    function getMapCenterOrg()
    {
        //priority
        if (_currentLocation)
        {
            return _currentLocation;
        }

        if (_linkLocation)
        {
            return _linkLocation;
        }

        if (_queryStrLocation)
        {
            return _queryStrLocation;
        }
        //_default lat long
        return _defaultlat + ','+ _defaultlng;
    }

    function initMap() 
    { 
        initQueryParameters();     
        infoWindow = new google.maps.InfoWindow();
        var latLng = getMapCenter();
        map = new google.maps.Map(document.getElementById('gmap'), {center : latLng, zoom: _zoom, scrollwheel: false});
        addMapListeners();
    };

    function addMapListeners()
    {
        map.addListener('zoom_changed', function() {
			doMapSearch(true);
        });

        map.addListener('dragend', function() {
			doMapSearch(true);
        });
    };

    function getParameterByName(name, url)
    {
        if (!url) {
            url = window.location.href;
        }
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    };

    function toLatLng(latLngString)
    {
        var b = latLngString.split(',');
        if (b.length > 1) {
            return new google.maps.LatLng(b[0].replace(/^\s|\s+$/gm,''), b[1].replace(/^\s|\)+$/gm,''));
        } 
        return '';
    }

    function clearMarkers()
    {
        for (var i = 0; i < markers.length;i++)
        {
            markers[i].setMap(null);
        }
        markers = [];
        mapdata = [];
    }

    function filterschanges()
    {
        doMapSearch();
    }
    
    function doMapSearch(fetchMore) {
        (function($) {
			var o = 0;
            var maxresults = 999;
            if (fetchMore)
            {
                o = mapdata.length;
                maxresults = maxresults - mapdata.length;
            } 

            var searchstr = '' ;
            var filters = '';
            var locationtypes = '';
						
            var $mobilesearch = $('#mobilesearch');
            var $desktopsearch = $('#desktopsearch');

            var $searchcontent = $('#searchcontent');
            var $mobilefilterscontainer = $('#mobilefilterscontainer');
            var $desktopfilterscontainer = $('#desktopfilterscontainer');

            if (Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium'))
            {
                searchstr = $mobilesearch.val();
                $desktopsearch.val(searchstr);
            }
            else
            {
                searchstr = $desktopsearch.val();
                $mobilesearch.val(searchstr);
            }
			if (searchstr == "" || searchstr ==='undefined')
			{
				searchstr = _encodedStr;
			}
			locationtypes = getCheckboxVal(".type-filter:checkbox:checked");
			
			 if (_country == "FI")
			 {
				var nostaFilter = document.getElementById('Nosta');
				var yriFilter = document.getElementById('Yrityspalvelut');
				var lainFilter = document.getElementById('Laina');
				var kassaFilter = document.getElementById('Kassapalvelut');
				var talletaFilter = document.getElementById('Talleta');
				if (nostaFilter.checked)
				{
					locationtypes = locationtypes + (locationtypes === ""? "" : ",") + "{7699B67B-8B90-4830-A262-44088E357403},{7AD9F6CD-7A94-4504-BE67-B665BBEEA7D4}";
				}
				else if (yriFilter.checked)
				{
					locationtypes = locationtypes + (locationtypes === ""? "" : ",") + "{98EB1472-A9A7-4FB4-977E-B015FD6E04DA}";
				}
				else if (lainFilter.checked || kassaFilter.checked)
				{
					locationtypes = locationtypes + (locationtypes === ""? "" : ",") + "{BFD7EBCC-6DB6-49B7-AEAA-992E6A20CC8D},{98EB1472-A9A7-4FB4-977E-B015FD6E04DA}";
				}
				else if (talletaFilter.checked)
				{
					locationtypes = locationtypes + (locationtypes === ""? "" : ",") + "{7AD9F6CD-7A94-4504-BE67-B665BBEEA7D4}";
				}
				else
				{
					if(locationtypes == "")
					{
				    var sstr = $.trim(searchstr).toLowerCase();
					if(sstr === "konttori" || sstr === "konttorit"){
                    if(locationtypes.indexOf("{BFD7EBCC-6DB6-49B7-AEAA-992E6A20CC8D}") === -1){
                        locationtypes = locationtypes + (locationtypes === ""? "" : ",") + "{BFD7EBCC-6DB6-49B7-AEAA-992E6A20CC8D}";
                    }
                    if(locationtypes.indexOf("{98EB1472-A9A7-4FB4-977E-B015FD6E04DA}") === -1){
                        locationtypes = locationtypes + (locationtypes === ""? "" : ",") + "{98EB1472-A9A7-4FB4-977E-B015FD6E04DA}";
                    }
					}
                    }
				}
			 }
            
			// Set values for showlist 
			_selectedFilterValues = locationtypes;
			
			if(_country === "DK") {
                var f1 = $('#\\{FD1C7235-E6E6-45D7-9783-82719222A2D0\\}');
                var f2 = $('#\\{BD817831-9497-430B-8D54-634AB811084B\\}');
                if(locationtypes.indexOf('{7699B67B-8B90-4830-A262-44088E357403}') > -1){
                    f1.attr('checked', false);
                    f2.attr('checked', false);
                    f1.parent().hide();
                    f2.parent().hide();
                }
                else{
                    if(!f1.is(":visible")) f1.parent().show();
                    if(!f2.is(":visible")) f2.parent().show();
                }
            }
			
			
            filters = getCheckboxVal(".whatyouneed:checkbox:checked");
            //locationtypes = getCheckboxVal(".type-filter:checkbox:checked");

            //panToCurrent on initial search         
			
            if ($('#gmap').css('visibility') === 'hidden')
            {
                $('#gmap').css('visibility', 'visible');
            }
            
            var center = getMapCenter();
            
            if (!fetchMore)
            {
                google.maps.event.trigger(map, 'resize');
                map.panTo(center);
            }

            if (_radius == 0)
            {
                google.maps.event.trigger(gmap, 'resize');
                map.setCenter(center);
            }
            
         // version 3.34 had undefined bounds hence added this newbounds calculations
		  getBoundsData(function(newbounds){
			
			var new_radius = getmapradius(newbounds);          
        
					
            if (fetchMore)
            {
                if (new_radius <= _radius)
                {
                    return;
                }
            }
            _radius = new_radius;
            var queryCenter = getMapCenterOrg();

			encodeString(searchstr);
			
			if (_country == "LT")
			{
				var newsearchdataparam = searchdataparam.split('&l');
				searchdataparam = newsearchdataparam[0] + '&l=lt-LT';
            }
			if (_country == "FI")
			{
				var newsearchdataparam = searchdataparam.split('&l');
				searchdataparam = newsearchdataparam[0] + '&l=fi-FI';
            }
			if (_country == "DK")
		    {
				var newsearchdataparam = searchdataparam.split('&l');
				searchdataparam = newsearchdataparam[0] + '&l=da';
            }
			else if (_country == "EE")
			{
				var newsearchdataparam = searchdataparam.split('&l');
				searchdataparam = newsearchdataparam[0] + '&l=et-EE';
				if (_radius <= 1)
				{
					_radius = 40;
				}
            }
			
            var url = mapsearchdataurl + searchdataparam + "&o=" + o + "&m=" + maxresults + "&r=" + _radius + "&q=" + _encodedStr + "&cl=" + queryCenter + "&lt=" + locationtypes + "&f=" + filters;
            var testArray = [];
			
            $.ajax( {
                dataType: "json", 
                url: url,
				beforeSend: function()
				{
					if (!fetchMore)
					{
						$(window).trigger('SHOW_SPINNER');
					}
				},
                success: function (data) 
                { 
					if (!fetchMore)
                    {
                        clearMarkers();
                    } 
                    if (data.length > 0) 
                    {
						if (_country == "FI" && lainFilter.checked)
						{
							for (var i = 0, iLen = data.length; i < iLen; i++) 
							{
								if (data[i].Name != null && data[i].Name == 'Helsinki-Narinkkatori Asuntokauppapiste')
								{
									data.splice(data[i].Name, 1);
									iLen = iLen - 1;
								}
							}
						}
						else if (_country == "FI" && kassaFilter.checked)
						{
							for (var i = 0, iLen = data.length; i < iLen; i++) 
							{
								for (var t = 0, tLen = data[i].Features.length; t < tLen; t++)
								{
									if (data[i].Features[t].Available == true && (data[i].Features[t].Id === 'c8996417-9d1c-48cb-8c95-8322d7058b39' && data[i].Availability.CashServiceHours !== "")) 
									{
										testArray.push(data[i]);
									}
								}
							}
							data = testArray;
						}
						
                        if (fetchMore)
                        {
                            mapdata = mapdata.concat(data);						
							changeTabCounts(mapdata.length); 
                        } 
                        else
                        {
                            mapdata = data;
                            _currentPageIndex = 0;					
							changeTabCounts(mapdata.length);
                        }
                        $('#locationnavi').css('visibility', 'visible');
                        $('#mobileresults').css('visibility', 'visible');

                        _totalPages = Math.ceil( mapdata.length / _prPage );
                  						
                        for (var i=o;i<mapdata.length;i++)
                        {
                            var value = mapdata[i];
							if(_selectedFilterValues=='')
							{
							var locationtypes = gettypes(mapdata[i]);
						    }
							else
							{
							var locationtypes = getselectedtypes(mapdata[i], _selectedFilterValues);
							}                     							
                            var iconsmall = { url: 'data:image/svg+xml;charset=UTF-8,' + encodeURIComponent(createicon(mapdata[i],locationtypes, i+1)), scaledSize: new google.maps.Size(getmarkerwidth(locationtypes, false), getmarkerheight(false)) };
                            var iconlarge = { url: 'data:image/svg+xml;charset=UTF-8,' + encodeURIComponent(createicon(mapdata[i],locationtypes, i+1, true)), scaledSize: new google.maps.Size(getmarkerwidth(locationtypes, true), getmarkerheight(true)) };
                            
                            mapdata[i].iconsmall = iconsmall;
                            mapdata[i].iconlarge = iconlarge;
                            mapdata[i].locationtypes = iconsmall;
                            var pos = new google.maps.LatLng(value.Location["Coordinate.Latitude"], value.Location["Coordinate.Longitude"]);
                            
                            var marker = new google.maps.Marker({
                                position: pos,
                                title: value["Name"],
                                id: value["MapId"],
                                icon: iconsmall,
                                optimized: false,
                                map: map
                            });
                            
                            google.maps.event.addListener(marker, 'mouseover',function () {
                                this.setIcon(getLocationData(this.id).iconlarge);
                            });
                            google.maps.event.addListener(marker, 'mouseout', function() {
                                this.setIcon(getLocationData(this.id).iconsmall);
                            });

                            // Create an onclick event to open an infowindow at each marker.
                            var fn = populateInfoWindow(value["MapId"], pos);
                            google.maps.event.addListener(marker, 'click', fn);
                            // Push the marker to our list of markers.
                            markers.push(marker);
                        }
                        branchnavi(_currentPageIndex, _selectedFilterValues);
                        if (isShowList())
                        {
                            //add all 
                            for (var i = 0;i<mapdata.length;i++)
                            {
                                generateListItem(mapdata[i], "#mobileresults", i + 1, _selectedFilterValues);
                            }
                        }
                        //else
                        //{
							//generateListItem(mapdata[0], "#mobileresults", 1);
                        //}
                        if (mapdata.length == 1)
                        {
                            $('#showlist').css('visibility', 'hidden');
                        }
                        else
                        {
                            $('#showlist').css('visibility', 'visible');
                        }
                    }
                    else
                    {
                        if (!fetchMore)
                        {
                            $('#locationnavi').css('visibility', 'hidden');
                            $('#mobileresults').css('visibility', 'hidden');
							changeTabCounts(mapdata.length);
                        }
                    }
					DB.trackSearch(searchstr, mapdata.length.toString(), "Branch", getBranchFiltersForTracking(_selectedFilterValues, filters));	
                },
                complete: function ()
                {
                    if (!fetchMore)
                    {
                        handleInfoboxEachNewSearch();
						$desktopsearch.val(_encodedStr);
						$mobilesearch.val(_encodedStr);
						var searchstring = '?q=' + _encodedStr; 
						var searchLocation = '&type='+ getbranchtypeselectednames(locationtypes);
						var searchFilter = '&filter='+ getfilterstypeselectednames(filters);
						var searchUrl = searchstring + searchLocation + searchFilter + '#tab2';
						window.history.replaceState(null, document.title, searchUrl);
                        $(window).trigger('HIDE_SPINNER');
                    }
                }
            });

			
		});
			
            function getCheckboxVal(checkbox) 
            {
                var ids = $(checkbox).map(function(){
                    return $(this).val();
                }).get();
                return ids.join(); 
            };

            function populateInfoWindow(mapid, pos) {
                return function(e) {
                    var url = mapinfourl + mapid + searchdataparam;  
                    e.cancelBubble = true;
                    e.returnValue = false;
                    if (e.stopPropagation) {
                        e.stopPropagation();
                        e.preventDefault();
                    }

                    var isMobile = Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium');
                    if (isMobile)  
                    {
                        var value;
                        var index;

                        for (var i=0;i<mapdata.length;i++)
                        {
                            if (mapdata[i].MapId == mapid)
                            {
                                value = mapdata[i];
                                index = i;
                                break;
                            }
                        }
                    
                        mapsmall = new google.maps.Map(document.getElementById('mapsmall'), {center : pos, zoom: _zoomsmall, scrollwheel: false});                
                        var locationtypes = gettypes(value);
                        var iconsmall = { url: 'data:image/svg+xml;charset=UTF-8,' + encodeURIComponent(createicon(value,locationtypes, index+1)), scaledSize: new google.maps.Size(getmarkerwidth(locationtypes, false), getmarkerheight(false)) };

                        var marker = new google.maps.Marker({
                            position: pos,
                            title: value.Name,
                            id: value.MapId,
                            icon: iconsmall,
                            map: mapsmall
                        });

                        //also do something else when clicking on the map, deeplinking ?

                        $.ajax( {
                            dataType: "json", 
                            url: url,
                            success: function (data) { 
								$('#locationdetailscontainerm').empty();
                                var html = formatMobileDetails(data);
                                $('#mobilelocationdetails').slideToggle("slow");
                                $(html).appendTo($('#locationdetailscontainerm'));
                                google.maps.event.trigger(mapsmall, 'resize');
                                mapsmall.setCenter(marker.getPosition())
                            }
                        });
                    } 
                    else
                    {
                        //ajax call
                        $.ajax( {
                            dataType: "json", 
                            url: url,
                            success: function (data) {
                                if (initCustomInfoWindow)
                                {
                                    google.maps.event.addListener(infoWindow, 'domready', function() {
                                        var iwOuter = $('.gm-style-iw');
                                        var gclose = iwOuter.next();
                                        gclose.css('display', 'none');
                                        var iwBackground = iwOuter.prev();
                                        iwBackground.children(':nth-child(2)').css({'display' : 'none'});
                                        iwBackground.children(':nth-child(4)').css({'display' : 'none'});
                                    });
                                    initCustomInfoWindow = false;
                                }
                                infoWindow.setContent(formatMarkerText(data));
                                infoWindow.setPosition(pos);
                                infoWindow.open(map, getMarker(mapid));
                            }
                        });
                    }
                };
            };
        })(jQuery);
    };
	
		function changeTabCounts(count) 
        {
			if (count == null || count === 'undefined')
			{
				count = '0';
			}
			jQuery(document).ready(function($)
			{	
                var textArray = $("#findus span:first")[0].innerText.split('(');
				$("#findus span:first")[0].innerText = textArray[0]+ ' (' + count + ')';
				var privatArray = $("#search-result-count")[0].innerText.split(' ');
				var q = getParameterByName('q');
				if( q === 'undefined' )
				{
					privatArray[3] = _encodedStr;
				}
												
				var totalPrivatHits = DB.Search.Hits;
				var url = window.location.href;
				var tab = url.split('#');	
			//	if (!isFindUsClicked)
			//	{
			//		totalPrivatHits = privatArray[0];
			//	}
			//	else
			//	{
			//		totalPrivatHits = DB.Search.Hits;
			//	}
				
				var totalText = (+count) + (+totalPrivatHits);
				for (i = 1; i < privatArray.length; i++) { 
					totalText += ' ' + privatArray[i];
				}
				$("#search-result-count")[0].innerText = totalText;
				
				var privateTabArray = $("#market span:first")[0].innerText.split('(');
				$("#market span:first")[0].innerText = privateTabArray[0] + ' (' + totalPrivatHits + ')';
			 });
        };
		
		function encodeString(_queryStr)
		{
			if (isIE) 
			{
				_encodedStr = encodeURI(_queryStr);
			}
			else
			{
				_encodedStr = _queryStr;
			}
		};

    function getmapradius(bounds)
    {
	
        var center = getMapCenter();
        var ne = bounds.getNorthEast();

        // r = radius of the earth in km
        var r = 6371.0
        // Convert lat or lng from decimal degrees into radians (divide by 57.2958)
        var lat1 = center.lat() / 57.2958; 
        var lon1 = center.lng() / 57.2958;
        var lat2 = ne.lat() / 57.2958;
        var lon2 = ne.lng() / 57.2958;

        // distance = circle radius from center to Northeast corner of bounds
        var dis = r * Math.acos(Math.sin(lat1) * Math.sin(lat2) + 
        Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1));
        return dis;
				 
    }
	
	function getBoundsData(callback) 
	{
		geocoder = new google.maps.Geocoder();
		if( geocoder )
		{
			geocoder.geocode({ 'address': _encodedStr }, function (results, status)
			{
			 if( status == google.maps.GeocoderStatus.OK )
				{
					var marker = new google.maps.Marker({map: map,position: results[0].geometry.location});
					var bounds = map.getBounds();
					if(bounds)
					 {
						callback(bounds);
					 }
				}
			});
		}
	}
	


    function generateListItem(location, appendTo, number, selectedfilters)
    {
        (function($) {
            var open = "branch-closed-color";
            if (location.Availability.OpenNow) 
            {
                open = "branch-open-color";
            }
		   
            if(selectedfilters=='')
			{
				var types = gettypes(location);
			}
			else
			{
				var types = getselectedtypes(location, selectedfilters);
			} 
            var distance = round(location.AirDistance, 1);
            var center = getMapCenterOrg();
            var parts = center.split(',');
            if (parts.length > 1)
            {
                var clat = parseFloat(parts[0]);
                var clng = parseFloat(parts[1]);
                var cdistance = calcdistance(location.Location["Coordinate.Latitude"], location.Location["Coordinate.Longitude"], clat, clng, 'K');
                distance = round(cdistance, 1);
                distance = (distance.toString()).replace('.', ',');
            }

         //   var openClosedNowTextSpan = _country !== "GB" ? '<span class="branchaddress '+open+' float-left">'+location.Availability.OpenClosedNowText+'</span>' : "";
		 var openClosedNowTextSpan = '<span class="branchaddress '+open+' float-left">'+location.Availability.OpenClosedNowText+'</span>';

            var html = '<a class="mapcard" href="javascript:showlocationdetails('+location.MapId+')"  onmouseout="smallicon('+location.MapId+');" onmouseover="largeicon('+location.MapId+');" aria-haspopup="true">' +
                    '<div class="columns small-3 large-3 numbers"><i class="smallcircle">' + createicon(location, types, number) + '</i></div>' +
                    '<div class="columns small-7 large-7 zeropadding">' +
                        '<span class="branch-text-color">' +
                            '<p class="branchtype truncate">'+getbranchtypenames(types)+'</p>' +
                            '<p class="branchname truncate">'+location.Name+'</p>' +
                            '<p class="branchaddress truncate">'+location.PrimaryAddress.AddressLine+'</p>' +
                            '<p class="branchaddress truncate">'+location.PrimaryAddress.ZipCode + ' ' + location.PrimaryAddress.City + '</p>' +
                            '<p class="branchaddress truncate">' + openClosedNowTextSpan +
                            '<span class="branchaddress distance float-right" style="display: none;">'+distance+' '+ labels.Kilometer +'</span></p>' +
                        '</span>' +
                    '</div>' +
                    '<div class="columns small-2 large-2"><span class="arrow-link"><i class="icon-image xxxsmall"><svg style="fill: #009edd; stroke: #009edd;" xmlns="http://www.w3.org/2000/svg" viewBox="-481 971 16 16"><path d="M-469.3,979l-7.5-7.5 M-469.3,979l-7.5,7.5"></path></svg></i><i class="icon-image"><svg xmlns="http://www.w3.org/2000/svg" viewBox="-481 971 16 16"><path d="M-469.3,979l-7.5-7.5 M-469.3,979l-7.5,7.5"></path></svg></i></span></div>' +
                '</a>'

            $(html).appendTo(appendTo);

            function calcdistance(lat1, lon1, lat2, lon2, unit) {
                var radlat1 = Math.PI * lat1/180
                var radlat2 = Math.PI * lat2/180
                var radlon1 = Math.PI * lon1/180
                var radlon2 = Math.PI * lon2/180
                var theta = lon1-lon2
                var radtheta = Math.PI * theta/180
                var dist = Math.sin(radlat1) * Math.sin(radlat2) + Math.cos(radlat1) * Math.cos(radlat2) * Math.cos(radtheta);
                dist = Math.acos(dist)
                dist = dist * 180/Math.PI
                dist = dist * 60 * 1.1515
                if (unit=="K") { dist = dist * 1.609344 }
                if (unit=="N") { dist = dist * 0.8684 }
                return dist
            }
        })(jQuery);
    };

    function closeMobileLocationDetails()
    {
        (function($) {
            $('#mobilelocationdetails').slideToggle("slow");
        })(jQuery);
    }

    function closeinfobox()
    {
        var inf = document.getElementById("search-infobox");
        if (inf)
        {
            inf.style.display = 'none';
        }
    }

    function closeinfowindow()
    {
        infoWindow.close();
    }

function formatMobileDetails(data)
    {
        var lt = gettypes(data[0]);

        var branch = getLocationTypeName(lt, "{BFD7EBCC-6DB6-49B7-AEAA-992E6A20CC8D}");
        if (!branch)
        {
            branch = getLocationTypeName(lt, "{98EB1472-A9A7-4FB4-977E-B015FD6E04DA}");
        }
        var atm = getLocationTypeName(lt, "{7699B67B-8B90-4830-A262-44088E357403}");
        var nightsafe = getLocationTypeName(lt, "{7AD9F6CD-7A94-4504-BE67-B665BBEEA7D4}");
        var postaloffice = getLocationTypeName(lt, "{38490EBE-6A20-4036-9A26-5CB388679521}");

        //find types in data
        var branchObj;
        var atmObj;
        var nightsafeObj;
        for (var i = 0;i<data.length;i++)
        {
            var obj = data[i];
            if ((!branchObj && branch) || postaloffice)
            {
                if (obj.Type === 'PersonalAndBusinessBranch' || obj.Type === 'PrivateBranch' || obj.Type === 'BusinessBranch' || obj.Type === 'PostalOffice')
                {
                    branchObj = obj;
                }
            }
            if (!atmObj && atm)
            {
                if (obj.Type === 'Atm' || obj.Type === 'Adtm' || obj.Type === 'Adm')
                {
                    atmObj = obj;
                }
            }
            if (!nightsafeObj && nightsafe)
            {
                if (obj.Type === 'NightSafe')
                {
                    nightsafeObj = obj;
                }
            }
        }

        var openinghours = '';
        var closingDays = '';
        if (data[0].Availability.HasOpeningHours && branchObj)
        {
            openinghours = labels.OpeningHours;
        }
		if (data[0].Availability.ClosingDays && branchObj)
        {
            closingDays = labels.ClosingDays;
        }

        var naviindex = 0;
        var first = ' is-active';

        var close = labels.Close;
        if (!close)
        {
            close = 'Luk';
            if (_country == "NO")
            {
                close = "Lukk";
            }
            if (_country == "SE")
            {
                close = "St�ng";
            }
            if (_country == "FI")
            {
                close = "Sulje";
            }
        }

        var str = '<div class="details-address details-background">' +
              '<div class="row">' +
                '<div class="branch-text-color float-left"> <span class="details-branchname">'+data[0].Name+'</span>' +
                  '<p class="branchaddress">'+data[0].PrimaryAddress.AddressLine+'<br>'+data[0].PrimaryAddress.ZipCode + ' ' + data[0].PrimaryAddress.City +'</p>' +
                '</div><a href="javascript:closeMobileLocationDetails()" aria-label="Close" class="close close-reveal float-right"><span class="mobile-close">'+close+'</span>' +
                      '<svg class="icon close xxxsmall">' +
                        '<use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#svg-close"></use>' +
                      '</svg></a>' +
              '</div>' +
            '</div>' +
            '<div class="tabscontainer">' +               
              '<div class="tabs-wrapper details-background search-box-shadow">' +
                '<ul data-tabs="fidsk4-tabs" id="location-details" role="tablist" class="map-details-tab tabs">'; 
        if (branch)
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+branch+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (postaloffice)
        {
			if (_country == "LT" && postaloffice == 'Private')
			{
				postaloffice = 'Cash in/out ATM' + "'"+ 's';
			}
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+postaloffice+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (atm)
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+atm+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (nightsafe)
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+nightsafe+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (openinghours && _country !== "FI")
        {
				str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+openinghours+'</span></a></li>';
				first = '';
				naviindex++;
        }     
        if (closingDays && _country == "GB")
        {
				str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+labels.ClosingDays+'</span></a></li>';
				first = '';
				naviindex++;
        } 		
                 
        str += '</ul>' +
              '</div>' +
            '</div>' +
            '<div class="row details-background search-box-shadow">' +
              '<div class="search-box-shadow">' +
                '<div data-tabs-content="location-details" style="border: 0;" class="tabs-content background-color-white zeropadding">';
        var naviindex = 0;
        var first = ' is-active';                
        if (branchObj)
        {
            currency = getCurrency(branchObj);
            locationfeatures = getFeatures(branchObj);
			
			if (_country == "FI" && branchObj.Name == "Helsinki-Narinkkatori Asuntokauppapiste")
			{
				locationfeatures = "Asuntokaupat<br>";
			}
			else if (_country == "FI" && locationfeatures.indexOf('Laina- ja sijoituspalvelut<br>') <= -1)
			{
				locationfeatures = "Laina- ja sijoituspalvelut<br>" + locationfeatures;
			}
			if (_country == "FI" && locationfeatures.indexOf('Nosta käteistä<br>') >= 0){
				var replaced = locationfeatures.replace("Nosta käteistä<br>","");
				locationfeatures = replaced;
			}
			
            open = getOpenClosed(branchObj);
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="false" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">';
            str += '<div class="details-address search-box-shadow">';
            if (branchObj.PhoneNumber)
            {            
                str += '<span class="phone light-blue-color">'+ labels.Phone + ' ' + branchObj.PhoneNumber + '</span>';
            }
			if (!_country == "FI")
			{
				str += open;
			}
            if (branchObj.OperationalMessage && _country !== "LT" && _country !== "NO")
            {
					str += '<p class="details branch-text-color">'+branchObj.OperationalMessage+'</p>';
            }
			
			if (branchObj.Availability.OfficeServiceHours && _country == "FI")
            {
				var serviceHoursText = branchObj.Availability.OfficeServiceHours;
				var splitedText = serviceHoursText.split('/n');
				var newServiceHoursText = '';
				
				for (var i = 0; i < splitedText.length; i++)
				{
				  newServiceHoursText = newServiceHoursText + splitedText[i] + '</br>';
				}
				newServiceHoursText = '</br>' +newServiceHoursText;

				str += '<p class="details branch-text-color">'+newServiceHoursText+'</p>';
            }
			
            str += '<br></div>';
            
            str += '<div class="details-address">' + 
                            '<div class="small-6 float-left">' +
                                '<h5>'+labels.HereYouCan+'</h5>' +
                                '<p>' +locationfeatures+ '</p>' +
                            '</div>' +
                            '<div class="small-6 float-left">';
                
            str += '</div>' +
                    
                    '</div>' +
                '</section>';
            first = '';
            naviindex++;
        }

        if (atmObj)
        {
            currency = getCurrency(atmObj);
            locationfeatures = getFeatures(atmObj);
            
            if(_country == "DK" && locationfeatures.indexOf('Betale en regning<br>') >= 0){
                var replaced = locationfeatures.replace("Betale en regning<br>","");
				locationfeatures = replaced;
            }
            
			if(_country == "FI" && locationfeatures.indexOf('Kassapalvelut<br>') >= 0){
				var replaced = locationfeatures.replace("Kassapalvelut<br>","");
				locationfeatures = replaced;
			}
			
            open = getOpenClosed(atmObj);
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="'+(first === '' ? 'true' : 'false')+'" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">';
            str += '<div class="details-address search-box-shadow">';
            if (atmObj.AtmOpen24Hours)
            {
                str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';
            }            

			if (_country !== "LT")
			{
				if (atmObj.OperationalMessage)
				{
					str += '<p class="details branch-text-color">'+atmObj.OperationalMessage+'</p>';
				}
			}            
            str += '<br></div>';
            
            str += '<div class="details-background details-address">' +
                            '<div class="small-6 float-left">' +
                                '<h5>'+labels.HereYouCan+'</h5>' +
                                '<p>' +locationfeatures+ '</p>' +
                            '</div>' +
                            '<div class="small-6 float-left">';
            if (currency && _country !== "FI")
            {
               str += '<h5>'+labels.Currency+'</h5><p>'+currency+'</p>';
            }                 
            str += '</div>' +
                    '</div>' +
                '</section>';                        
     
            first = '';
            naviindex++;
        }
        if (nightsafeObj)
        {
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="'+(first === '' ? 'true' : 'false')+'" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">';
            str += '<div class="details-address search-box-shadow">';                    
            str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';

            if (nightsafeObj.OperationalMessage)
            {
                str += '<p class="details branch-text-color">'+nightsafeObj.OperationalMessage+'</p>';
            }        
            str += '<br></div>';
            str += '<div class="details-address">' +
                            '<div class="small-6 float-left">' +
                                '<h5>'+labels.HereYouCan+'</h5>' +
                                '<p>' +locationfeatures+ '</p>' +
                            '</div>' +
                            '<div class="small-6 float-left">';
            if (currency)
            {
               str += '<h5>'+labels.Currency+'</h5><p>'+currency+'</p>';
            }                 
            str += '</div>' +
                    '</div>' +
                '</section>';                        
            first = '';
            naviindex++;
        }
        if (openinghours)
        {
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="true" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                     '<div class="details-address search-box-shadow">' +  
                        '<table class="openinghours">';
					if(_country === "NO")
					{
						str +='<tbody><tr><th>'+openinghours+' for drop-in:</th>';
					}
					else
					{
					    str +='<tbody><tr><th>'+openinghours+'</th>';
					}
            if (branchObj.Availability.MondayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Monday+'</td>'+
                        '<td>'+branchObj.Availability.MondayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.TuesdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Tuesday+'</td>'+
                        '<td>'+branchObj.Availability.TuesdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.WednesdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Wednesday+'</td>'+
                        '<td>'+branchObj.Availability.WednesdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.ThursdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Thursday+'</td>'+
                        '<td>'+branchObj.Availability.ThursdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.FridayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Friday+'</td>'+
                        '<td>'+branchObj.Availability.FridayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.SaturdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Saturday+'</td>'+
                        '<td>'+branchObj.Availability.SaturdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.SundayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Sunday+'</td>'+
                        '<td>'+branchObj.Availability.SundayHours+'</td>'+
                    '</tr>';
            }
            str += '<tr>'+
                            '<td>&nbsp;</td>'+
                            '<td>&nbsp;</td>'+
                        '</tr>';
            if (branchObj.Availability.ClosingDays && _country !== "GB")
            {				
				str += '<tr><th>'+labels.ClosingDays+'</th>';
				var c = branchObj.Availability.ClosingDays.split(',');
                for (var k = 0; k<c.length;k++)
                {
                    var t = c[k].split(':');
                    str += '</tr><tr><td>'+t[0]+'</td>';
                    if (t.length > 1)
                    {
                        str += '<td>'+t[1]+'</td>';
                    }
                    str += '</tr>';
                }
            }

            if (branchObj.Availability.MondayLunchBreak ||
                branchObj.Availability.TuesdayLunchBreak ||
                branchObj.Availability.WednesdayLunchBreak ||
                branchObj.Availability.ThursdayLunchBreak ||
                branchObj.Availability.FridayLunchBreak ||
                branchObj.Availability.SaturdayLunchBreak ||
                branchObj.Availability.SundayLunchBreak)
            {
                str += '<tr><th>'+branchObj.Availability.LunchBreakLabel+'</th><tr>';
                if(branchObj.Availability.MondayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Monday+'</td>';
                    str += '<td>'+branchObj.Availability.MondayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.TuesdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Tuesday+'</td>';
                    str += '<td>'+branchObj.Availability.TuesdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.WednesdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Wednesday+'</td>';
                    str += '<td>'+branchObj.Availability.WednesdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.ThursdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Thursday+'</td>';
                    str += '<td>'+branchObj.Availability.ThursdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.FridayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Friday+'</td>';
                    str += '<td>'+branchObj.Availability.FridayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.SaturdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Saturday+'</td>';
                    str += '<td>'+branchObj.Availability.SaturdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.SundayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Sunday+'</td>';
                    str += '<td>'+branchObj.Availability.SundayLunchBreak+'</td>';
                    str += '</tr>';
                }
            }


            str += '</tbody></table>';
			if (branchObj.OperationalMessage && _country === "NO")
            {
				str += '<p class="details branch-text-color">'+branchObj.OperationalMessage+'</p>';
			//	str +='<br><a href="https://danskebank.no/privat/bestill-moete" class="button" style="margin-left:109px" target="_blank">Avtal møte</a></br>';
				
            }
            if(branchObj && branchObj.OperationalMessage && _country === "GB"){
                str += '<br><p class="details branch-text-color">'+branchObj.OperationalMessage+'</p>';
            }
            str += '<br></div>';

            if (atmObj)
            {
				open = getOpenClosed(atmObj);
                if (atmObj.AtmOpen24Hours || open)
                {
                    str += '<div class="details-background details-address">' +
                        '<div class="small-12 float-left">';

                    str += '<h6 class="branch-text-color">'+labels.CashMachine+'</h6>';
                    if (atmObj.AtmOpen24Hours)
                    {
                        str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';
                    }
                    else
                    {
                        str += open;
                    }
                    str += '</div>' +
                    '</div>';
                }
            }  
            str += '</section>';    

            first = '';
            naviindex++;
        }
		if (branchObj)
        {
		if (branchObj.Availability.ClosingDays && _country == "GB")
            {				
				str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="true" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                       '<div class="details-address search-box-shadow">' +  
                        '<table class="openinghours"><tbody>'+
						'<tr><th>'+labels.ClosingDays+'</th>';
				
				var c = branchObj.Availability.ClosingDays.split(',');
                for (var k = 0; k<c.length;k++)
                {
                    var t = c[k].split(':');
                    str += '</tr><tr><td>'+t[0]+'</td>';
                    if (t.length > 1)
                    {
                        str += '<td>'+t[1]+'</td>';
                    }
                    str += '</tr>';
                }
				str += '</tbody></table>' + 
				'</div>'+
				'<div class="details-background details-address">' +
                        '<div class="small-12 float-left">';
				if (branchObj)
                {
					open = getOpenClosed(branchObj);
                    if (open)
                    {
                        str += '<h6 class="branch-text-color">'+branch+'</h6>' + open;
                    }
                } 
				if (atmObj)
				{
					open = getOpenClosed(atmObj);
					if (atmObj.AtmOpen24Hours || open)
					{
						str += '<h6 class="branch-text-color">'+labels.CashMachine+'</h6>';
						if (atmObj.AtmOpen24Hours)
						{
							str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';
						}
						else
						{
							str += open;
						}
					}
				}  
				str += '</div>' +
					'</div>' +
				 '</section>';
				first = '';
                naviindex++;
            }
		}

        str += '</div>' +
              '</div>' +
            '</div>';
                  
        return str;          
    }

    function formatMarkerText(data)
    {
        var lt = gettypes(data[0]);

        var branch = getLocationTypeName(lt, "{BFD7EBCC-6DB6-49B7-AEAA-992E6A20CC8D}");
        if (!branch)
        {
            branch = getLocationTypeName(lt, "{98EB1472-A9A7-4FB4-977E-B015FD6E04DA}");
        }

        var atm = getLocationTypeName(lt, "{7699B67B-8B90-4830-A262-44088E357403}");
        var nightsafe = getLocationTypeName(lt, "{7AD9F6CD-7A94-4504-BE67-B665BBEEA7D4}");
        var postaloffice = getLocationTypeName(lt, "{38490EBE-6A20-4036-9A26-5CB388679521}");

        //find types in data
        var branchObj;
        var atmObj;
        var nightsafeObj;
        for (var i = 0;i<data.length;i++)
        {
            var obj = data[i];
            if ((!branchObj && branch) || postaloffice)
            {
                if (obj.Type === 'PersonalAndBusinessBranch' || obj.Type === 'PrivateBranch' || obj.Type === 'BusinessBranch' || obj.Type === 'PostalOffice')
                {
                    branchObj = obj;
                }
            }
            if (!atmObj && atm)
            {
                if (obj.Type === 'Atm' || obj.Type === 'Adtm' || obj.Type === 'Adm')
                {
                    atmObj = obj;
                }
            }
            if (!nightsafeObj && nightsafe)
            {
                if (obj.Type === 'NightSafe')
                {
                    nightsafeObj = obj;
                }
            }
        }

        var openinghours = '';
		var closingDays = '';
        if (data[0].Availability.HasOpeningHours && branchObj)
        {
            openinghours = labels.OpeningHours;
        }
        if (data[0].Availability.ClosingDays && branchObj)
        {
            closingDays = labels.ClosingDays;
        }
        var str = '<div class="small-12">' +
            '<div class="tabscontainer">'+               
            '<div class="tabs-wrapper details-background search-box-shadow">'+
                '<ul data-tabs="bwqcz6-tabs" id="location-details" role="tablist" class="map-details-tab withclose">';
        var naviindex = 0;
        var first = ' is-active';
        if (branch)
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+branch+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (postaloffice)
        {
			if (_country == "LT" && postaloffice == 'Private')
			{
				postaloffice = 'Cash in/out ATM' + "'"+ 's';
			}
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+postaloffice+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (atm)
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+atm+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (nightsafe)
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+nightsafe+'</span></a></li>';
            first = '';
            naviindex++;
        }
        if (openinghours && _country !== "FI")
        {
            str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+openinghours+'</span></a></li>';
            first = '';
            naviindex++;
        }
		if (closingDays && _country == "GB")
        {
				str += '<li role="presentation" class="gmaps-title tabs-title'+first+'"><a href="javascript:navidetails('+naviindex+')" role="tab" tabindex="0" aria-selected="true" aria-controls="tab'+(naviindex + 1)+'" id="tab'+(naviindex + 1)+'-label"><span>'+labels.ClosingDays+'</span></a></li>';
				first = '';
				naviindex++;
        } 	

        str += '</ul><a onclick="closeinfowindow()" aria-label="Close" class="close close-reveal float-right mapcorner"><svg class="icon close xxxsmall"><use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#svg-close"></use></svg></a>'+
            '</div>'+
            '<div class="details-background">'+
                '<div data-tabs-content="location-details" data-equalizer="details" style="border: 0;" class="tabs-content background-color-white zeropadding" data-resize="details" data-mutate="details" data-events="mutate">';
        naviindex = 0;                
        first = ' is-active';

        var currency = '';
        var locationfeatures = '';
        var open = '';

        if (branchObj)
        {
            currency = getCurrency(branchObj);
            locationfeatures = getFeatures(branchObj);
			
			//Specific Finland case
			if (_country == "FI" && branchObj.Name == "Helsinki-Narinkkatori Asuntokauppapiste")
			{
				locationfeatures = "Asuntokaupat<br>";
			}
			else if (_country == "FI" && locationfeatures.indexOf('Laina- ja sijoituspalvelut<br>') <= -1)
			{
				locationfeatures = "Laina- ja sijoituspalvelut<br>" + locationfeatures;
			}
			if (_country == "FI" && locationfeatures.indexOf('Nosta käteistä<br>') >= 0){
				var replaced = locationfeatures.replace("Nosta käteistä<br>","");
				locationfeatures = replaced;
			}
			if (_country == "FI" && branchObj.Name == "Helsinki-Kassapalvelut")
			{
				locationfeatures = "Kassapalvelut<br>";
			}			
            open = getOpenClosed(branchObj);
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="false" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                    '<div class="row">'+
                    '<div data-equalizer-watch="details" class="columns small-8 branch-text-color search-box-shadow-vertical map-details" style="height: 300.375px;"><span class="details-branchname">'+branchObj.Name+'</span>'+
                        '<p class="branchaddress branch-text-color">'+branchObj.PrimaryAddress.AddressLine+'<br>'+branchObj.PrimaryAddress.ZipCode + ' ' + branchObj.PrimaryAddress.City +'</p>';
            if (branchObj.PhoneNumber)
            {            
                str += '<p class="branchaddress branch-text-color">'+ labels.Phone + ' ' +branchObj.PhoneNumber + '</p>';
            }
			
			if (!_country == "FI")
			{
				str += open;
			}
			
            if (branchObj.OperationalMessage && _country !== "LT" && _country !== "NO")
            {
				str += '<p class="details branch-text-color">'+branchObj.OperationalMessage+'</p>';
            }
			
			if (branchObj.Availability.OfficeServiceHours && _country == "FI")
            {
                var CashServiceHours = branchObj.Availability.CashServiceHours;
				var serviceHoursText = branchObj.Availability.OfficeServiceHours;
				var splitedText = serviceHoursText.split('/n');
				var newServiceHoursText = '';
				
				for (var i = 0; i < splitedText.length; i++)
				{
				  newServiceHoursText = newServiceHoursText + splitedText[i] + '</br>';
				}
				newServiceHoursText = '</br>' +newServiceHoursText;
                
                if(CashServiceHours)
                {
                    newServiceHoursText = "<br>Kassapalvelut avoinna<br>"+ CashServiceHours + "<br>" + newServiceHoursText;
                }
				str += '<p class="details branch-text-color">'+newServiceHoursText+'</p>';
            }

            var LabelHereYouCan = !(_country == "LT" && _htmlLang == "en" || _country == "LT" && _htmlLang == "lt") ? labels.HereYouCan : "";
			
			if(_country === 'EE'){
				LabelHereYouCan = '';
			}
			
            str += '</div>'+
                    '<div data-equalizer-watch="details" class="columns small-4 details-right">';
				
				str += '<h6 class="branch-text-color">'+LabelHereYouCan+'</h6>'+
                        '<p class="details branch-text-color">' +locationfeatures+ '</p>'+
                    '</div>'+
                    '</div>'+
                '</section>';
            first = '';
            naviindex++;
        }
        if (atmObj)
        {
            currency = getCurrency(atmObj);
            locationfeatures = getFeatures(atmObj);

            if(_country == "DK" && locationfeatures.indexOf('Betale en regning<br>') >= 0){
                var replaced = locationfeatures.replace("Betale en regning<br>","");
				locationfeatures = replaced;
            }
			
			if(_country == "FI" && locationfeatures.indexOf('Kassapalvelut<br>') >= 0){
				var replaced = locationfeatures.replace("Kassapalvelut<br>","");
				locationfeatures = replaced;
			}
									
            open = getOpenClosed(atmObj);
			
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="'+(first === '' ? 'true' : 'false')+'" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                    '<div class="row">'+
                    '<div data-equalizer-watch="details" class="columns small-8 branch-text-color search-box-shadow-vertical map-details" style="height: 300.375px;"><span class="details-branchname">'+atmObj.Name+'</span>'+
                        '<p class="branchaddress branch-text-color">'+atmObj.PrimaryAddress.AddressLine+'<br>'+atmObj.PrimaryAddress.ZipCode + ' ' + atmObj.PrimaryAddress.City +'</p>';
            if (atmObj.AtmOpen24Hours)
            {
                str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';
            }

			if (atmObj.OperationalMessage && _country === "GB")
            {
				str += '<p class="details branch-text-color">'+atmObj.OperationalMessage+'</p>';
				
            }            
                        
            str += '</div>'+
                    '<div data-equalizer-watch="details" class="columns small-4 details-right" style="height: 272.375px;">';
            
			if (currency && (_country !== "FI" && _country !== "LT"))
            {
                str += '<h6 class="branch-text-color">'+labels.Currency+'</h6>';
                str += '<p class="details branch-text-color">'+currency+'</p>'; 
            }
			
			if (_country !== "LT")
			{
            str += '<h6 class="branch-text-color">'+labels.HereYouCan+'</h6>'+
                        '<p class="details branch-text-color">' +locationfeatures+ '</p>'+        
                    '</div>'+
                    '</div>'+
                '</section>';
			}
			else
			{
				str += '</div>'+
                    '</div>'+
                '</section>';
			}
            first = '';
            naviindex++;
        }
		
        if (nightsafeObj)
        {
            str +=  '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="'+(first === '' ? 'true' : 'false')+'" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                    '<div class="row">'+
                    '<div data-equalizer-watch="details" class="columns small-8 branch-text-color search-box-shadow-vertical map-details" style="height: 300.375px;"><span class="details-branchname">'+nightsafeObj.Name+'</span>'+
                        '<p class="branchaddress branch-text-color">'+nightsafeObj.PrimaryAddress.AddressLine+'<br>'+nightsafeObj.PrimaryAddress.ZipCode + ' ' + nightsafeObj.PrimaryAddress.City +'</p>'+
                        '<p class="branch-open-color bold">'+labels.Open247+'</p>'+
                    '</div>'+
                    '<div data-equalizer-watch="details" class="columns small-4 details-right" style="height: 272.375px;">';
					
					//FI Specific case
					if (_country == "FI")
					{
						str += '<h6 class="branch-text-color">'+labels.HereYouCan+'</h6>'+
                       '<p class="details branch-text-color">' + 'Nosta k&#228;teist&#228;<br>Talleta k&#228;teist&#228;<br>' + '</p>'; 
					}
					
            str += '</div>'+
                '</div>'+
            '</section>';
            first = '';
            naviindex++;
        }
		
        if (openinghours)
        {
            str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="true" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                    '<div class="row">'+
                    '<div data-equalizer-watch="details" class="columns small-8 branch-text-color search-box-shadow-vertical map-details" style="height: 300.375px;">'+
                        '<table class="openinghours">';
					if(_country === "NO")
					{
						str +='<tbody><tr><th>'+openinghours+' for drop-in:</th>';
					}
					else
					{
					    str +='<tbody><tr><th>'+openinghours+'</th>';
					}					
            if (branchObj.Availability.MondayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Monday+'</td>'+
                        '<td>'+branchObj.Availability.MondayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.TuesdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Tuesday+'</td>'+
                        '<td>'+branchObj.Availability.TuesdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.WednesdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Wednesday+'</td>'+
                        '<td>'+branchObj.Availability.WednesdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.ThursdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Thursday+'</td>'+
                        '<td>'+branchObj.Availability.ThursdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.FridayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Friday+'</td>'+
                        '<td>'+branchObj.Availability.FridayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.SaturdayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Saturday+'</td>'+
                        '<td>'+branchObj.Availability.SaturdayHours+'</td>'+
                    '</tr>';
            }
            if (branchObj.Availability.SundayHours)
            {
                str += '</tr><tr>'+
                        '<td>'+branchObj.Availability.Sunday+'</td>'+
                        '<td>'+branchObj.Availability.SundayHours+'</td>'+
                    '</tr>';
            }
            str += '<tr>'+
                            '<td>&nbsp;</td>'+
                            '<td>&nbsp;</td>'+
                        '</tr>';
            if (branchObj.Availability.ClosingDays && _country !== "GB")
            {
                str += '<tr><th>'+labels.ClosingDays+'</th>';
                var c = branchObj.Availability.ClosingDays.split(',');

                for (var k = 0; k<c.length;k++)
                {
                    var t = c[k].split(':');
                    str += '</tr><tr><td>'+t[0]+'</td>';
                    if (t.length > 1)
                    {
                        str += '<td>'+t[1]+'</td>';
                    }
                    str += '</tr>';
                }
            }

            if (branchObj.Availability.MondayLunchBreak ||
                branchObj.Availability.TuesdayLunchBreak ||
                branchObj.Availability.WednesdayLunchBreak ||
                branchObj.Availability.ThursdayLunchBreak ||
                branchObj.Availability.FridayLunchBreak ||
                branchObj.Availability.SaturdayLunchBreak ||
                branchObj.Availability.SundayLunchBreak)
            {
                str += '<tr><th>'+branchObj.Availability.LunchBreakLabel+'</th><tr>';
                if(branchObj.Availability.MondayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Monday+'</td>';
                    str += '<td>'+branchObj.Availability.MondayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.TuesdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Tuesday+'</td>';
                    str += '<td>'+branchObj.Availability.TuesdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.WednesdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Wednesday+'</td>';
                    str += '<td>'+branchObj.Availability.WednesdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.ThursdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Thursday+'</td>';
                    str += '<td>'+branchObj.Availability.ThursdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.FridayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Friday+'</td>';
                    str += '<td>'+branchObj.Availability.FridayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.SaturdayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Saturday+'</td>';
                    str += '<td>'+branchObj.Availability.SaturdayLunchBreak+'</td>';
                    str += '</tr>';
                }
                if(branchObj.Availability.SundayLunchBreak){
                    str += '<tr>';
                    str += '<td>'+branchObj.Availability.Sunday+'</td>';
                    str += '<td>'+branchObj.Availability.SundayLunchBreak+'</td>';
                    str += '</tr>';
                }
            }

            str += '</tbody></table>';
			if (branchObj.OperationalMessage && _country === "NO")
            {
				str += '<p class="details branch-text-color">'+branchObj.OperationalMessage+'</p>';
			//	str +='<br><a href="https://danskebank.no/privat/bestill-moete" class="button" style="margin-left:88px" target="_blank">Avtal møte</a></br>';
				
            }
            if (branchObj.OperationalMessage && _country === "GB")
            {
				str += '<p class="details branch-text-color">'+branchObj.OperationalMessage+'</p>';
				
            }
                str += '</div>'+
                    '<div data-equalizer-watch="details" class="columns small-4 details-right" style="height: 272.375px;">';
                if (atmObj)
                {
                    if (atmObj.AtmOpen24Hours || open)
                    {
                        str += '<h6 class="branch-text-color">'+labels.CashMachine+'</h6>';
                        if (atmObj.AtmOpen24Hours)
                        {
                            str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';
                        }
                        else
                        {
                            str += open;
                        }
                    }
                }          
                str += '</div>'+
                    '</div>'+
                '</section>';
            first = '';
            naviindex++;
        }
		if (branchObj)
        {
		if (branchObj.Availability.ClosingDays && _country == "GB")
            {		
             str += '<section id="tab'+(naviindex+1)+'" role="tabpanel" aria-hidden="true" class="gmaps-panel tabs-panel zeropadding'+first+'" aria-labelledby="tab'+(naviindex+1)+'-label">'+
                    '<div class="row">'+
                    '<div data-equalizer-watch="details" class="columns small-8 branch-text-color search-box-shadow-vertical map-details" style="height: 300.375px;">'+
                        '<table class="openinghours">'+
                        '<tbody><tr><th>'+labels.ClosingDays+'</th>';		
				
				var c = branchObj.Availability.ClosingDays.split(',');
                for (var k = 0; k<c.length;k++)
                {
                    var t = c[k].split(':');
                    str += '</tr><tr><td>'+t[0]+'</td>';
                    if (t.length > 1)
                    {
                        str += '<td>'+t[1]+'</td>';
                    }
                    str += '</tr>';
                }
				str += '</tbody></table>';
				
				 str += '</div>'+
				 '<div data-equalizer-watch="details" class="columns small-4 details-right" style="height: 272.375px;">';
				 
                if (branchObj)
                {
					open = getOpenClosed(branchObj);
                    if (open)
                    {
                        str += '<h6 class="branch-text-color">'+branch+'</h6>' + open;
                    }
                }   
                if (atmObj)
                {
					open = getOpenClosed(atmObj);
                    if (atmObj.AtmOpen24Hours || open)
                    {
                        str += '<h6 class="branch-text-color">'+labels.CashMachine+'</h6>';
                        if (atmObj.AtmOpen24Hours)
                        {
                            str += '<p class="branch-open-color bold">'+labels.Open247+'</p>';
                        }
                        else
                        {
                            str += open;
                        }
                    }
                } 				
				 '</div>'+
				'</div>'+
				'</section>';
				first = '';
                naviindex++;
            }
		}
			
        str += '</div>'+
            '</div>'+
            '</div>'+
        '</div>';
        return str;
    }

    function getFeatures(data)
    {
        var locationfeatures = '';
        for (var j=0;j<data.Features.length;j++)
        {
            if (data.Features[j].Available)
            {
                if (data.Features[j].ParentId === "")
                {
                    if (data.Features[j].HereYouCan === "" || data.Features[j].Id === "c8996417-9d1c-48cb-8c95-8322d7058b39")
                    {
                        locationfeatures += data.Features[j].Name;  
                    }
                    else
                    {
                        locationfeatures += data.Features[j].HereYouCan;
                    }
                    locationfeatures += '<br>';
                }
            }
        }
        if(_country === "FI"){
            locationfeatures = rearrangeFeaturesFI(locationfeatures);
        }
        return locationfeatures;
    }

    function rearrangeFeaturesFI(locationfeatures){
        oldFeatureList = locationfeatures.split('<br>');
        newFeatureList = [];
        
        var f = oldFeatureList.indexOf("Laina- ja sijoituspalvelut");
        if(f > -1){
            newFeatureList.push(oldFeatureList[f]);
            oldFeatureList.slice(f,1);
        }
        f = oldFeatureList.indexOf("Nosta käteistä");
        if(f > -1){
            newFeatureList.push(oldFeatureList[f]);
            oldFeatureList.slice(f,1);
        }
        f = oldFeatureList.indexOf("Talleta käteistä");
        if(f > -1){
            newFeatureList.push(oldFeatureList[f]);
            oldFeatureList.slice(f,1);
        }
        f = oldFeatureList.indexOf("Kassapalvelut");
        if(f > -1){
            newFeatureList.push(oldFeatureList[f]);
            oldFeatureList.slice(f,1);
        }
        f = oldFeatureList.indexOf("Yrityspalvelut");
        if(f > -1){
            newFeatureList.push(oldFeatureList[f]);
            oldFeatureList.slice(f,1);
        }

        newFeatureList.concat(oldFeatureList);
        return newFeatureList.join('<br>');
    }

    function getCurrency(data)
    {
        var currency = '';
        for (var j=0;j<data.Features.length;j++)
        {
            if (data.Features[j].Available)
            {
                if (data.Features[j].ParentId === "c8996417-9d1c-48cb-8c95-8322d7058b39" && data.Type !== 'PostalOffice')
                {
                    currency += data.Features[j].Name + '<br>';
                }
            }
        }
        return currency;
    }

    function getOpenClosed(data)
    {
        var open = '';
        if (data.Availability.OpenNow)
        {
            open += '<p class="branch-open-color bold">'+data.Availability.OpenClosedNowText+'</p>';
        } 
        else
        {
            if (data.Availability.OpenClosedNowText)
            {
                open += '<p class="branch-closed-color bold">'+data.Availability.OpenClosedNowText+'</p>';
            }
        }
        return open;
    }

    function getLocationTypeName(a, obj) {
        for (var i = 0; i < a.length; i++) {
            if (a[i].Id === obj) {
                for (var k=0;k<labels.Types.length;k++)
                {
                    if (labels.Types[k].Id === obj)
                    {
                        return labels.Types[k].Name;
                    }
                }
            }
        }
    }

    function navidetails(tabIndex) 
    {
        (function($) {
            var $tabsDesktop = $('.gmaps-title');
            var $panelsDesktop = $('.gmaps-panel');
            
            if (tabIndex >= 0) {
                $tabsDesktop.removeClass('is-active');
                $($tabsDesktop[tabIndex]).addClass('is-active');

                $($panelsDesktop).removeClass('is-active');
                $($panelsDesktop).attr('aria-hidden', 'true');
                $($panelsDesktop[tabIndex]).attr('aria-hidden', 'false');
                $($panelsDesktop[tabIndex]).addClass('is-active');
            }
        })(jQuery);
    }

    function showlocationdetails(id) 
    {
        (function($) {
            var value;
            var index;

            for (var i=0;i<mapdata.length;i++)
            {
                if (mapdata[i].MapId == id)
                {
                    value = mapdata[i];
                    index = i;
                    break;
                }
            }

            var pos = new google.maps.LatLng(value.Location["Coordinate.Latitude"],value.Location["Coordinate.Longitude"]);
            var isMobile = Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium');
            if (isMobile)  
            {
                mapsmall = new google.maps.Map(document.getElementById('mapsmall'), {center : pos, zoom: _zoomsmall, scrollwheel: false});                
                var locationtypes = gettypes(value);
                var iconsmall = { url: 'data:image/svg+xml;charset=UTF-8,' + encodeURIComponent(createicon(value,locationtypes, index+1)), scaledSize: new google.maps.Size(getmarkerwidth(locationtypes, false), getmarkerheight(false)) };

                var marker = new google.maps.Marker({
                    position: pos,
                    title: value.Name,
                    id: value.MapId,
                    icon: iconsmall,
                    map: mapsmall
                });

                setTimeout(function () { google.maps.event.trigger(mapsmall, 'resize'); }, googletimeout);
                
                var url = mapinfourl + id + searchdataparam;  
                $.ajax( {
                dataType: "json", 
                url: url,
                success: function (data) { 
					$('#locationdetailscontainerm').empty();
                    var html = formatMobileDetails(data);
                    $(html).appendTo($('#locationdetailscontainerm'));
                    //also do something else when clicking on the map, deeplinking ?
                    $('#mobilelocationdetails').slideToggle("slow");
                    google.maps.event.trigger(mapsmall, 'resize');
                    mapsmall.setCenter(marker.getPosition())
                }
                });
            } 
            else
            {
                //open map marker
                var url = mapinfourl + id + searchdataparam;  
                $.ajax( {
                dataType: "json", 
                url: url,
                success: function (data) { 
					if (initCustomInfoWindow)
                    {
                        google.maps.event.addListener(infoWindow, 'domready', function() {
                            var iwOuter = $('.gm-style-iw');
                            var gclose = iwOuter.next();
                            gclose.css('display', 'none');
                            var iwBackground = iwOuter.prev();
                            iwBackground.children(':nth-child(2)').css({'display' : 'none'});
                            iwBackground.children(':nth-child(4)').css({'display' : 'none'});
                        });
                        initCustomInfoWindow = false;
                    }

                    infoWindow.setContent(formatMarkerText(data));
                    infoWindow.setPosition(pos);
					var markerPopup = getMarker(id);
					var temptitle = markerPopup.title.replace(/'/g, "\\'");					
					var gmnoprintdiv = $("div[title|='"+temptitle+"']");
					var selectedTitle = $(gmnoprintdiv[0]);
					if(selectedTitle.css('opacity') == 0.01)
					{
						selectedTitle.css({'opacity' : '1.0'}); 
					}
					else
					{
						selectedTitle.css({'opacity' : '0.01'});
					}
					//markerPopup.setOptions({'opacity': 1.0})
					//markers.push(markerPopup);
					infoWindow.open(map, markerPopup);
                }
                });

            }
        })(jQuery);
    };

    function branchnavi(index, selectedfilter)
    {
        (function($) {
            if (index < 0)
            {
                return;
            }
            if (index > _totalPages-1)
            {
                return;
            }
            
            _currentPageIndex = index;
            $('#mapresults').empty();
            $('#mobileresults').empty();
            var offset = index * _prPage;
            for (var i = offset;i < offset + _prPage;i++)
            {
				var isMobile = Boolean(Foundation.MediaQuery.current === 'small' || Foundation.MediaQuery.current === 'medium');
				if (isMobile)
				{
					if (i < mapdata.length)
					{
						generateListItem(mapdata[i], "#mobileresults", i+1, selectedfilter);
					}
				}
				else
				{
					if (i < mapdata.length)
					{
						 generateListItem(mapdata[i], "#mapresults", i+1, selectedfilter);
					}
				}
                 //if (i < mapdata.length)
                 //{
                  //   generateListItem(mapdata[i], "#mapresults", i+1);
                 //}
            }

            var prev = $('.light-blue-color.previously');
            var next = $('.light-blue-color.next');
            
            if (_totalPages == (_currentPageIndex+1)) 
            {
                next.css('opacity', '0.2');
            }
            else
            {
                next.css('opacity', '1');
            }

            if (_currentPageIndex == 0)
            {
                prev.css('opacity', '0.2');
            }
            else
            {
                prev.css('opacity', '1');
            }
        })(jQuery);
    }

    function gettypes(location)
    {
        var types = [];
        for (var i=0;i<labels.Types.length;i++)
        {
            if (location.Types.indexOf(labels.Types[i].Id) != -1)
            {
                types.push(labels.Types[i]);
            }
        }
        return types;
    }
		
	function getselectedtypes(location, selectedlocations)
    {
		var types = [];
        var split_selectedlocations = selectedlocations.split(",");
		for (i = 0; i < split_selectedlocations.length; ++i) 
		{
          if(split_selectedlocations[i].substring(0,1)=="_")
		  {		
		    split_selectedlocations[i]=split_selectedlocations[i].substring(1);
		  }
		}
		for (var i=0;i<labels.Types.length;i++)
		{
			if (split_selectedlocations.indexOf(labels.Types[i].Id) !== -1) 
			{
				if (location.Types.indexOf(labels.Types[i].Id) != -1)
				{
					types.push(labels.Types[i]);
				}
			}
				
		}
	    return types;
    }
	

    function getMarker(mapid)
    {
        for (var i=0;i<markers.length;i++)
        {
            if (markers[i].id == mapid)
            {
                return markers[i];
            }
        }
    }

    function getLocationData(mapid)
    {
        for (var i=0;i<mapdata.length;i++)
        {
            if (mapdata[i].MapId == mapid)
            {
                return mapdata[i];
            }
        }
    }

    function smallicon(mapid)
    {
        getMarker(mapid).setIcon(getLocationData(mapid).iconsmall);
    }

    function largeicon(mapid)
    {
        getMarker(mapid).setIcon(getLocationData(mapid).iconlarge);
    }

    function round(value, decimals) {
        return Number(Math.round(value+'e'+decimals)+'e-'+decimals);
    }

    function getbranchtypenames(types) 
    {
        var str = "";
        for(var i=0;i<types.length;i++)
        {
            if(_country === "FI" && types[i].Name.toLowerCase() === "yrityspalvelut" && i > 0) continue;
            if (str !== "")
            {
                str += ', ';
            }
			if (_country == "LT" && types[i].Name == "Private")
			{
				str += 'Cash in/out ATM' + "'"+ 's';
            }
			else
			{
				str += types[i].Name;
			}
        }
        return str;
    }
	
	function getbranchtypeselectednames(selectedtypes) 
    {
        var strFilters = "";
		if(selectedtypes !== "")
		{
			var split_selectedfilters = selectedtypes.split(",");
			for (i = 0; i < split_selectedfilters.length; ++i) 
			{
				if(split_selectedfilters[i].substring(0,1)=="_")
				{		
					split_selectedfilters[i]=split_selectedfilters[i].substring(1);
				}
			}
			for (var i=0;i<labels.Types.length;i++)
			{
				if (split_selectedfilters.indexOf(labels.Types[i].Id) !== -1) 
				{
					if (strFilters !== "")
					{
						strFilters += ',';
					}
					strFilters += labels.Types[i].FilterDisplayName.replace(/ /g,"-");
				}
						
			}
		}
	    return strFilters;
    }
	
    function getfilterstypeselectednames(selectedfilters) 
    {
        var strFilters = "";
		if(selectedfilters !== "")
		{
			var split_selectedfilters = selectedfilters.split(",");
			for (i = 0; i < split_selectedfilters.length; ++i) 
			{
				if(split_selectedfilters[i].substring(0,1)=="_")
				{		
					split_selectedfilters[i]=split_selectedfilters[i].substring(1);
				}
			}
			for (var i=0;i<labels.Filters.length;i++)
			{
				if (split_selectedfilters.indexOf(labels.Filters[i].Id) !== -1) 
				{
					if (strFilters !== "")
					{
						strFilters += ',';
					}
					strFilters += labels.Filters[i].FilterDisplayName.replace(/ /g,"-");
				}
						
			}
		}
	    return strFilters;
    }
	
	function getBranchFiltersForTracking(locationtypes, filters) {
		var result = {};
		if (locationtypes.length > 0) {
			result["Location Types"] = getbranchtypeselectednames(locationtypes);
		}
		if (filters.length > 0) {
			result["Filters"] = getfilterstypeselectednames(filters);
		}
		return Object.keys(result).length > 0 ? result : void 0;
	}
	
    function getinfobox(a, id) {
        for (var i = 0; i < a.length; i++) {
            if (a[i].Id === id) {
                return a[i];
            }
        }
    }

    function createicon(location, types, number, large) 
    {
        if (types.length == 1) 
        {
            return createsingleicon(number, types[0].Color, types[0].Id, large);
        } 
        if (types.length == 2) 
        {
            return createdoubleicon(number, types[0].Color, types[1].Color, large);
        }
        if (types.length == 3) 
        {
            return createtripleicon(number, types[0].Color, types[1].Color, types[2].Color, large);
        } 
        if (types.length == 4) 
        {
            return createquadrupleicon(number, types[0].Color, types[1].Color, types[2].Color, types[3].Color, large);
        } 
    }

    function getmarkerheight(large)
    {
        if (large) 
        {
            return 32;
        } 
        return 30;
    }

    function getmarkerwidth(types, large) 
    {
        if (large)
        {
            if (types.length == 1) 
            {
                return 32;
            } 
            if (types.length == 2) 
            {
                return 36;
            }
            if (types.length == 3) 
            {
                return 44;
            } 
            if (types.length == 4) 
            {
                return 50;
            } 
        }
        else
        {
            if (types.length == 1) 
            {
                return 30;
            } 
            if (types.length == 2) 
            {
                return 38;
            }
            if (types.length == 3) 
            {
                return 42;
            } 
            if (types.length == 4) 
            {
                return 48;
            } 
        }
    }

    function createsingleicon(number, first, typeId, large) {
		var s = 30;
        var tx = 28;
        var ty = 23;
        var c = 15;
        var nx = 15;
        var ny = 20.5;	
		if(typeId == "{7699B67B-8B90-4830-A262-44088E357403}")
		{
            s = 30; 
            tx = 28;
            ty = 23;
            c = 14;
            nx = 14.5;
            ny = 20.5;
		}
		        
        if (large) {
            s = 32; 
            tx = 170;
            ty = 21;
            c = 16;
            nx = 15.5;
            ny = 22;
        }

        return '<?xml version="1.0" encoding="UTF-8" standalone="no"?>' +
        '<svg width="'+s+'px" height="'+s+'px" viewBox="0 0 '+s+' '+s+'" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">' +
            '<g id="a.Search_desktop" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">' +
                '<g id="-Artboard" transform="translate(-'+tx+', -'+ty+')" fill="'+first+'">' +
                    '<g id="Single-/-left-column-+-normal-on-map" transform="translate('+tx+', '+ty+')">' +
                        '<circle cx="'+c+'" cy="'+c+'" r="'+c+'"></circle>' +
                        '<text font-size="12pt" font-weight="normal" fill="white" font-style="normal" font-family="DanskeTextv2, sans-serif" text-anchor="middle" x="'+nx+'" y="'+ny+'">'+number+'</text>' +
                    '</g>' +
                '</g>' +
            '</g>' +
        '</svg>';
    }

    function createdoubleicon(number, first, second, large) {
        var sw = 30;
        var sh = 36;
        var tx = 28;
        var ty = 71;
        var cx = 15;
        var cy = 21;
        var nx = 14.5;
        var ny = 20.5;
        
        if (large) {
            sw = 32; 
            sh = 38;
            tx = 170;
            ty = 69;
            cx = 16;
            cy = 22;
            nx = 15.5;
            ny = 22;
        }

        return '<?xml version="1.0" encoding="UTF-8" standalone="no"?>' +
        '<svg width="'+sh+'px" height="'+sw+'px" viewBox="0 0 '+sh+' '+sw+'" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">' +
            '<g id="a.Search_desktop" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">' +
                '<g id="-Artboard" transform="translate(-'+tx+', -'+ty+')">' +
                    '<g id="Double-/-left-column-+-normal-on-map" transform="translate('+tx+', '+ty+')">' +
                        '<circle id="Oval-3-Copy-4" fill="'+second+'" cx="'+cy+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<circle id="Oval-3-Copy-4" fill="'+first+'" cx="'+cx+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<text font-size="12pt" font-weight="normal" fill="white" font-style="normal" font-family="DanskeTextv2, sans-serif" text-anchor="middle" x="'+nx+'" y="'+ny+'">'+number+'</text>' +
                    '</g>' +
                '</g>' +
            '</g>' +
        '</svg>';
    }

    function createtripleicon(number, first, second, third, large) {
        var sw = 42;
        var sh = 30;
        var tx = 28;
        var ty = 119;
        var cx = 15;
        var cy = 21;
        var nx = 14.5;
        var ny = 20.5;
        var cx1 = 21;
        var cx2 = 27;
        
        if (large) {
            sw = 44; 
            sh = 32;
            tx = 170;
            ty = 117;
            cx = 16;
            cy = 22;
            nx = 15.5;
            ny = 22;
            cx1 = 22;
            cx2 = 28;
        }
        return '<?xml version="1.0" encoding="UTF-8" standalone="no"?>' +
        '<svg width="'+sw+'px" height="'+sh+'px" viewBox="0 0 '+sw+' '+sh+'" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">' +
            '<g id="a.Search_desktop" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">' +
                '<g id="-Artboard" transform="translate(-'+tx+', -'+ty+')">' +
                    '<g id="Triple-/-left-column-+-normal-on-map" transform="translate('+tx+', '+ty+')">' +
                        '<circle id="Oval-3-Copy-4" fill="'+third+'" cx="'+cx2+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<circle id="Oval-3-Copy-4" fill="'+second+'" cx="'+cx1+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<circle id="Oval-3-Copy-4" fill="'+first+'" cx="'+cx+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<text font-size="12pt" font-weight="normal" fill="white" font-style="normal" font-family="DanskeTextv2, sans-serif" text-anchor="middle" x="'+nx+'" y="'+ny+'">'+number+'</text>' +
                    '</g>' +
                '</g>' +
            '</g>' +
        '</svg>';
    }
    function createquadrupleicon(number, first, second, third, fourth, large) {
        var sw = 48;
        var sh = 30;
        var tx = 28;
        var ty = 163;
        var cx = 15;
        var cy = 21;
        var nx = 14.5;
        var ny = 20.5;
        var cx1 = 21;
        var cx2 = 27;
        var cx3 = 33;

        if (large) {
            sw = 50; 
            sh = 32;
            tx = 170;
            ty = 161;
            cx = 16;
            cy = 22;
            nx = 15.5;
            ny = 22;
            cx1 = 22;
            cx2 = 28;
            cx3 = 34;
        }
        return '<?xml version="1.0" encoding="UTF-8" standalone="no"?>' +
        '<svg width="'+sw+'px" height="'+sh+'px" viewBox="0 0 '+sw+' '+sh+'" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">' +
            '<g id="a.Search_desktop" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">' +
                '<g id="-Artboard" transform="translate(-'+tx+', -'+ty+')">' +
                    '<g id="Four-rounds-/-left-column-+-normal-on-map" transform="translate('+tx+', '+ty+')">' +
                        '<circle id="Oval-3-Copy-4" fill="'+first+'" cx="'+cx3+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<circle id="Oval-3-Copy-4" fill="'+second+'" cx="'+cx2+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<circle id="Oval-3-Copy-4" fill="'+third+'" cx="'+cx1+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<circle id="Oval-3-Copy-4" fill="'+fourth+'" cx="'+cx+'" cy="'+cx+'" r="'+cx+'"></circle>' +
                        '<text font-size="12pt" font-weight="normal" fill="white" font-style="normal" font-family="DanskeTextv2, sans-serif" text-anchor="middle" x="'+nx+'" y="'+ny+'">'+number+'</text>' +
                    '</g>' +
                '</g>' +
            '</g>' +
        '</svg>';
    }